/*
 * Decompiled with CFR 0.152.
 */
package io.github.elytra.copo.item;

import com.google.common.collect.Maps;
import io.github.elytra.copo.CoPo;
import io.github.elytra.copo.network.StartWeldthrowingMessage;
import java.util.List;
import java.util.Map;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.network.Packet;
import net.minecraft.util.ActionResult;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EntityDamageSource;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumHand;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.text.translation.I18n;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.PlayerEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import org.apache.commons.lang3.mutable.MutableInt;

public class ItemWeldthrower
extends Item {
    public Map<EntityPlayer, MutableInt> weldthrowing = Maps.newIdentityHashMap();

    public ItemWeldthrower() {
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    public void func_77624_a(ItemStack stack, EntityPlayer playerIn, List<String> tooltip, boolean advanced) {
        super.func_77624_a(stack, playerIn, tooltip, advanced);
        int i = 0;
        while (I18n.func_94522_b((String)("tooltip.correlatedpotentialistics.weldthrower." + i))) {
            tooltip.add(I18n.func_74838_a((String)("tooltip.correlatedpotentialistics.weldthrower." + i)));
            ++i;
        }
    }

    public boolean doesSneakBypassUse(ItemStack stack, IBlockAccess world, BlockPos pos, EntityPlayer player) {
        return true;
    }

    public ActionResult<ItemStack> func_77659_a(ItemStack itemStack, World world, EntityPlayer player, EnumHand hand) {
        if (!(hand != EnumHand.MAIN_HAND || world.field_72995_K || this.weldthrowing.containsKey(player) || !player.field_71075_bZ.field_75098_d && player.field_71071_by.func_174925_a((Item)CoPo.misc, 5, 1, null) <= 0)) {
            world.func_184148_a(null, player.field_70165_t, player.field_70163_u, player.field_70161_v, CoPo.weldthrow, SoundCategory.PLAYERS, 0.4f, 1.0f);
            this.weldthrowing.put(player, new MutableInt());
            if (world instanceof WorldServer && player instanceof EntityPlayerMP) {
                WorldServer srv = (WorldServer)world;
                StartWeldthrowingMessage msg = new StartWeldthrowingMessage();
                msg.entityId = player.func_145782_y();
                Packet p = CoPo.inst.network.getPacketFrom((IMessage)msg);
                ((EntityPlayerMP)player).field_71135_a.func_147359_a(p);
                srv.func_73039_n().func_151247_a((Entity)player, p);
            }
            return ActionResult.newResult((EnumActionResult)EnumActionResult.SUCCESS, (Object)itemStack);
        }
        return super.func_77659_a(itemStack, world, player, hand);
    }

    @SubscribeEvent
    public void onPlayerTick(TickEvent.PlayerTickEvent e) {
        if (this.weldthrowing.containsKey(e.player)) {
            AxisAlignedBB aabb;
            MutableInt mi = this.weldthrowing.get(e.player);
            mi.increment();
            if (mi.intValue() > 65 || !e.player.func_70089_S()) {
                this.weldthrowing.remove(e.player);
                return;
            }
            CoPo.proxy.weldthrowerTick(e.player);
            if (!CoPo.inst.weldthrowerHurts) {
                return;
            }
            Vec3d look = e.player.func_70040_Z();
            Vec3d right = look.func_178785_b(-90.0f);
            double dist = 0.5;
            double gap = 0.6;
            look.func_178785_b(20.0f);
            Vec3d cursor = new Vec3d(e.player.field_70165_t + right.field_72450_a * dist + look.field_72450_a * gap, e.player.field_70163_u + ((double)e.player.func_70047_e() - 0.1) + right.field_72448_b * dist + look.field_72448_b * gap, e.player.field_70161_v + right.field_72449_c * dist + look.field_72449_c * gap);
            for (int i = 0; i < Math.min(mi.intValue() / 4, 10) && !e.player.field_70170_p.func_184143_b(aabb = new AxisAlignedBB(cursor.field_72450_a - 0.1, cursor.field_72448_b - 0.1, cursor.field_72449_c - 0.1, cursor.field_72450_a + 0.1, cursor.field_72448_b + 0.1, cursor.field_72449_c + 0.1)); ++i) {
                aabb = aabb.func_186662_g(0.9);
                for (Entity ent : e.player.field_70170_p.func_72839_b((Entity)e.player, aabb)) {
                    if (!(ent instanceof EntityLivingBase)) continue;
                    EntityLivingBase elb = (EntityLivingBase)ent;
                    elb.func_70015_d(4);
                    elb.func_70097_a((DamageSource)new EntityDamageSource("correlatedpotentialistics.weld", (Entity)e.player), 2.0f);
                }
                cursor = cursor.func_178787_e(look);
            }
        }
    }

    @SubscribeEvent
    public void onPlayerLoggedOut(PlayerEvent.PlayerLoggedOutEvent e) {
        this.weldthrowing.remove(e.player);
    }
}

