/*
 * Decompiled with CFR 0.152.
 */
package io.github.elytra.copo.item;

import com.google.common.collect.Lists;
import io.github.elytra.copo.CoPo;
import io.github.elytra.copo.client.ClientProxy;
import io.github.elytra.copo.helper.ItemStacks;
import io.github.elytra.copo.helper.Numbers;
import java.awt.Color;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.translation.I18n;
import net.minecraft.world.World;

public class ItemDrive
extends Item {
    private final int[] tierColors = new int[]{16717636, 16748800, 7798531, 1960374, 13959417};
    private final int[] tierSizes = new int[]{8192, 32768, 131072, 524288, -1};
    private final int[] tierAllocSizes = new int[]{64, 256, 1024, 4096, 0};

    public ItemDrive() {
        this.func_77625_d(1);
    }

    public int getFullnessColor(ItemStack stack) {
        boolean dirty;
        boolean bl = dirty = stack.func_77942_o() && stack.func_77978_p().func_74767_n("Dirty") && field_77697_d.nextBoolean();
        if (dirty && field_77697_d.nextInt(20) == 0) {
            stack.func_77978_p().func_82580_o("Dirty");
        }
        if (stack.func_77952_i() == 4) {
            if (dirty) {
                return 0xFF00FF;
            }
            float sin = (MathHelper.func_76126_a((float)(ClientProxy.ticks / 20.0f)) + 2.5f) / 5.0f;
            int r = (int)(sin * 192.0f) & 0xFF;
            int g = 0;
            int b = (int)(sin * 255.0f) & 0xFF;
            return r << 16 | g << 8 | b;
        }
        float usedTypes = (float)this.getTypesUsed(stack) / (float)this.getMaxTypes(stack);
        float usedBits = (float)this.getBitsUsed(stack) / (float)this.getMaxBits(stack);
        float both = (usedTypes + usedBits) / 2.0f;
        float hue = 0.33333334f * (1.0f - both);
        return Color.HSBtoRGB(hue, 1.0f, dirty ? 1.0f : 0.65f);
    }

    public int getTierColor(ItemStack stack) {
        return this.tierColors[stack.func_77952_i() % this.tierColors.length];
    }

    public int getBaseColor(ItemStack stack) {
        return stack.func_77952_i() == 4 ? 3218322 : 6323595;
    }

    public void func_77624_a(ItemStack stack, EntityPlayer playerIn, List<String> tooltip, boolean advanced) {
        tooltip.add(I18n.func_74837_a((String)"tooltip.correlatedpotentialistics.rf_usage", (Object[])new Object[]{this.getRFConsumptionRate(stack)}));
        if (stack.func_77952_i() == 4) {
            int i = 0;
            while (I18n.func_94522_b((String)("tooltip.correlatedpotentialistics.void_drive." + i))) {
                tooltip.add(I18n.func_74837_a((String)("tooltip.correlatedpotentialistics.void_drive." + i), (Object[])new Object[0]));
                ++i;
            }
        } else {
            int typesUsed = this.getTypesUsed(stack);
            int typesMax = this.getMaxTypes(stack);
            int bytesUsed = this.getBitsUsed(stack) / 8;
            int bytesMax = this.getMaxBits(stack) / 8;
            int typesPercent = (int)((double)typesUsed / (double)typesMax * 100.0);
            int bytesPercent = (int)((double)bytesUsed / (double)bytesMax * 100.0);
            tooltip.add(I18n.func_74837_a((String)"tooltip.correlatedpotentialistics.types_used", (Object[])new Object[]{typesUsed, typesMax, typesPercent}));
            tooltip.add(I18n.func_74837_a((String)"tooltip.correlatedpotentialistics.bytes_used", (Object[])new Object[]{Numbers.humanReadableBytes(bytesUsed), Numbers.humanReadableBytes(bytesMax), bytesPercent}));
        }
    }

    public int getRFConsumptionRate(ItemStack stack) {
        if (stack.func_77952_i() == 4) {
            return CoPo.inst.voidDriveUsage;
        }
        int dmg = stack.func_77952_i() + 1;
        return (int)Math.pow(CoPo.inst.driveRfUsagePow, dmg) / CoPo.inst.driveRfUsageDiv;
    }

    public boolean func_77614_k() {
        return true;
    }

    public String func_77667_c(ItemStack stack) {
        return super.func_77667_c(stack) + "." + stack.func_77952_i();
    }

    public void func_150895_a(Item itemIn, CreativeTabs tab, List<ItemStack> subItems) {
        for (int i = 0; i < this.tierColors.length; ++i) {
            subItems.add(new ItemStack(itemIn, 1, i));
        }
    }

    public int getMaxTypes(ItemStack stack) {
        return 64;
    }

    public int getMaxBits(ItemStack stack) {
        return this.tierSizes[stack.func_77952_i() % this.tierSizes.length];
    }

    public int getTypeAllocationBits(ItemStack stack) {
        return this.tierAllocSizes[stack.func_77952_i() % this.tierSizes.length];
    }

    public Priority getPriority(ItemStack stack) {
        return (Priority)((Object)ItemStacks.getEnum(stack, "Priority", Priority.class).or((Object)Priority.DEFAULT));
    }

    public void setPriority(ItemStack stack, Priority priority) {
        ItemStacks.ensureHasTag(stack).func_77978_p().func_74778_a("Priority", priority.name());
    }

    public PartitioningMode getPartitioningMode(ItemStack stack) {
        return (PartitioningMode)((Object)ItemStacks.getEnum(stack, "PartitioningMode", PartitioningMode.class).or((Object)PartitioningMode.NONE));
    }

    public void setPartitioningMode(ItemStack stack, PartitioningMode mode) {
        ItemStacks.ensureHasTag(stack).func_77978_p().func_74778_a("PartitioningMode", mode.name());
    }

    public void markDirty(ItemStack stack) {
        ItemStacks.ensureHasTag(stack).func_77978_p().func_74757_a("Dirty", true);
    }

    public ActionResult<ItemStack> func_77659_a(ItemStack itemStackIn, World worldIn, EntityPlayer playerIn, EnumHand hand) {
        playerIn.openGui((Object)CoPo.inst, 1, worldIn, playerIn.field_71071_by.field_70461_c, 0, 0);
        return ActionResult.newResult((EnumActionResult)EnumActionResult.SUCCESS, (Object)itemStackIn);
    }

    public int getTypesUsed(ItemStack stack) {
        if (!stack.func_77942_o() || !stack.func_77978_p().func_150297_b("Data", 9)) {
            return 0;
        }
        return ItemStacks.getCompoundList(stack, "Data").func_74745_c();
    }

    public int getBitsUsed(ItemStack stack) {
        if (!stack.func_77942_o() || !stack.func_77978_p().func_150297_b("Data", 9)) {
            return 0;
        }
        NBTTagList list = ItemStacks.getCompoundList(stack, "Data");
        int used = 0;
        for (int i = 0; i < list.func_74745_c(); ++i) {
            used += this.getTypeAllocationBits(stack);
            used += list.func_150305_b(i).func_74762_e("Count");
        }
        return used;
    }

    public int getBitsFree(ItemStack stack) {
        if (this.getMaxBits(stack) == -1) {
            return Integer.MAX_VALUE;
        }
        return this.getMaxBits(stack) - this.getBitsUsed(stack);
    }

    protected NBTTagCompound createPrototype(ItemStack item) {
        if (item == null) {
            return null;
        }
        NBTTagCompound prototype = item.func_77955_b(new NBTTagCompound());
        prototype.func_82580_o("Count");
        return prototype;
    }

    protected NBTTagCompound findDataForPrototype(ItemStack drive, NBTTagCompound prototype) {
        int index = this.findDataIndexForPrototype(drive, prototype);
        if (index == -1) {
            return null;
        }
        return ItemStacks.getCompoundList(drive, "Data").func_150305_b(index);
    }

    protected int findDataIndexForPrototype(ItemStack drive, NBTTagCompound prototype) {
        if (prototype == null) {
            return -1;
        }
        NBTTagList list = ItemStacks.getCompoundList(drive, "Data");
        for (int i = 0; i < list.func_74745_c(); ++i) {
            NBTTagCompound tag = list.func_150305_b(i);
            if (!tag.func_74775_l("Prototype").equals((Object)prototype)) continue;
            return i;
        }
        return -1;
    }

    public int getBitsFreeFor(ItemStack drive, ItemStack item) {
        if (this.getMaxBits(drive) == -1) {
            return Integer.MAX_VALUE;
        }
        NBTTagCompound data = this.findDataForPrototype(drive, this.createPrototype(item));
        if (data != null) {
            return this.getBitsFree(drive);
        }
        if (this.getPartitioningMode(drive) == PartitioningMode.NONE && this.getTypesUsed(drive) < this.getMaxTypes(drive)) {
            return Math.max(0, this.getBitsFree(drive) - this.getTypeAllocationBits(drive));
        }
        return 0;
    }

    public ItemStack addItem(ItemStack drive, ItemStack item) {
        if (this.getMaxBits(drive) == -1) {
            if (this.getPartitioningMode(drive) == PartitioningMode.NONE || this.findDataIndexForPrototype(drive, this.createPrototype(item)) != -1) {
                item.field_77994_a = 0;
                return null;
            }
            return item;
        }
        int bitsFree = this.getBitsFreeFor(drive, item);
        int amountTaken = Math.min(item.field_77994_a, bitsFree);
        int current = this.getAmountStored(drive, item);
        if (amountTaken > 0) {
            this.setAmountStored(drive, item, current + amountTaken);
            item.field_77994_a -= amountTaken;
            this.markDirty(drive);
        }
        if (item.field_77994_a <= 0) {
            return null;
        }
        return item;
    }

    public ItemStack removeItems(ItemStack drive, ItemStack stack, int amountWanted) {
        if (this.getMaxBits(drive) == -1) {
            return null;
        }
        int stored = this.getAmountStored(drive, stack);
        int amountGiven = Math.min(amountWanted, stored);
        if (amountGiven > 0) {
            this.setAmountStored(drive, stack, stored - amountGiven);
            stack.field_77994_a += amountGiven;
            this.markDirty(drive);
        }
        return stack;
    }

    public int getAmountStored(ItemStack drive, ItemStack item) {
        if (this.getMaxBits(drive) == -1) {
            return 0;
        }
        NBTTagCompound data = this.findDataForPrototype(drive, this.createPrototype(item));
        if (data == null) {
            return 0;
        }
        return data.func_74762_e("Count");
    }

    public void setAmountStored(ItemStack drive, ItemStack item, int amount) {
        if (this.getMaxBits(drive) == -1) {
            return;
        }
        NBTTagCompound prototype = this.createPrototype(item);
        NBTTagList list = ItemStacks.getCompoundList(drive, "Data");
        int index = this.findDataIndexForPrototype(drive, prototype);
        if (index == -1) {
            this.allocateType(drive, item, item.field_77994_a);
        } else if (amount <= 0 && this.getPartitioningMode(drive) == PartitioningMode.NONE) {
            this.deallocateType(drive, item);
        } else {
            list.func_150305_b(index).func_74768_a("Count", amount);
        }
        this.markDirty(drive);
    }

    public List<ItemStack> getPrototypes(ItemStack drive) {
        NBTTagList list = ItemStacks.getCompoundList(drive, "Data");
        ArrayList rtrn = Lists.newArrayList();
        for (int i = 0; i < list.func_74745_c(); ++i) {
            NBTTagCompound tag = list.func_150305_b(i);
            ItemStack is = ItemStack.func_77949_a((NBTTagCompound)tag.func_74775_l("Prototype"));
            if (is == null) {
                list.func_74744_a(i);
                continue;
            }
            rtrn.add(is);
        }
        return rtrn;
    }

    public List<ItemStack> getTypes(ItemStack drive) {
        if (this.getMaxBits(drive) == -1) {
            return Lists.newArrayList();
        }
        NBTTagList list = ItemStacks.getCompoundList(drive, "Data");
        ArrayList rtrn = Lists.newArrayList();
        for (int i = 0; i < list.func_74745_c(); ++i) {
            NBTTagCompound tag = list.func_150305_b(i);
            int count = tag.func_74762_e("Count");
            if (count <= 0) continue;
            ItemStack is = ItemStack.func_77949_a((NBTTagCompound)tag.func_74775_l("Prototype"));
            if (is == null) {
                list.func_74744_a(i);
                continue;
            }
            is.field_77994_a = count;
            rtrn.add(is);
        }
        return rtrn;
    }

    public void allocateType(ItemStack drive, ItemStack item, int count) {
        NBTTagCompound prototype = this.createPrototype(item);
        int idx = this.findDataIndexForPrototype(drive, prototype);
        if (idx == -1) {
            NBTTagCompound data = new NBTTagCompound();
            data.func_74782_a("Prototype", (NBTBase)prototype);
            data.func_74768_a("Count", count);
            ItemStacks.getCompoundList(drive, "Data").func_74742_a((NBTBase)data);
            this.markDirty(drive);
        }
    }

    public void deallocateType(ItemStack drive, ItemStack item) {
        NBTTagCompound prototype = this.createPrototype(item);
        int idx = this.findDataIndexForPrototype(drive, prototype);
        if (idx != -1) {
            ItemStacks.getCompoundList(drive, "Data").func_74744_a(idx);
            this.markDirty(drive);
        }
    }

    public static enum PartitioningMode {
        NONE,
        WHITELIST;

        public final String lowerName = this.name().toLowerCase(Locale.ROOT);
    }

    public static enum Priority {
        HIGHEST(TextFormatting.RED),
        HIGHER(TextFormatting.DARK_RED),
        HIGH(TextFormatting.GRAY),
        DEFAULT(TextFormatting.GRAY),
        LOW(TextFormatting.GRAY),
        LOWER(TextFormatting.DARK_GREEN),
        LOWEST(TextFormatting.GREEN);

        public final String lowerName = this.name().toLowerCase(Locale.ROOT);
        public final TextFormatting color;

        private Priority(TextFormatting color) {
            this.color = color;
        }
    }
}

