/*
 * Decompiled with CFR 0.152.
 */
package io.github.elytra.copo.helper;

import java.text.NumberFormat;
import net.minecraft.client.resources.I18n;

public class Numbers {
    public static final int GIBIBYTE = 0x40000000;
    public static final int MIBIBYTE = 0x100000;
    public static final int KIBIBYTE = 1024;
    public static final int GIGA = 1000000000;
    public static final int MEGA = 1000000;
    public static final int KILO = 1000;
    private static final NumberFormat formatter = NumberFormat.getNumberInstance();
    private static boolean formatterInitialized = false;

    public static String humanReadableBytes(int bytes) {
        if (bytes == 1) {
            return I18n.func_135052_a((String)"numbers.correlatedpotentialistics.byte", (Object[])new Object[0]);
        }
        if (bytes >= 0x40000000) {
            return I18n.func_135052_a((String)"numbers.correlatedpotentialistics.gibibytes", (Object[])new Object[]{bytes / 0x40000000});
        }
        if (bytes >= 0x100000) {
            return I18n.func_135052_a((String)"numbers.correlatedpotentialistics.mibibytes", (Object[])new Object[]{bytes / 0x100000});
        }
        if (bytes >= 1024) {
            return I18n.func_135052_a((String)"numbers.correlatedpotentialistics.kibibytes", (Object[])new Object[]{bytes / 1024});
        }
        return I18n.func_135052_a((String)"numbers.correlatedpotentialistics.bytes", (Object[])new Object[]{bytes});
    }

    public static String humanReadableItemCount(int count) {
        if (!formatterInitialized) {
            formatterInitialized = true;
            formatter.setMinimumFractionDigits(1);
            formatter.setMaximumFractionDigits(1);
        }
        if (count >= 1000000000) {
            return I18n.func_135052_a((String)"numbers.correlatedpotentialistics.giga", (Object[])new Object[]{formatter.format((double)count / 1.0E9)});
        }
        if (count >= 1000000) {
            return I18n.func_135052_a((String)"numbers.correlatedpotentialistics.mega", (Object[])new Object[]{formatter.format((double)count / 1000000.0)});
        }
        if (count >= 10000) {
            return I18n.func_135052_a((String)"numbers.correlatedpotentialistics.kilo", (Object[])new Object[]{formatter.format((double)count / 1000.0)});
        }
        return I18n.func_135052_a((String)"numbers.correlatedpotentialistics.normal", (Object[])new Object[]{count});
    }
}

