/*
 * Decompiled with CFR 0.152.
 */
package io.github.elytra.copo.helper;

import com.google.common.base.Optional;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;

public class ItemStacks {
    public static Optional<Integer> getInteger(ItemStack stack, String key) {
        if (!stack.func_77942_o()) {
            return Optional.absent();
        }
        if (!stack.func_77978_p().func_150297_b(key, 99)) {
            return Optional.absent();
        }
        return Optional.of((Object)stack.func_77978_p().func_74762_e(key));
    }

    public static Optional<Boolean> getBoolean(ItemStack stack, String key) {
        if (!stack.func_77942_o()) {
            return Optional.absent();
        }
        if (!stack.func_77978_p().func_150297_b(key, 99)) {
            return Optional.absent();
        }
        return Optional.of((Object)stack.func_77978_p().func_74767_n(key));
    }

    public static NBTTagCompound getSubCompound(ItemStack stack, String key) {
        ItemStacks.ensureHasTag(stack);
        if (!stack.func_77978_p().func_150297_b(key, 10)) {
            stack.func_77978_p().func_74782_a(key, (NBTBase)new NBTTagCompound());
        }
        return stack.func_77978_p().func_74775_l(key);
    }

    public static ItemStack ensureHasTag(ItemStack stack) {
        if (!stack.func_77942_o()) {
            stack.func_77982_d(new NBTTagCompound());
        }
        return stack;
    }

    public static NBTTagList getCompoundList(ItemStack stack, String key) {
        ItemStacks.ensureHasTag(stack);
        NBTTagList li = stack.func_77978_p().func_150295_c(key, 10);
        stack.func_77978_p().func_74782_a(key, (NBTBase)li);
        return li;
    }

    public static <T extends Enum<T>> Optional<T> getEnum(ItemStack stack, String key, Class<T> clazz) {
        if (!stack.func_77942_o()) {
            return Optional.absent();
        }
        if (!stack.func_77978_p().func_150297_b(key, 8)) {
            return Optional.absent();
        }
        String str = stack.func_77978_p().func_74779_i(key);
        try {
            return Optional.of(Enum.valueOf(clazz, str));
        }
        catch (IllegalArgumentException | NullPointerException e) {
            e.printStackTrace();
            return Optional.absent();
        }
    }
}

