/*
 * Decompiled with CFR 0.152.
 */
package io.github.elytra.copo.compat;

import io.github.elytra.copo.CoPo;
import io.github.elytra.copo.block.BlockWirelessEndpoint;
import io.github.elytra.copo.helper.Numbers;
import io.github.elytra.copo.item.ItemDrive;
import io.github.elytra.copo.tile.TileEntityController;
import io.github.elytra.copo.tile.TileEntityDriveBay;
import io.github.elytra.copo.tile.TileEntityInterface;
import io.github.elytra.copo.tile.TileEntityNetworkMember;
import java.util.List;
import mcp.mobius.waila.api.IWailaConfigHandler;
import mcp.mobius.waila.api.IWailaDataAccessor;
import mcp.mobius.waila.api.IWailaDataProvider;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class CoPoWailaProvider
implements IWailaDataProvider {
    public NBTTagCompound getNBTData(EntityPlayerMP player, TileEntity te, NBTTagCompound nbt, World world, BlockPos pos) {
        if (te instanceof TileEntityController) {
            TileEntityController tec = (TileEntityController)te;
            nbt.func_74768_a("Energy", tec.getEnergyStored(EnumFacing.UP));
            nbt.func_74768_a("MaxEnergy", tec.getMaxEnergyStored(EnumFacing.UP));
            if (tec.error && tec.errorReason != null) {
                nbt.func_74778_a("ErrorReason", tec.errorReason);
            } else if (tec.booting) {
                nbt.func_74768_a("BootTicks", tec.bootTicks);
            }
        }
        if (te instanceof TileEntityNetworkMember) {
            nbt.func_74768_a("EnergyPerTick", ((TileEntityNetworkMember)te).getEnergyConsumedPerTick());
            nbt.func_74757_a("HasController", ((TileEntityNetworkMember)te).hasController());
        }
        return nbt;
    }

    public List<String> getWailaBody(ItemStack stack, List<String> body, IWailaDataAccessor access, IWailaConfigHandler config) {
        NBTTagCompound nbt = access.getNBTData();
        if (access.getBlock() == CoPo.controller) {
            if (nbt.func_74764_b("ErrorReason")) {
                body.add("\u00a7c" + I18n.func_135052_a((String)("tooltip.correlatedpotentialistics.controller_error." + nbt.func_74779_i("ErrorReason")), (Object[])new Object[0]));
            } else if (nbt.func_74764_b("BootTicks") && nbt.func_74762_e("Energy") >= nbt.func_74762_e("EnergyPerTick")) {
                int bootTicks = nbt.func_74762_e("BootTicks");
                if (bootTicks < 0) {
                    body.add("\u00a7a" + I18n.func_135052_a((String)"tooltip.correlatedpotentialistics.controller_booting.hard", (Object[])new Object[0]));
                } else {
                    body.add("\u00a7a" + I18n.func_135052_a((String)"tooltip.correlatedpotentialistics.controller_booting", (Object[])new Object[0]));
                }
                int seconds = bootTicks >= 0 ? (100 - bootTicks) / 20 : (bootTicks * -1 + 100) / 20;
                if (seconds == 1) {
                    body.add("\u00a7a" + I18n.func_135052_a((String)"tooltip.correlatedpotentialistics.controller_boot_eta_one", (Object[])new Object[0]));
                } else {
                    body.add("\u00a7a" + I18n.func_135052_a((String)"tooltip.correlatedpotentialistics.controller_boot_eta", (Object[])new Object[]{seconds}));
                }
            }
            body.add(I18n.func_135052_a((String)"tooltip.correlatedpotentialistics.controller_consumption_rate", (Object[])new Object[]{nbt.func_74762_e("EnergyPerTick")}));
            body.add(I18n.func_135052_a((String)"tooltip.correlatedpotentialistics.controller_energy_buffer", (Object[])new Object[]{nbt.func_74762_e("Energy"), nbt.func_74762_e("MaxEnergy")}));
        } else if (access.getTileEntity() instanceof TileEntityNetworkMember) {
            if (nbt.func_74767_n("HasController")) {
                body.add(I18n.func_135052_a((String)"tooltip.correlatedpotentialistics.member_consumption_rate", (Object[])new Object[]{nbt.func_74762_e("EnergyPerTick")}));
            } else {
                body.add("\u00a7c" + I18n.func_135052_a((String)"tooltip.correlatedpotentialistics.no_controller", (Object[])new Object[0]));
            }
        }
        if (access.getTileEntity() instanceof TileEntityDriveBay) {
            TileEntityDriveBay tedb = (TileEntityDriveBay)access.getTileEntity();
            int totalBytesUsed = 0;
            int totalMaxBytes = 0;
            int totalTypesUsed = 0;
            int totalMaxTypes = 0;
            int driveCount = 0;
            for (int i = 0; i < 8; ++i) {
                if (!tedb.hasDriveInSlot(i)) continue;
                ++driveCount;
                ItemStack is = tedb.getDriveInSlot(i);
                if (!(is.func_77973_b() instanceof ItemDrive) || is.func_77952_i() == 4) continue;
                totalBytesUsed += ((ItemDrive)is.func_77973_b()).getBitsUsed(is) / 8;
                totalTypesUsed += ((ItemDrive)is.func_77973_b()).getTypesUsed(is);
                totalMaxBytes += ((ItemDrive)is.func_77973_b()).getMaxBits(is) / 8;
                totalMaxTypes += ((ItemDrive)is.func_77973_b()).getMaxTypes(is);
            }
            int totalTypesPercent = (int)((double)totalTypesUsed / (double)totalMaxTypes * 100.0);
            int totalBytesPercent = (int)((double)totalBytesUsed / (double)totalMaxBytes * 100.0);
            body.add(I18n.func_135052_a((String)"tooltip.correlatedpotentialistics.drive_count", (Object[])new Object[]{driveCount}));
            body.add(I18n.func_135052_a((String)"tooltip.correlatedpotentialistics.types_used", (Object[])new Object[]{totalTypesUsed, totalMaxTypes, totalTypesPercent}));
            body.add(I18n.func_135052_a((String)"tooltip.correlatedpotentialistics.bytes_used", (Object[])new Object[]{Numbers.humanReadableBytes(totalBytesUsed), Numbers.humanReadableBytes(totalMaxBytes), totalBytesPercent}));
        } else if (access.getTileEntity() instanceof TileEntityInterface) {
            TileEntityInterface tei = (TileEntityInterface)access.getTileEntity();
            EnumFacing side = access.getSide();
            body.add(I18n.func_135052_a((String)"tooltip.correlatedpotentialistics.side", (Object[])new Object[]{I18n.func_135052_a((String)("direction.correlatedpotentialistics." + side.func_176610_l()), (Object[])new Object[0])}));
            body.add(I18n.func_135052_a((String)"tooltip.correlatedpotentialistics.mode", (Object[])new Object[]{I18n.func_135052_a((String)("tooltip.correlatedpotentialistics.iface.mode_" + tei.getModeForFace(side).func_176610_l()), (Object[])new Object[0])}));
        }
        return body;
    }

    public List<String> getWailaHead(ItemStack stack, List<String> head, IWailaDataAccessor access, IWailaConfigHandler config) {
        return head;
    }

    public ItemStack getWailaStack(IWailaDataAccessor access, IWailaConfigHandler config) {
        if (access.getBlock() == CoPo.controller) {
            return new ItemStack(access.getBlock(), 1, access.getMetadata());
        }
        if (access.getBlock() == CoPo.wireless_endpoint) {
            return new ItemStack(access.getBlock(), 1, access.getBlockState().func_177229_b(BlockWirelessEndpoint.kind) == BlockWirelessEndpoint.Kind.RECEIVER ? 0 : 1);
        }
        return new ItemStack(access.getBlock());
    }

    public List<String> getWailaTail(ItemStack stack, List<String> tail, IWailaDataAccessor access, IWailaConfigHandler config) {
        return tail;
    }
}

