/*
 * Decompiled with CFR 0.152.
 */
package io.github.elytra.copo.client.gui;

import com.google.common.collect.Lists;
import io.github.elytra.copo.helper.Numbers;
import io.github.elytra.copo.inventory.ContainerDrive;
import io.github.elytra.copo.item.ItemDrive;
import java.io.IOException;
import java.util.ArrayList;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.resources.I18n;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.Slot;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.client.config.GuiButtonExt;

public class GuiDrive
extends GuiContainer {
    private static final ResourceLocation background = new ResourceLocation("correlatedpotentialistics", "textures/gui/container/drive_editor.png");
    private ContainerDrive container;
    private GuiButton priority;
    private GuiButton partition;

    public GuiDrive(ContainerDrive container) {
        super((Container)container);
        this.container = container;
        this.field_146999_f = 212;
        this.field_147000_g = 222;
        this.priority = new GuiButtonExt(0, 0, 0, 18, 18, "");
        this.partition = new GuiButtonExt(1, 0, 20, 18, 18, "");
    }

    public void func_73866_w_() {
        super.func_73866_w_();
        int x = (this.field_146294_l - this.field_146999_f) / 2;
        int y = (this.field_146295_m - this.field_147000_g) / 2;
        this.priority.field_146128_h = x + 7;
        this.priority.field_146129_i = y + 107;
        this.partition.field_146128_h = x + 187;
        this.partition.field_146129_i = this.priority.field_146129_i;
        this.field_146292_n.add(this.priority);
        this.field_146292_n.add(this.partition);
    }

    public void func_73876_c() {
        super.func_73876_c();
    }

    protected void func_146284_a(GuiButton button) throws IOException {
        if (button == this.priority) {
            this.field_146297_k.field_71442_b.func_78756_a(this.container.field_75152_c, 0);
        } else if (button == this.partition) {
            this.field_146297_k.field_71442_b.func_78756_a(this.container.field_75152_c, 2);
        }
    }

    protected void func_73864_a(int mouseX, int mouseY, int mouseButton) throws IOException {
        super.func_73864_a(mouseX, mouseY, mouseButton);
        if (this.priority.func_146115_a() && mouseButton == 1) {
            this.priority.func_146113_a(this.field_146297_k.func_147118_V());
            this.field_146297_k.field_71442_b.func_78756_a(this.container.field_75152_c, 1);
        }
    }

    protected void func_146976_a(float partialTicks, int mouseX, int mouseY) {
        GlStateManager.func_179094_E();
        GlStateManager.func_179109_b((float)((this.field_146294_l - this.field_146999_f) / 2), (float)((this.field_146295_m - this.field_147000_g) / 2), (float)0.0f);
        this.field_146297_k.func_110434_K().func_110577_a(background);
        this.func_73729_b(0, 0, 0, 0, 212, 222);
        GlStateManager.func_179121_F();
    }

    protected void func_146979_b(int mouseX, int mouseY) {
        FontRenderer renderer = this.container.getDrive().func_77973_b().getFontRenderer(this.container.getDrive());
        if (renderer == null) {
            renderer = this.field_146289_q;
        }
        renderer.func_78276_b(this.container.getDrive().func_82833_r(), 8, 6, 0x404040);
        this.field_146289_q.func_78276_b(I18n.func_135052_a((String)"gui.inventory", (Object[])new Object[0]), 8, 128, 0x404040);
        GlStateManager.func_179094_E();
        GlStateManager.func_179097_i();
        GlStateManager.func_179152_a((float)0.5f, (float)0.5f, (float)1.0f);
        for (int i = 1; i < 65; ++i) {
            Slot slot = (Slot)this.container.field_75151_b.get(i);
            if (!slot.func_75216_d()) continue;
            ItemStack stack = slot.func_75211_c();
            int stored = this.container.getItemDrive().getAmountStored(this.container.getDrive(), stack);
            if (stored <= 0) continue;
            String str = Numbers.humanReadableItemCount(stored);
            int x = slot.field_75223_e * 2;
            int y = slot.field_75221_f * 2;
            this.field_146297_k.field_71466_p.func_175063_a(str, (float)(x += 32 - this.field_146297_k.field_71466_p.func_78256_a(str)), (float)(y += 32 - this.field_146297_k.field_71466_p.field_78288_b), -1);
        }
        GlStateManager.func_179126_j();
        GlStateManager.func_179121_F();
        this.field_146297_k.func_110434_K().func_110577_a(background);
        int color = this.container.getItemDrive().getBaseColor(this.container.getDrive());
        GlStateManager.func_179124_c((float)((float)(color >> 16 & 0xFF) / 255.0f), (float)((float)(color >> 8 & 0xFF) / 255.0f), (float)((float)(color & 0xFF) / 255.0f));
        this.func_73729_b(195, 5, 222, 0, 10, 10);
        color = this.container.getItemDrive().getFullnessColor(this.container.getDrive());
        GlStateManager.func_179124_c((float)((float)(color >> 16 & 0xFF) / 255.0f), (float)((float)(color >> 8 & 0xFF) / 255.0f), (float)((float)(color & 0xFF) / 255.0f));
        this.func_73729_b(195, 5, 212, 0, 10, 10);
        GlStateManager.func_179124_c((float)1.0f, (float)1.0f, (float)1.0f);
        GlStateManager.func_179094_E();
        GlStateManager.func_179109_b((float)(-(this.field_146294_l - this.field_146999_f) / 2), (float)(-(this.field_146295_m - this.field_147000_g) / 2), (float)0.0f);
        ItemDrive.PartitioningMode part = this.container.getItemDrive().getPartitioningMode(this.container.getDrive());
        this.func_73729_b(this.partition.field_146128_h + 4, this.partition.field_146129_i + 2, 246, 13 + part.ordinal() * 13, 10, 13);
        ItemDrive.Priority pri = this.container.getItemDrive().getPriority(this.container.getDrive());
        this.func_73729_b(this.priority.field_146128_h + 4, this.priority.field_146129_i + 2, 246, 39 + pri.ordinal() * 13, 10, 13);
        if (this.partition.func_146115_a()) {
            ArrayList li = Lists.newArrayList((Object[])new String[]{I18n.func_135052_a((String)"gui.correlatedpotentialistics.partition_mode", (Object[])new Object[0]), "\u00a77" + I18n.func_135052_a((String)("gui.correlatedpotentialistics.partition_mode." + part.lowerName), (Object[])new Object[0])});
            this.func_146283_a(li, mouseX, mouseY);
        }
        if (this.priority.func_146115_a()) {
            ArrayList li = Lists.newArrayList((Object[])new String[]{I18n.func_135052_a((String)"gui.correlatedpotentialistics.priority", (Object[])new Object[0]), pri.color + I18n.func_135052_a((String)("gui.correlatedpotentialistics.priority." + pri.lowerName), (Object[])new Object[0])});
            this.func_146283_a(li, mouseX, mouseY);
        }
        GlStateManager.func_179121_F();
    }
}

