/*
 * Decompiled with CFR 0.152.
 */
package io.github.elytra.copo.client;

import com.google.common.collect.Lists;
import io.github.elytra.copo.CoPo;
import io.github.elytra.copo.Proxy;
import io.github.elytra.copo.client.ParticleWeldthrower;
import io.github.elytra.copo.client.render.RenderController;
import io.github.elytra.copo.client.render.RenderDriveBay;
import io.github.elytra.copo.client.render.RenderVT;
import io.github.elytra.copo.client.render.RenderWirelessReceiver;
import io.github.elytra.copo.client.render.RenderWirelessTransmitter;
import io.github.elytra.copo.item.ItemDrive;
import io.github.elytra.copo.item.ItemMisc;
import io.github.elytra.copo.tile.TileEntityController;
import io.github.elytra.copo.tile.TileEntityDriveBay;
import io.github.elytra.copo.tile.TileEntityVT;
import io.github.elytra.copo.tile.TileEntityWirelessReceiver;
import io.github.elytra.copo.tile.TileEntityWirelessTransmitter;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.client.renderer.color.IItemColor;
import net.minecraft.client.renderer.tileentity.TileEntitySpecialRenderer;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.Vec3d;
import net.minecraftforge.client.ForgeHooksClient;
import net.minecraftforge.client.event.TextureStitchEvent;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.client.registry.ClientRegistry;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;

public class ClientProxy
extends Proxy {
    public static float ticks = 0.0f;

    @Override
    public void preInit() {
        ClientRegistry.bindTileEntitySpecialRenderer(TileEntityController.class, (TileEntitySpecialRenderer)new RenderController());
        ClientRegistry.bindTileEntitySpecialRenderer(TileEntityDriveBay.class, (TileEntitySpecialRenderer)new RenderDriveBay());
        ClientRegistry.bindTileEntitySpecialRenderer(TileEntityVT.class, (TileEntitySpecialRenderer)new RenderVT());
        ClientRegistry.bindTileEntitySpecialRenderer(TileEntityWirelessReceiver.class, (TileEntitySpecialRenderer)new RenderWirelessReceiver());
        ClientRegistry.bindTileEntitySpecialRenderer(TileEntityWirelessTransmitter.class, (TileEntitySpecialRenderer)new RenderWirelessTransmitter());
        ForgeHooksClient.registerTESRItemStack((Item)Item.func_150898_a((Block)CoPo.wireless_endpoint), (int)0, TileEntityWirelessReceiver.class);
        ForgeHooksClient.registerTESRItemStack((Item)Item.func_150898_a((Block)CoPo.wireless_endpoint), (int)1, TileEntityWirelessTransmitter.class);
        MinecraftForge.EVENT_BUS.register((Object)this);
        int idx = 0;
        for (String s : ItemMisc.items) {
            ModelLoader.setCustomModelResourceLocation((Item)CoPo.misc, (int)idx++, (ModelResourceLocation)new ModelResourceLocation(new ResourceLocation("correlatedpotentialistics", s), "inventory"));
        }
    }

    @Override
    public void postInit() {
        Minecraft.func_71410_x().getItemColors().func_186730_a(new IItemColor(){

            public int func_186726_a(ItemStack stack, int tintIndex) {
                if (stack == null || !(stack.func_77973_b() instanceof ItemDrive)) {
                    return -1;
                }
                ItemDrive id = (ItemDrive)stack.func_77973_b();
                if (tintIndex == 1) {
                    return id.getFullnessColor(stack);
                }
                if (tintIndex == 2) {
                    return id.getTierColor(stack);
                }
                if (tintIndex == 3) {
                    switch (id.getPartitioningMode(stack)) {
                        case NONE: {
                            return 65450;
                        }
                        case WHITELIST: {
                            return 0xFFFFFF;
                        }
                    }
                } else if (tintIndex >= 4 && tintIndex <= 6) {
                    int uncolored = stack.func_77952_i() == 4 ? 0 : 0x555555;
                    int left = uncolored;
                    int middle = uncolored;
                    int right = uncolored;
                    switch (id.getPriority(stack)) {
                        case HIGHEST: {
                            right = 0xFF0000;
                        }
                        case HIGHER: {
                            middle = 0xFF0000;
                        }
                        case HIGH: {
                            left = 0xFF0000;
                            break;
                        }
                        case LOWEST: {
                            left = 65280;
                        }
                        case LOWER: {
                            middle = 65280;
                        }
                        case LOW: {
                            right = 65280;
                            break;
                        }
                    }
                    if (tintIndex == 4) {
                        return left;
                    }
                    if (tintIndex == 5) {
                        return middle;
                    }
                    if (tintIndex == 6) {
                        return right;
                    }
                }
                return id.getBaseColor(stack);
            }
        }, new Item[]{CoPo.drive});
    }

    @Override
    public void registerItemModel(Item item, int variants) {
        block4: {
            ResourceLocation loc;
            block5: {
                block3: {
                    loc = (ResourceLocation)Item.field_150901_e.func_177774_c((Object)item);
                    if (variants < -1) {
                        variants = variants * -1 - 1;
                        loc = new ResourceLocation("correlatedpotentialistics", "tesrstack");
                    }
                    if (variants != -1) break block3;
                    ArrayList li = Lists.newArrayList();
                    item.func_150895_a(item, CoPo.creativeTab, (List)li);
                    for (ItemStack is : li) {
                        ModelLoader.setCustomModelResourceLocation((Item)item, (int)is.func_77952_i(), (ModelResourceLocation)new ModelResourceLocation(loc, "inventory"));
                    }
                    break block4;
                }
                if (variants != 0) break block5;
                ModelLoader.setCustomModelResourceLocation((Item)item, (int)0, (ModelResourceLocation)new ModelResourceLocation(loc, "inventory"));
                break block4;
            }
            if (variants <= 0) break block4;
            for (int i = 0; i < variants; ++i) {
                ModelLoader.setCustomModelResourceLocation((Item)item, (int)i, (ModelResourceLocation)new ModelResourceLocation(loc, "inventory" + i));
            }
        }
    }

    @Override
    public void weldthrowerTick(EntityPlayer player) {
        Vec3d look = player.func_70040_Z();
        Vec3d right = look.func_178785_b(-90.0f);
        double dist = 0.5;
        double gap = 1.0;
        double fuzz = 0.05;
        look.func_178785_b(20.0f);
        for (int i = 0; i < 5; ++i) {
            Random rand = player.field_70170_p.field_73012_v;
            ParticleWeldthrower dust = new ParticleWeldthrower(player.field_70170_p, player.field_70165_t + right.field_72450_a * dist + look.field_72450_a * gap, player.field_70163_u + ((double)player.func_70047_e() - 0.1) + right.field_72448_b * dist + look.field_72448_b * gap, player.field_70161_v + right.field_72449_c * dist + look.field_72449_c * gap, 1.0f);
            dust.func_70538_b(0.0f, 0.972549f - rand.nextFloat() / 5.0f, 0.8235294f - rand.nextFloat() / 5.0f);
            dust.setMotion(look.field_72450_a + rand.nextGaussian() * fuzz, look.field_72448_b + rand.nextGaussian() * fuzz, look.field_72449_c + rand.nextGaussian() * fuzz);
            Minecraft.func_71410_x().field_71452_i.func_78873_a((Particle)dust);
        }
    }

    @SubscribeEvent
    public void onClientTick(TickEvent.ClientTickEvent e) {
        if (e.phase == TickEvent.Phase.START) {
            ticks += 1.0f;
        }
    }

    @SubscribeEvent
    public void onRenderTick(TickEvent.RenderTickEvent e) {
        if (e.phase == TickEvent.Phase.START) {
            ticks = (float)((int)ticks) + e.renderTickTime;
        }
    }

    @SubscribeEvent
    public void onStitch(TextureStitchEvent.Pre e) {
        e.getMap().func_174942_a(new ResourceLocation("correlatedpotentialistics", "blocks/wireless_endpoint_error"));
        e.getMap().func_174942_a(new ResourceLocation("correlatedpotentialistics", "blocks/wireless_endpoint_linked"));
    }
}

