/*
 * Decompiled with CFR 0.152.
 */
package io.github.elytra.copo.block;

import com.google.common.base.Predicate;
import io.github.elytra.copo.CoPo;
import io.github.elytra.copo.block.BlockController;
import io.github.elytra.copo.helper.Blocks;
import io.github.elytra.copo.tile.TileEntityNetworkMember;
import io.github.elytra.copo.tile.TileEntityVT;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyBool;
import net.minecraft.block.properties.PropertyDirection;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class BlockVT
extends Block {
    public static final IProperty<EnumFacing> facing = PropertyDirection.func_177712_a((String)"facing", (Predicate)EnumFacing.Plane.HORIZONTAL);
    public static final PropertyBool lit = PropertyBool.func_177716_a((String)"lit");

    public BlockVT() {
        super(Material.field_151573_f);
    }

    public boolean hasTileEntity(IBlockState state) {
        return true;
    }

    public TileEntity createTileEntity(World world, IBlockState state) {
        return new TileEntityVT();
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{facing, lit});
    }

    public int func_176201_c(IBlockState state) {
        return ((EnumFacing)state.func_177229_b(facing)).func_176736_b() & 3 | ((Boolean)state.func_177229_b((IProperty)lit) != false ? 4 : 0);
    }

    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a(facing, (Comparable)EnumFacing.func_176731_b((int)(meta & 3))).func_177226_a((IProperty)lit, (Comparable)Boolean.valueOf((meta & 4) != 0));
    }

    public IBlockState func_180642_a(World worldIn, BlockPos pos, EnumFacing facingIn, float hitX, float hitY, float hitZ, int meta, EntityLivingBase placer) {
        return this.func_176223_P().func_177226_a(facing, (Comparable)placer.func_174811_aO().func_176734_d());
    }

    public void onNeighborChange(IBlockAccess world, BlockPos pos, BlockPos neighbor) {
        TileEntity te = world.func_175625_s(pos);
        if (te instanceof TileEntityNetworkMember) {
            ((TileEntityNetworkMember)te).handleNeighborChange(world, pos, neighbor);
        }
    }

    public boolean func_180639_a(World world, BlockPos pos, IBlockState state, EntityPlayer player, EnumHand hand, ItemStack heldItem, EnumFacing side, float hitX, float hitY, float hitZ) {
        if (Blocks.tryWrench(world, pos, player, hand, side, hitZ, hitZ, hitZ)) {
            return true;
        }
        if (!player.func_70093_af()) {
            TileEntityNetworkMember tenm;
            TileEntity te = world.func_175625_s(pos);
            if (te instanceof TileEntityNetworkMember && (tenm = (TileEntityNetworkMember)te).hasController()) {
                if (!world.field_72995_K) {
                    switch ((BlockController.State)((Object)world.func_180495_p(tenm.getController().func_174877_v()).func_177229_b(BlockController.state))) {
                        case BOOTING: {
                            player.func_145747_a((ITextComponent)new TextComponentTranslation("msg.correlatedpotentialistics.vt_booting", new Object[0]));
                            break;
                        }
                        case ERROR: {
                            player.func_145747_a((ITextComponent)new TextComponentTranslation("msg.correlatedpotentialistics.vt_error", new Object[0]));
                            break;
                        }
                        case OFF: {
                            player.func_145747_a((ITextComponent)new TextComponentTranslation("msg.correlatedpotentialistics.vt_no_power", new Object[0]));
                            break;
                        }
                        case POWERED: {
                            player.openGui((Object)CoPo.inst, 0, world, pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p());
                            break;
                        }
                    }
                }
                return true;
            }
            if (!world.field_72995_K) {
                player.func_145747_a((ITextComponent)new TextComponentTranslation("msg.correlatedpotentialistics.vt_no_controller", new Object[0]));
            }
            return true;
        }
        return super.func_180639_a(world, pos, state, player, hand, heldItem, side, hitX, hitY, hitZ);
    }
}

