/*
 * Decompiled with CFR 0.152.
 */
package io.github.elytra.copo.block;

import io.github.elytra.copo.helper.Blocks;
import io.github.elytra.copo.tile.TileEntityController;
import io.github.elytra.copo.tile.TileEntityNetworkMember;
import java.util.Locale;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyEnum;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.IStringSerializable;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class BlockController
extends Block {
    public static final IProperty<State> state = PropertyEnum.func_177709_a((String)"state", State.class);

    public BlockController() {
        super(Material.field_151573_f);
    }

    public boolean func_149710_n(IBlockState state) {
        return true;
    }

    public void func_180633_a(World worldIn, BlockPos pos, IBlockState state, EntityLivingBase placer, ItemStack stack) {
        super.func_180633_a(worldIn, pos, state, placer, stack);
        TileEntity te = worldIn.func_175625_s(pos);
        if (te instanceof TileEntityController) {
            ((TileEntityController)te).scanNetwork();
        }
    }

    public TileEntity createTileEntity(World world, IBlockState state) {
        return new TileEntityController();
    }

    public boolean hasTileEntity(IBlockState state) {
        return true;
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{state});
    }

    public int func_176201_c(IBlockState blockState) {
        return ((State)((Object)blockState.func_177229_b(state))).ordinal();
    }

    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a(state, (Comparable)((Object)State.values[meta % State.values.length]));
    }

    public boolean func_180639_a(World worldIn, BlockPos pos, IBlockState state, EntityPlayer playerIn, EnumHand hand, ItemStack heldItem, EnumFacing side, float hitX, float hitY, float hitZ) {
        if (Blocks.tryWrench(worldIn, pos, playerIn, hand, side, hitZ, hitZ, hitZ)) {
            return true;
        }
        TileEntity te = worldIn.func_175625_s(pos);
        if (te instanceof TileEntityController) {
            ((TileEntityController)te).scanNetwork();
        }
        return super.func_180639_a(worldIn, pos, state, playerIn, hand, heldItem, side, hitX, hitY, hitZ);
    }

    public void onNeighborChange(IBlockAccess world, BlockPos pos, BlockPos neighbor) {
        TileEntity te = world.func_175625_s(pos);
        if (te instanceof TileEntityNetworkMember) {
            ((TileEntityNetworkMember)te).handleNeighborChange(world, pos, neighbor);
        }
    }

    public static enum State implements IStringSerializable
    {
        POWERED,
        OFF,
        ERROR,
        BOOTING;

        private static final State[] values;
        private final String name = this.name().toLowerCase(Locale.ROOT);

        public String func_176610_l() {
            return this.name;
        }

        public String toString() {
            return this.name;
        }

        static {
            values = State.values();
        }
    }
}

