/*
 * Decompiled with CFR 0.152.
 */
package io.github.elytra.copo;

import com.google.common.base.Enums;
import com.google.common.base.Strings;
import io.github.elytra.copo.inventory.ContainerVT;
import io.github.elytra.copo.tile.TileEntityController;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.nbt.NBTTagCompound;

public interface IVT {
    public UserPreferences getPreferences(EntityPlayer var1);

    public TileEntityController getController();

    public boolean hasController();

    public boolean supportsDumpSlot();

    public IInventory getDumpSlotInventory();

    public boolean canContinueInteracting(EntityPlayer var1);

    public void markUnderlyingStorageDirty();

    public static class UserPreferences {
        public ContainerVT.SortMode sortMode = ContainerVT.SortMode.QUANTITY;
        public boolean sortAscending = false;
        public String lastSearchQuery = "";
        public ContainerVT.CraftingTarget craftingTarget = ContainerVT.CraftingTarget.INVENTORY;

        public void writeToNBT(NBTTagCompound data) {
            data.func_74778_a("SortMode", this.sortMode.name());
            data.func_74757_a("SortAscending", this.sortAscending);
            data.func_74778_a("LastSearchQuery", Strings.nullToEmpty((String)this.lastSearchQuery));
            data.func_74778_a("CraftingTarget", this.craftingTarget.name());
        }

        public void readFromNBT(NBTTagCompound data) {
            this.sortMode = (ContainerVT.SortMode)((Object)Enums.getIfPresent(ContainerVT.SortMode.class, (String)data.func_74779_i("SortMode")).or((Object)ContainerVT.SortMode.QUANTITY));
            this.sortAscending = data.func_74767_n("SortAscending");
            this.lastSearchQuery = data.func_74779_i("LastSearchQuery");
            this.craftingTarget = (ContainerVT.CraftingTarget)((Object)Enums.getIfPresent(ContainerVT.CraftingTarget.class, (String)data.func_74779_i("CraftingTarget")).or((Object)ContainerVT.CraftingTarget.INVENTORY));
        }
    }
}

