/*
 * Decompiled with CFR 0.152.
 */
package io.github.elytra.copo;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import io.github.elytra.copo.CoPo;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.WorldSavedData;

public class CoPoWorldData
extends WorldSavedData {
    private Map<UUID, Transmitter> transmitters = Maps.newHashMap();

    public CoPoWorldData(String name) {
        super(name);
    }

    public void func_76184_a(NBTTagCompound nbt) {
        NBTTagList li = nbt.func_150295_c("Transmitters", 10);
        for (int i = 0; i < li.func_74745_c(); ++i) {
            Transmitter t = new Transmitter();
            t.readFromNBT(li.func_150305_b(i));
            this.transmitters.put(t.id, t);
        }
    }

    public NBTTagCompound func_189551_b(NBTTagCompound nbt) {
        NBTTagList li = new NBTTagList();
        for (Transmitter t : this.transmitters.values()) {
            li.func_74742_a((NBTBase)t.writeToNBT());
        }
        nbt.func_74782_a("Transmitters", (NBTBase)li);
        return nbt;
    }

    public List<Transmitter> getTransmitters() {
        return ImmutableList.copyOf(this.transmitters.values());
    }

    public List<Transmitter> getTransmittersVisibleAt(Vec3d pos) {
        return this.getTransmittersVisibleAt(pos.field_72450_a, pos.field_72448_b, pos.field_72449_c);
    }

    public List<Transmitter> getTransmittersVisibleAt(double x, double y, double z) {
        ArrayList li = Lists.newArrayList();
        for (Transmitter t : this.transmitters.values()) {
            if (!(t.position.func_177957_d(x, y, z) <= t.range * t.range)) continue;
            li.add(t);
        }
        return li;
    }

    public void addTransmitter(Transmitter t) {
        if (t == null) {
            return;
        }
        CoPo.log.info("Adding transmitter at {}, id {}", new Object[]{t.position, t.id});
        this.transmitters.put(t.id, t);
        t.valid = true;
        this.func_76185_a();
    }

    public void removeTransmitter(Transmitter t) {
        if (t == null) {
            return;
        }
        this.removeTransmitterById(t.id);
    }

    public Transmitter getTransmitterById(UUID id) {
        return this.transmitters.get(id);
    }

    public void removeTransmitterById(UUID id) {
        Transmitter t = this.transmitters.remove(id);
        if (t != null) {
            t.valid = false;
            CoPo.log.info("Removing transmitter at {}, id {}", new Object[]{t.position, t.id});
            this.func_76185_a();
        }
    }

    public static final class Transmitter {
        public UUID id;
        public BlockPos position;
        public double range;
        protected boolean valid = false;

        public Transmitter() {
        }

        public Transmitter(UUID id, BlockPos position) {
            this.id = id;
            this.position = position;
            this.range = CoPo.inst.defaultWirelessRange;
        }

        public Transmitter(UUID id, BlockPos position, double range) {
            this.id = id;
            this.position = position;
            this.range = range;
        }

        public void readFromNBT(NBTTagCompound nbt) {
            this.id = new UUID(nbt.func_74763_f("UUIDMost"), nbt.func_74763_f("UUIDLeast"));
            this.position = BlockPos.func_177969_a((long)nbt.func_74763_f("Position"));
            this.range = nbt.func_74769_h("Range");
        }

        public NBTTagCompound writeToNBT() {
            NBTTagCompound nbt = new NBTTagCompound();
            nbt.func_74772_a("UUIDMost", this.id.getMostSignificantBits());
            nbt.func_74772_a("UUIDLeast", this.id.getLeastSignificantBits());
            nbt.func_74772_a("Position", this.position.func_177986_g());
            nbt.func_74780_a("Range", this.range);
            return nbt;
        }

        public boolean isValid() {
            return this.valid;
        }
    }
}

