/*
 * Decompiled with CFR 0.152.
 */
package io.github.elytra.copo;

import com.google.common.base.Throwables;
import io.github.elytra.copo.CRecipes;
import io.github.elytra.copo.CoPoWorldData;
import io.github.elytra.copo.Proxy;
import io.github.elytra.copo.block.BlockController;
import io.github.elytra.copo.block.BlockDriveBay;
import io.github.elytra.copo.block.BlockInterface;
import io.github.elytra.copo.block.BlockVT;
import io.github.elytra.copo.block.BlockWirelessEndpoint;
import io.github.elytra.copo.block.item.ItemBlockController;
import io.github.elytra.copo.block.item.ItemBlockDriveBay;
import io.github.elytra.copo.block.item.ItemBlockInterface;
import io.github.elytra.copo.block.item.ItemBlockVT;
import io.github.elytra.copo.block.item.ItemBlockWirelessEndpoint;
import io.github.elytra.copo.compat.WailaCompatibility;
import io.github.elytra.copo.item.ItemDrive;
import io.github.elytra.copo.item.ItemMisc;
import io.github.elytra.copo.item.ItemWeldthrower;
import io.github.elytra.copo.item.ItemWirelessTerminal;
import io.github.elytra.copo.network.CoPoGuiHandler;
import io.github.elytra.copo.network.SetSearchQueryMessage;
import io.github.elytra.copo.network.SetSlotSizeMessage;
import io.github.elytra.copo.network.StartWeldthrowingMessage;
import io.github.elytra.copo.tile.TileEntityController;
import io.github.elytra.copo.tile.TileEntityDriveBay;
import io.github.elytra.copo.tile.TileEntityInterface;
import io.github.elytra.copo.tile.TileEntityVT;
import io.github.elytra.copo.tile.TileEntityWirelessReceiver;
import io.github.elytra.copo.tile.TileEntityWirelessTransmitter;
import net.minecraft.block.Block;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.world.World;
import net.minecraft.world.WorldSavedData;
import net.minecraft.world.storage.loot.LootEntry;
import net.minecraft.world.storage.loot.LootEntryItem;
import net.minecraft.world.storage.loot.conditions.LootCondition;
import net.minecraft.world.storage.loot.functions.LootFunction;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.event.LootTableLoadEvent;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.SidedProxy;
import net.minecraftforge.fml.common.event.FMLPostInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.network.IGuiHandler;
import net.minecraftforge.fml.common.network.NetworkRegistry;
import net.minecraftforge.fml.common.network.simpleimpl.SimpleNetworkWrapper;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.fml.common.registry.IForgeRegistryEntry;
import net.minecraftforge.fml.relauncher.Side;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod(modid="correlatedpotentialistics", name="Correlated Potentialistics", version="1.1.3", updateJSON="http://unascribed.com/update-check/correlated-potentialistics.json", acceptedMinecraftVersions="[1.9.4]")
public class CoPo {
    public static Logger log;
    @Mod.Instance
    public static CoPo inst;
    @SidedProxy(clientSide="io.github.elytra.copo.client.ClientProxy", serverSide="io.github.elytra.copo.Proxy")
    public static Proxy proxy;
    public static BlockController controller;
    public static BlockDriveBay drive_bay;
    public static BlockVT vt;
    public static BlockInterface iface;
    public static BlockWirelessEndpoint wireless_endpoint;
    public static ItemMisc misc;
    public static ItemDrive drive;
    public static ItemWirelessTerminal wireless_terminal;
    public static ItemWeldthrower weldthrower;
    public static SoundEvent weldthrow;
    public static CreativeTabs creativeTab;
    public SimpleNetworkWrapper network;
    public boolean easyProcessors;
    public double defaultWirelessRange;
    public int controllerRfUsage;
    public int driveBayRfUsage;
    public int terminalRfUsage;
    public int interfaceRfUsage;
    public int transmitterRfUsage;
    public int receiverRfUsage;
    public int driveRfUsagePow;
    public int driveRfUsageDiv;
    public int voidDriveUsage;
    public boolean weldthrowerHurts;

    @Mod.EventHandler
    public void onPreInit(FMLPreInitializationEvent e) {
        log = LogManager.getLogger((String)"CorrelatedPotentialistics");
        Configuration config = new Configuration(e.getSuggestedConfigurationFile());
        this.easyProcessors = config.getBoolean("easyProcessors", "Crafting", false, "If true, processors can be crafted without finding one in a dungeon.");
        this.defaultWirelessRange = config.getFloat("defaultWirelessRange", "Balance", 64.0f, 1.0f, 65536.0f, "The default radius of wireless transmitters, in blocks.");
        this.weldthrowerHurts = config.getBoolean("weldthrowerHurts", "Balance", true, "If enabled, the Weldthrower will damage mobs and set them on fire.");
        this.controllerRfUsage = config.getInt("controller", "PowerUsage", 32, 0, 640, "The RF/t used by the Controller.");
        this.driveBayRfUsage = config.getInt("driveBay", "PowerUsage", 8, 0, 640, "The RF/t used by the Drive Bay.");
        this.terminalRfUsage = config.getInt("terminal", "PowerUsage", 4, 0, 640, "The RF/t used by the Terminal.");
        this.interfaceRfUsage = config.getInt("interface", "PowerUsage", 12, 0, 640, "The RF/t used by the Interface.");
        this.transmitterRfUsage = config.getInt("transmitter", "PowerUsage", 24, 0, 640, "The RF/t used by the Wireless Transmitter.");
        this.receiverRfUsage = config.getInt("receiver", "PowerUsage", 24, 0, 640, "The RF/t used by the Wireless Receiver.");
        this.driveRfUsagePow = config.getInt("drivePow", "PowerUsage", 2, 0, 8, "Drive power usage is (pow**tier)/div");
        this.driveRfUsageDiv = config.getInt("driveDiv", "PowerUsage", 2, 0, 8, "Drive power usage is (pow**tier)/div");
        this.voidDriveUsage = config.getInt("voidDrive", "PowerUsage", 4, 0, 640, "The RF/t used by the Void Drive.");
        config.save();
        this.network = NetworkRegistry.INSTANCE.newSimpleChannel("CrelatedPtntialstics");
        this.network.registerMessage(SetSearchQueryMessage.class, SetSearchQueryMessage.class, 0, Side.SERVER);
        this.network.registerMessage(SetSearchQueryMessage.class, SetSearchQueryMessage.class, 1, Side.CLIENT);
        this.network.registerMessage(SetSlotSizeMessage.class, SetSlotSizeMessage.class, 2, Side.CLIENT);
        this.network.registerMessage(StartWeldthrowingMessage.class, StartWeldthrowingMessage.class, 3, Side.CLIENT);
        this.register(new BlockController().func_149711_c(2.0f), ItemBlockController.class, "controller", 4);
        this.register(new BlockDriveBay().func_149711_c(2.0f), ItemBlockDriveBay.class, "drive_bay", 0);
        this.register(new BlockVT().func_149711_c(2.0f), ItemBlockVT.class, "vt", 0);
        this.register(new BlockInterface().func_149711_c(2.0f), ItemBlockInterface.class, "iface", 0);
        this.register(new BlockWirelessEndpoint().func_149711_c(2.0f), ItemBlockWirelessEndpoint.class, "wireless_endpoint", -4);
        this.register(new ItemMisc(), "misc", -2);
        this.register(new ItemDrive(), "drive", -1);
        this.register(new ItemWirelessTerminal(), "wireless_terminal", 0);
        this.register(new ItemWeldthrower(), "weldthrower", 0);
        ResourceLocation loc = new ResourceLocation("correlatedpotentialistics", "weldthrow");
        weldthrow = new SoundEvent(loc);
        GameRegistry.register((IForgeRegistryEntry)weldthrow, (ResourceLocation)loc);
        CRecipes.register();
        GameRegistry.registerTileEntity(TileEntityController.class, (String)"correlatedpotentialistics:controller");
        GameRegistry.registerTileEntity(TileEntityDriveBay.class, (String)"correlatedpotentialistics:drive_bay");
        GameRegistry.registerTileEntity(TileEntityVT.class, (String)"correlatedpotentialistics:vt");
        GameRegistry.registerTileEntity(TileEntityInterface.class, (String)"correlatedpotentialistics:interface");
        GameRegistry.registerTileEntity(TileEntityWirelessReceiver.class, (String)"correlatedpotentialistics:wireless_receiver");
        GameRegistry.registerTileEntity(TileEntityWirelessTransmitter.class, (String)"correlatedpotentialistics:wireless_transmitter");
        if (Loader.isModLoaded((String)"Waila")) {
            WailaCompatibility.init();
        }
        NetworkRegistry.INSTANCE.registerGuiHandler((Object)this, (IGuiHandler)new CoPoGuiHandler());
        MinecraftForge.EVENT_BUS.register((Object)this);
        proxy.preInit();
    }

    @Mod.EventHandler
    public void onPostInit(FMLPostInitializationEvent e) {
        proxy.postInit();
    }

    @SubscribeEvent
    public void onLootAdd(LootTableLoadEvent e) {
        if (e.getName().toString().startsWith("minecraft:chests/")) {
            e.getTable().getPool("main").addEntry((LootEntry)new LootEntryItem((Item)misc, 45, 0, new LootFunction[0], new LootCondition[0], "correlatedpotentialistics:processor"));
        }
    }

    public static CoPoWorldData getDataFor(World w) {
        CoPoWorldData data = (CoPoWorldData)w.getPerWorldStorage().func_75742_a(CoPoWorldData.class, "correlatedpotentialistics");
        if (data == null) {
            data = new CoPoWorldData("correlatedpotentialistics");
            w.getPerWorldStorage().func_75745_a("correlatedpotentialistics", (WorldSavedData)data);
        }
        return data;
    }

    private void register(Block block, Class<? extends ItemBlock> item, String name, int itemVariants) {
        block.func_149663_c("correlatedpotentialistics." + name);
        block.func_149647_a(creativeTab);
        block.setRegistryName(name);
        GameRegistry.register((IForgeRegistryEntry)block);
        try {
            ItemBlock ib = item.getConstructor(Block.class).newInstance(block);
            ib.setRegistryName(name);
            GameRegistry.register((IForgeRegistryEntry)ib);
        }
        catch (Exception e1) {
            Throwables.propagate((Throwable)e1);
        }
        proxy.registerItemModel(Item.func_150898_a((Block)block), itemVariants);
        try {
            this.getClass().getField(name).set(this, block);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void register(Item item, String name, int variants) {
        item.func_77655_b("correlatedpotentialistics." + name);
        item.func_77637_a(creativeTab);
        item.setRegistryName(name);
        GameRegistry.register((IForgeRegistryEntry)item);
        proxy.registerItemModel(item, variants);
        try {
            this.getClass().getField(name).set(this, item);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    static {
        creativeTab = new CreativeTabs("correlatedPotentialistics"){

            public Item func_78016_d() {
                return Item.func_150898_a((Block)controller);
            }
        };
    }
}

