/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftools.playerprops;

import mcjty.lib.varia.GlobalCoordinate;
import mcjty.lib.varia.Logging;
import mcjty.rftools.blocks.teleporter.TeleportDestination;
import mcjty.rftools.blocks.teleporter.TeleportDestinations;
import mcjty.rftools.blocks.teleporter.TeleportationTools;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.text.TextFormatting;

public class PorterProperties {
    private int target = -1;
    private int teleportTimeout = -1;

    public boolean isTeleporting() {
        return this.target != -1 && this.teleportTimeout >= 0;
    }

    public void startTeleport(int target, int ticks) {
        this.target = target;
        this.teleportTimeout = ticks;
    }

    public void tickTeleport(EntityPlayer player) {
        if (this.teleportTimeout < 0) {
            return;
        }
        --this.teleportTimeout;
        if (this.teleportTimeout <= 0) {
            TeleportDestinations destinations = TeleportDestinations.getDestinations(player.field_70170_p);
            GlobalCoordinate coordinate = destinations.getCoordinateForId(this.target);
            if (coordinate == null) {
                Logging.message((EntityPlayer)player, (String)(TextFormatting.RED + "Something went wrong! The target has disappeared!"));
                TeleportationTools.applyEffectForSeverity(player, 3, false);
                return;
            }
            TeleportDestination destination = destinations.getDestination(coordinate);
            TeleportationTools.performTeleport(player, destination, 0, 10, false);
            this.teleportTimeout = -1;
            this.target = -1;
        }
    }

    public void saveNBTData(NBTTagCompound compound) {
        compound.func_74768_a("target", this.target);
        compound.func_74768_a("ticks", this.teleportTimeout);
    }

    public void loadNBTData(NBTTagCompound compound) {
        this.target = compound.func_74764_b("target") ? compound.func_74762_e("target") : -1;
        this.teleportTimeout = compound.func_74764_b("ticks") ? compound.func_74762_e("ticks") : -1;
    }
}

