/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftools.network;

import io.netty.buffer.ByteBuf;
import mcjty.rftools.blocks.teleporter.TeleportDestinations;
import mcjty.rftools.network.PacketReturnDestinationInfo;
import mcjty.rftools.network.RFToolsMessages;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;

public class PacketGetDestinationInfo
implements IMessage {
    private int receiverId;

    public void fromBytes(ByteBuf buf) {
        this.receiverId = buf.readInt();
    }

    public void toBytes(ByteBuf buf) {
        buf.writeInt(this.receiverId);
    }

    public PacketGetDestinationInfo() {
    }

    public PacketGetDestinationInfo(int receiverId) {
        this.receiverId = receiverId;
    }

    public static class Handler
    implements IMessageHandler<PacketGetDestinationInfo, IMessage> {
        public IMessage onMessage(PacketGetDestinationInfo message, MessageContext ctx) {
            FMLCommonHandler.instance().getWorldThread(ctx.netHandler).func_152344_a(() -> this.handle(message, ctx));
            return null;
        }

        private void handle(PacketGetDestinationInfo message, MessageContext ctx) {
            World world = ctx.getServerHandler().field_147369_b.field_70170_p;
            TeleportDestinations destinations = TeleportDestinations.getDestinations(world);
            int receiverId = message.receiverId;
            String name = TeleportDestinations.getDestinationName(destinations, receiverId);
            RFToolsMessages.INSTANCE.sendTo((IMessage)new PacketReturnDestinationInfo(receiverId, name), ctx.getServerHandler().field_147369_b);
        }
    }
}

