/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftools.items;

import java.util.List;
import mcjty.lib.varia.Logging;
import mcjty.rftools.GeneralConfiguration;
import mcjty.rftools.items.GenericRFToolsItem;
import mcjty.rftools.items.ModItems;
import net.minecraft.client.renderer.ItemMeshDefinition;
import net.minecraft.client.renderer.block.model.ModelBakery;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityList;
import net.minecraft.entity.boss.EntityDragon;
import net.minecraft.entity.boss.EntityDragonPart;
import net.minecraft.entity.monster.EntitySkeleton;
import net.minecraft.entity.monster.SkeletonType;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.translation.I18n;
import net.minecraft.world.World;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.lwjgl.input.Keyboard;

public class SyringeItem
extends GenericRFToolsItem {
    public SyringeItem() {
        super("syringe");
        this.func_77625_d(1);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void initModel() {
        for (int i = 0; i <= 5; ++i) {
            String domain = this.getRegistryName().func_110624_b();
            String path = this.getRegistryName().func_110623_a();
            ModelBakery.registerItemVariants((Item)this, (ResourceLocation[])new ResourceLocation[]{new ModelResourceLocation(new ResourceLocation(domain, path + i), "inventory")});
        }
        ModelLoader.setCustomMeshDefinition((Item)this, (ItemMeshDefinition)new ItemMeshDefinition(){

            public ModelResourceLocation func_178113_a(ItemStack stack) {
                NBTTagCompound tagCompound = stack.func_77978_p();
                int level = 0;
                if (tagCompound != null) {
                    level = tagCompound.func_74762_e("level");
                }
                level = level <= 0 ? 0 : (level >= GeneralConfiguration.maxMobInjections ? 5 : (level - 1) * 4 / (GeneralConfiguration.maxMobInjections - 1) + 1);
                String domain = SyringeItem.this.getRegistryName().func_110624_b();
                String path = SyringeItem.this.getRegistryName().func_110623_a();
                return new ModelResourceLocation(new ResourceLocation(domain, path + level), "inventory");
            }
        });
    }

    public int func_77626_a(ItemStack stack) {
        return 1;
    }

    public ActionResult<ItemStack> func_77659_a(ItemStack stack, World world, EntityPlayer player, EnumHand hand) {
        if (!world.field_72995_K) {
            NBTTagCompound tagCompound = stack.func_77978_p();
            if (tagCompound != null) {
                String mobName = SyringeItem.getMobName(stack);
                if (mobName != null) {
                    Logging.message((EntityPlayer)player, (String)(TextFormatting.BLUE + "Mob: " + mobName));
                }
                int level = tagCompound.func_74762_e("level");
                level = level * 100 / GeneralConfiguration.maxMobInjections;
                Logging.message((EntityPlayer)player, (String)(TextFormatting.BLUE + "Essence level: " + level + "%"));
            }
            return new ActionResult(EnumActionResult.SUCCESS, (Object)stack);
        }
        return new ActionResult(EnumActionResult.SUCCESS, (Object)stack);
    }

    public boolean onLeftClickEntity(ItemStack stack, EntityPlayer player, Entity entity) {
        Class<? extends Entity> clazz = this.findSelectedMobClass(entity);
        if (clazz != null) {
            String prevMobId = null;
            NBTTagCompound tagCompound = stack.func_77978_p();
            if (tagCompound != null) {
                prevMobId = tagCompound.func_74779_i("mobId");
            } else {
                tagCompound = new NBTTagCompound();
                stack.func_77982_d(tagCompound);
            }
            String id = this.findSelectedMobId(clazz, entity);
            if (prevMobId == null || !prevMobId.equals(id)) {
                tagCompound.func_74778_a("mobName", this.findSelectedMobName(entity));
                tagCompound.func_74778_a("mobId", id);
                tagCompound.func_74768_a("level", 1);
            } else {
                int level = tagCompound.func_74762_e("level");
                if (++level > GeneralConfiguration.maxMobInjections) {
                    level = GeneralConfiguration.maxMobInjections;
                }
                tagCompound.func_74768_a("level", level);
            }
        }
        return super.onLeftClickEntity(stack, player, entity);
    }

    private String findSelectedMobId(Class<? extends Entity> clazz, Entity entity) {
        if (entity instanceof EntitySkeleton) {
            EntitySkeleton skeleton = (EntitySkeleton)entity;
            if (skeleton.func_189771_df() == SkeletonType.WITHER) {
                return "WitherSkeleton";
            }
            if (skeleton.func_189771_df() == SkeletonType.STRAY) {
                return "StraySkeleton";
            }
        }
        return (String)EntityList.field_75626_c.get(clazz);
    }

    private Class<? extends Entity> findSelectedMobClass(Entity entity) {
        Class<Object> entityClass = entity.getClass();
        if (entity instanceof EntityDragonPart) {
            entityClass = EntityDragon.class;
        }
        return entityClass;
    }

    private String findSelectedMobName(Entity entity) {
        if (entity instanceof EntitySkeleton && ((EntitySkeleton)entity).func_189771_df() == SkeletonType.WITHER) {
            return "Wither Skeleton";
        }
        if (entity instanceof EntitySkeleton && ((EntitySkeleton)entity).func_189771_df() == SkeletonType.STRAY) {
            return "Stray Skeleton";
        }
        return entity.func_70005_c_();
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack itemStack, EntityPlayer player, List<String> list, boolean whatIsThis) {
        super.func_77624_a(itemStack, player, list, whatIsThis);
        NBTTagCompound tagCompound = itemStack.func_77978_p();
        if (tagCompound != null) {
            String mobName = SyringeItem.getMobName(itemStack);
            if (mobName != null) {
                list.add(TextFormatting.BLUE + "Mob: " + mobName);
            }
            int level = tagCompound.func_74762_e("level");
            level = level * 100 / GeneralConfiguration.maxMobInjections;
            list.add(TextFormatting.BLUE + "Essence level: " + level + "%");
        }
        if (Keyboard.isKeyDown((int)42) || Keyboard.isKeyDown((int)54)) {
            list.add(TextFormatting.WHITE + "Use this to extract essence from mobs");
            list.add(TextFormatting.WHITE + "Workbench. Be careful!");
        } else {
            list.add(TextFormatting.WHITE + "<Press Shift>");
        }
    }

    public static ItemStack createMobSyringe(Class<? extends Entity> mobClass) {
        String id = EntityList.func_188430_a(mobClass);
        String name = I18n.func_74838_a((String)("entity." + id + ".name"));
        return SyringeItem.createMobSyringe(id, name);
    }

    private static ItemStack createMobSyringe(String id, String name) {
        ItemStack syringe = new ItemStack((Item)ModItems.syringeItem);
        NBTTagCompound tagCompound = new NBTTagCompound();
        tagCompound.func_74778_a("mobId", id);
        if (name == null || name.isEmpty()) {
            name = id;
        }
        tagCompound.func_74778_a("mobName", name);
        tagCompound.func_74768_a("level", GeneralConfiguration.maxMobInjections);
        syringe.func_77982_d(tagCompound);
        return syringe;
    }

    public static String getMobId(ItemStack stack) {
        NBTTagCompound tagCompound = stack.func_77978_p();
        if (tagCompound != null) {
            String mob = tagCompound.func_74779_i("mobId");
            if (mob == null) {
                return tagCompound.func_74779_i("mobName");
            }
            return mob;
        }
        return null;
    }

    public static String getMobName(ItemStack stack) {
        NBTTagCompound tagCompound = stack.func_77978_p();
        if (tagCompound != null) {
            String mob = tagCompound.func_74779_i("mobName");
            if (mob == null) {
                if (tagCompound.func_74764_b("mobId")) {
                    return tagCompound.func_74779_i("mobId");
                }
                return "?";
            }
            return mob;
        }
        return null;
    }
}

