/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftools.blocks.storage;

import gnu.trove.set.TIntSet;
import java.util.Map;
import mcjty.lib.container.DefaultSidedInventory;
import mcjty.lib.container.InventoryHelper;
import mcjty.lib.network.Argument;
import mcjty.rftools.blocks.logic.generic.LogicTileEntity;
import mcjty.rftools.blocks.screens.ScreenSetup;
import mcjty.rftools.blocks.storage.LevelEmitterContainer;
import mcjty.rftools.blocks.storagemonitor.StorageScannerTileEntity;
import mcjty.rftools.varia.RFToolsTools;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SPacketUpdateTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ITickable;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.common.DimensionManager;

public class LevelEmitterTileEntity
extends LogicTileEntity
implements DefaultSidedInventory,
ITickable {
    public static final String CMD_SETAMOUNT = "setCounter";
    public static final String CMD_SETOREDICT = "setOreDict";
    public static final String CMD_SETSTARRED = "setStarred";
    private InventoryHelper inventoryHelper = new InventoryHelper((TileEntity)this, LevelEmitterContainer.factory, 2);
    private int amount = 1;
    private boolean oreDict = false;
    private boolean starred = false;
    private TIntSet set1 = null;
    private int checkCounter = 0;

    public void func_73660_a() {
        if (this.field_145850_b.field_72995_K) {
            return;
        }
        --this.checkCounter;
        if (this.checkCounter > 0) {
            return;
        }
        this.checkCounter = 10;
        int count = this.getCurrentCount();
        this.setRedstoneState(count >= this.amount);
    }

    public int getCurrentCount() {
        ItemStack module = this.inventoryHelper.getStackInSlot(0);
        int count = -1;
        if (module != null) {
            TileEntity te;
            ItemStack matcher = this.inventoryHelper.getStackInSlot(1);
            if (matcher == null) {
                return count;
            }
            int dimension = RFToolsTools.getDimensionFromModule(module);
            BlockPos scannerPos = RFToolsTools.getPositionFromModule(module);
            WorldServer world = DimensionManager.getWorld((int)dimension);
            if (RFToolsTools.chunkLoaded((World)world, scannerPos) && (te = world.func_175625_s(scannerPos)) instanceof StorageScannerTileEntity) {
                StorageScannerTileEntity scannerTE = (StorageScannerTileEntity)te;
                count = scannerTE.countStack(matcher, this.starred, this.oreDict);
            }
        }
        return count;
    }

    public void onDataPacket(NetworkManager net, SPacketUpdateTileEntity packet) {
        boolean module = this.inventoryHelper.getStackInSlot(0) != null;
        super.onDataPacket(net, packet);
        if (this.field_145850_b.field_72995_K) {
            boolean newmodule;
            boolean bl = newmodule = this.inventoryHelper.getStackInSlot(0) != null;
            if (newmodule != module) {
                this.field_145850_b.func_175704_b(this.func_174877_v(), this.func_174877_v());
            }
        }
    }

    public void func_70299_a(int index, ItemStack stack) {
        this.set1 = null;
        this.inventoryHelper.setInventorySlotContents(this.func_70297_j_(), index, stack);
        if (!this.field_145850_b.field_72995_K) {
            this.markDirtyClient();
        } else {
            this.field_145850_b.func_175704_b(this.func_174877_v(), this.func_174877_v());
        }
    }

    @Override
    public void func_145839_a(NBTTagCompound tagCompound) {
        super.func_145839_a(tagCompound);
        this.powered = tagCompound.func_74767_n("rs");
    }

    public void readRestorableFromNBT(NBTTagCompound tagCompound) {
        super.readRestorableFromNBT(tagCompound);
        this.readBufferFromNBT(tagCompound, this.inventoryHelper);
        this.amount = tagCompound.func_74762_e("amount");
        this.oreDict = tagCompound.func_74767_n("oredict");
        this.starred = tagCompound.func_74767_n("starred");
    }

    @Override
    public NBTTagCompound func_189515_b(NBTTagCompound tagCompound) {
        super.func_189515_b(tagCompound);
        tagCompound.func_74757_a("rs", this.powered);
        return tagCompound;
    }

    public void writeRestorableToNBT(NBTTagCompound tagCompound) {
        super.writeRestorableToNBT(tagCompound);
        this.writeBufferToNBT(tagCompound, this.inventoryHelper);
        tagCompound.func_74768_a("amount", this.amount);
        tagCompound.func_74757_a("oredict", this.oreDict);
        tagCompound.func_74757_a("starred", this.starred);
    }

    protected boolean needsCustomInvWrapper() {
        return true;
    }

    public boolean func_94041_b(int index, ItemStack stack) {
        if (index == 0 && stack.func_77973_b() != ScreenSetup.storageControlModuleItem) {
            return false;
        }
        return index != 1;
    }

    public InventoryHelper getInventoryHelper() {
        return this.inventoryHelper;
    }

    public boolean func_70300_a(EntityPlayer player) {
        return this.canPlayerAccess(player);
    }

    public int getAmount() {
        return this.amount;
    }

    public void setAmount(int amount) {
        this.amount = amount;
        this.func_70296_d();
    }

    public boolean isOreDict() {
        return this.oreDict;
    }

    public void setOreDict(boolean oreDict) {
        this.oreDict = oreDict;
        this.func_70296_d();
    }

    public boolean isStarred() {
        return this.starred;
    }

    public void setStarred(boolean starred) {
        this.starred = starred;
        this.func_70296_d();
    }

    public boolean execute(EntityPlayerMP playerMP, String command, Map<String, Argument> args) {
        boolean rc = super.execute(playerMP, command, args);
        if (rc) {
            return true;
        }
        if (CMD_SETAMOUNT.equals(command)) {
            this.setAmount(args.get("amount").getInteger());
            return true;
        }
        if (CMD_SETSTARRED.equals(command)) {
            this.setStarred(args.get("b").getBoolean());
            return true;
        }
        if (CMD_SETOREDICT.equals(command)) {
            this.setOreDict(args.get("b").getBoolean());
            return true;
        }
        return false;
    }
}

