/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftools.blocks.shield;

import java.util.AbstractCollection;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Deque;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import mcjty.lib.api.smartwrench.SmartWrenchSelector;
import mcjty.lib.container.DefaultSidedInventory;
import mcjty.lib.container.InventoryHelper;
import mcjty.lib.entity.GenericEnergyReceiverTileEntity;
import mcjty.lib.network.Argument;
import mcjty.lib.varia.BlockTools;
import mcjty.lib.varia.Logging;
import mcjty.lib.varia.RedstoneMode;
import mcjty.rftools.blocks.builder.BuilderSetup;
import mcjty.rftools.blocks.shield.AbstractShieldBlock;
import mcjty.rftools.blocks.shield.DamageTypeMode;
import mcjty.rftools.blocks.shield.GuiShield;
import mcjty.rftools.blocks.shield.NoTickShieldBlockTileEntity;
import mcjty.rftools.blocks.shield.RelCoordinate;
import mcjty.rftools.blocks.shield.ShieldConfiguration;
import mcjty.rftools.blocks.shield.ShieldContainer;
import mcjty.rftools.blocks.shield.ShieldRenderingMode;
import mcjty.rftools.blocks.shield.ShieldSetup;
import mcjty.rftools.blocks.shield.filters.AbstractShieldFilter;
import mcjty.rftools.blocks.shield.filters.PlayerFilter;
import mcjty.rftools.blocks.shield.filters.ShieldFilter;
import mcjty.rftools.items.builder.ShapeCardItem;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ITickable;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.common.DimensionManager;
import net.minecraftforge.common.util.FakePlayer;
import net.minecraftforge.common.util.FakePlayerFactory;

public class ShieldTEBase
extends GenericEnergyReceiverTileEntity
implements DefaultSidedInventory,
SmartWrenchSelector,
ITickable {
    public static final String CMD_SHIELDVISMODE = "shieldVisMode";
    public static final String CMD_APPLYCAMO = "applyCamo";
    public static final String CMD_DAMAGEMODE = "damageMode";
    public static final String CMD_RSMODE = "rsMode";
    public static final String CMD_ADDFILTER = "addFilter";
    public static final String CMD_DELFILTER = "delFilter";
    public static final String CMD_UPFILTER = "upFilter";
    public static final String CMD_DOWNFILTER = "downFilter";
    public static final String CMD_GETFILTERS = "getFilters";
    public static final String CMD_SETCOLOR = "setColor";
    public static final String CLIENTCMD_GETFILTERS = "getFilters";
    public static final String COMPONENT_NAME = "shield_projector";
    private DamageTypeMode damageMode = DamageTypeMode.DAMAGETYPE_GENERIC;
    private boolean shieldComposed = false;
    private int templateMeta = 0;
    private boolean shieldActive = false;
    private int powerTimeout = 0;
    private int shieldColor;
    private int camoRenderPass = 0;
    private int supportedBlocks;
    private float damageFactor = 1.0f;
    private float costFactor = 1.0f;
    private final List<ShieldFilter> filters = new ArrayList<ShieldFilter>();
    private ShieldRenderingMode shieldRenderingMode = ShieldRenderingMode.MODE_SHIELD;
    private List<RelCoordinate> shieldBlocks = new ArrayList<RelCoordinate>();
    private InventoryHelper inventoryHelper = new InventoryHelper((TileEntity)this, ShieldContainer.factory, 2);

    public ShieldTEBase(int maxEnergy, int maxReceive) {
        super(maxEnergy, maxReceive);
    }

    protected boolean needsRedstoneMode() {
        return true;
    }

    protected boolean needsCustomInvWrapper() {
        return true;
    }

    public void setSupportedBlocks(int supportedBlocks) {
        this.supportedBlocks = supportedBlocks;
    }

    public void setDamageFactor(float factor) {
        this.damageFactor = factor;
    }

    public void setCostFactor(float factor) {
        this.costFactor = factor;
    }

    private Object[] setDamageMode(String mode) {
        DamageTypeMode damageMode = DamageTypeMode.getMode(mode);
        if (damageMode == null) {
            throw new IllegalArgumentException("Not a valid mode");
        }
        this.setDamageMode(damageMode);
        return null;
    }

    private Object[] setRedstoneMode(String mode) {
        RedstoneMode redstoneMode = RedstoneMode.getMode((String)mode);
        if (redstoneMode == null) {
            throw new IllegalArgumentException("Not a valid mode");
        }
        this.setRSMode(redstoneMode);
        return null;
    }

    private Object[] setShieldRenderingMode(String mode) {
        ShieldRenderingMode renderingMode = ShieldRenderingMode.getMode(mode);
        if (renderingMode == null) {
            throw new IllegalArgumentException("Not a valid mode");
        }
        this.setShieldRenderingMode(renderingMode);
        return null;
    }

    private Object[] composeShieldComp(boolean ctrl) {
        boolean done = false;
        if (!this.isShieldComposed()) {
            this.composeShield(ctrl);
            done = true;
        }
        return new Object[]{done};
    }

    private Object[] decomposeShieldComp() {
        boolean done = false;
        if (this.isShieldComposed()) {
            this.decomposeShield();
            done = true;
        }
        return new Object[]{done};
    }

    public boolean isPowered() {
        return this.powerLevel > 0;
    }

    public List<ShieldFilter> getFilters() {
        return this.filters;
    }

    public int getShieldColor() {
        return this.shieldColor;
    }

    public void setShieldColor(int shieldColor) {
        this.shieldColor = shieldColor;
        this.updateShield();
        this.markDirtyClient();
    }

    private void delFilter(int selected) {
        this.filters.remove(selected);
        this.updateShield();
        this.markDirtyClient();
    }

    private void upFilter(int selected) {
        ShieldFilter filter1 = this.filters.get(selected - 1);
        ShieldFilter filter2 = this.filters.get(selected);
        this.filters.set(selected - 1, filter2);
        this.filters.set(selected, filter1);
        this.markDirtyClient();
    }

    private void downFilter(int selected) {
        ShieldFilter filter1 = this.filters.get(selected);
        ShieldFilter filter2 = this.filters.get(selected + 1);
        this.filters.set(selected, filter2);
        this.filters.set(selected + 1, filter1);
        this.markDirtyClient();
    }

    private void addFilter(int action, String type, String player, int selected) {
        ShieldFilter filter = AbstractShieldFilter.createFilter(type);
        filter.setAction(action);
        if (filter instanceof PlayerFilter) {
            ((PlayerFilter)filter).setName(player);
        }
        if (selected == -1) {
            this.filters.add(filter);
        } else {
            this.filters.add(selected, filter);
        }
        this.updateShield();
        this.markDirtyClient();
    }

    public DamageTypeMode getDamageMode() {
        return this.damageMode;
    }

    public void setDamageMode(DamageTypeMode damageMode) {
        this.damageMode = damageMode;
        this.markDirtyClient();
    }

    public ShieldRenderingMode getShieldRenderingMode() {
        return this.shieldRenderingMode;
    }

    public void setShieldRenderingMode(ShieldRenderingMode shieldRenderingMode) {
        this.shieldRenderingMode = shieldRenderingMode;
        if (this.shieldComposed) {
            this.updateShield();
        }
        this.markDirtyClient();
    }

    public boolean func_94041_b(int index, ItemStack stack) {
        return index != 1 || stack.func_77973_b() == BuilderSetup.shapeCardItem;
    }

    private int[] calculateCamoId() {
        ItemStack stack = this.func_70301_a(0);
        int camoId = -1;
        int meta = 0;
        int te = 0;
        if (ShieldRenderingMode.MODE_MIMIC.equals((Object)this.shieldRenderingMode) && stack != null && stack.func_77973_b() != null) {
            if (!(stack.func_77973_b() instanceof ItemBlock)) {
                return new int[]{camoId, meta, te};
            }
            Block block = ((ItemBlock)stack.func_77973_b()).func_179223_d();
            camoId = Block.func_149682_b((Block)block);
            meta = stack.func_77952_i();
            if (block.hasTileEntity(block.func_176203_a(meta))) {
                te = 1;
            }
        }
        return new int[]{camoId, meta, te};
    }

    private Block calculateShieldBlock(int damageBits) {
        if (!this.shieldActive || this.powerTimeout > 0) {
            return Blocks.field_150350_a;
        }
        if (ShieldRenderingMode.MODE_INVISIBLE.equals((Object)this.shieldRenderingMode)) {
            if (damageBits == 0) {
                return ShieldSetup.noTickInvisibleShieldBlock;
            }
            return ShieldSetup.invisibleShieldBlock;
        }
        if (damageBits == 0) {
            return ShieldSetup.noTickSolidShieldBlock;
        }
        return ShieldSetup.solidShieldBlock;
    }

    private int calculateDamageBits() {
        int bits = 0;
        for (ShieldFilter filter : this.filters) {
            if ((filter.getAction() & 2) == 0) continue;
            if ("item".equals(filter.getFilterName())) {
                bits |= 1;
                continue;
            }
            if ("animal".equals(filter.getFilterName())) {
                bits |= 2;
                continue;
            }
            if ("hostile".equals(filter.getFilterName())) {
                bits |= 4;
                continue;
            }
            if ("player".equals(filter.getFilterName())) {
                bits |= 8;
                continue;
            }
            if (!"default".equals(filter.getFilterName())) continue;
            bits |= 0xF;
        }
        return bits;
    }

    private int calculateShieldCollisionData() {
        int cd = 0;
        for (ShieldFilter filter : this.filters) {
            if ((filter.getAction() & 1) == 0) continue;
            if ("item".equals(filter.getFilterName())) {
                cd |= 1;
                continue;
            }
            if ("animal".equals(filter.getFilterName())) {
                cd |= 2;
                continue;
            }
            if ("hostile".equals(filter.getFilterName())) {
                cd |= 4;
                continue;
            }
            if ("player".equals(filter.getFilterName())) {
                cd |= 8;
                continue;
            }
            if (!"default".equals(filter.getFilterName())) continue;
            cd |= 0xF;
        }
        return cd;
    }

    private int calculateRfPerTick() {
        if (!this.shieldActive) {
            return 0;
        }
        int s = this.shieldBlocks.size() - 50;
        if (s < 10) {
            s = 10;
        }
        int rf = ShieldConfiguration.rfBase * s / 10;
        if (ShieldRenderingMode.MODE_SHIELD.equals((Object)this.shieldRenderingMode)) {
            rf += ShieldConfiguration.rfShield * s / 10;
        } else if (ShieldRenderingMode.MODE_MIMIC.equals((Object)this.shieldRenderingMode)) {
            rf += ShieldConfiguration.rfCamo * s / 10;
        }
        return rf;
    }

    public boolean isShieldComposed() {
        return this.shieldComposed;
    }

    public boolean isShieldActive() {
        return this.shieldActive;
    }

    public void applyDamageToEntity(Entity entity) {
        DamageSource source;
        int rf;
        if (DamageTypeMode.DAMAGETYPE_GENERIC.equals((Object)this.damageMode)) {
            rf = ShieldConfiguration.rfDamage;
            source = DamageSource.field_76377_j;
        } else {
            rf = ShieldConfiguration.rfDamagePlayer;
            FakePlayer fakePlayer = FakePlayerFactory.getMinecraft((WorldServer)DimensionManager.getWorld((int)0));
            source = DamageSource.func_76365_a((EntityPlayer)fakePlayer);
        }
        rf = (int)((float)rf * this.costFactor * (4.0f - this.getInfusedFactor()) / 4.0f);
        if (this.getEnergyStored(EnumFacing.DOWN) < rf) {
            return;
        }
        this.consumeEnergy(rf);
        float damage = ShieldConfiguration.damage;
        damage *= this.damageFactor;
        entity.func_70097_a(source, damage *= 1.0f + this.getInfusedFactor() / 2.0f);
    }

    public void func_73660_a() {
        if (!this.field_145850_b.field_72995_K) {
            this.checkStateServer();
        }
    }

    private void checkStateServer() {
        boolean newShieldActive;
        boolean checkPower = false;
        if (this.powerTimeout > 0) {
            --this.powerTimeout;
            this.func_70296_d();
            if (this.powerTimeout > 0) {
                return;
            }
            checkPower = true;
        }
        boolean needsUpdate = false;
        int rf = this.calculateRfPerTick();
        if ((rf = (int)((float)rf * (2.0f - this.getInfusedFactor()) / 2.0f)) > 0) {
            if (this.getEnergyStored(EnumFacing.DOWN) < rf) {
                this.powerTimeout = 100;
                needsUpdate = true;
            } else {
                if (checkPower) {
                    needsUpdate = true;
                }
                this.consumeEnergy(rf);
            }
        }
        if ((newShieldActive = this.isMachineEnabled()) != this.shieldActive) {
            needsUpdate = true;
            this.shieldActive = newShieldActive;
        }
        if (needsUpdate) {
            this.updateShield();
            this.func_70296_d();
        }
    }

    public void composeDecomposeShield(boolean ctrl) {
        if (this.shieldComposed) {
            this.decomposeShield();
        } else {
            this.composeShield(ctrl);
        }
    }

    public void composeShield(boolean ctrl) {
        AbstractCollection coordinates;
        this.shieldBlocks.clear();
        if (this.isShapedShield()) {
            ShapeCardItem.Shape shape = ShapeCardItem.getShape(this.inventoryHelper.getStackInSlot(1));
            BlockPos dimension = ShapeCardItem.getClampedDimension(this.inventoryHelper.getStackInSlot(1), ShieldConfiguration.maxShieldDimension);
            BlockPos offset = ShapeCardItem.getClampedOffset(this.inventoryHelper.getStackInSlot(1), ShieldConfiguration.maxShieldOffset);
            coordinates = new ArrayList();
            ShapeCardItem.composeShape(shape, this.field_145850_b, this.func_174877_v(), dimension, offset, coordinates, this.supportedBlocks, false, null);
        } else {
            this.templateMeta = this.findTemplateMeta();
            coordinates = new HashSet();
            this.findTemplateBlocks((Set)((Object)coordinates), this.templateMeta, ctrl, this.func_174877_v());
        }
        int xCoord = this.func_174877_v().func_177958_n();
        int yCoord = this.func_174877_v().func_177956_o();
        int zCoord = this.func_174877_v().func_177952_p();
        for (BlockPos c : coordinates) {
            this.shieldBlocks.add(new RelCoordinate(c.func_177958_n() - xCoord, c.func_177956_o() - yCoord, c.func_177952_p() - zCoord));
        }
        this.shieldComposed = true;
        this.updateShield();
    }

    private boolean isShapedShield() {
        return this.inventoryHelper.getStackInSlot(1) != null;
    }

    private int findTemplateMeta() {
        int meta = -1;
        for (EnumFacing dir : EnumFacing.field_82609_l) {
            IBlockState state;
            BlockPos p = this.func_174877_v().func_177972_a(dir);
            if (p.func_177956_o() < 0 || p.func_177956_o() >= this.field_145850_b.func_72800_K() || !((Object)((Object)ShieldSetup.shieldTemplateBlock)).equals((state = this.field_145850_b.func_180495_p(p)).func_177230_c())) continue;
            meta = state.func_177230_c().func_176201_c(state);
            break;
        }
        return meta;
    }

    public void selectBlock(EntityPlayer player, BlockPos pos) {
        if (!this.shieldComposed) {
            Logging.message((EntityPlayer)player, (String)(TextFormatting.YELLOW + "Shield is not composed. Nothing happens!"));
            return;
        }
        float squaredDistance = (float)this.func_174877_v().func_177954_c((double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p());
        if (squaredDistance > (float)(ShieldConfiguration.maxDisjointShieldDistance * ShieldConfiguration.maxDisjointShieldDistance)) {
            Logging.message((EntityPlayer)player, (String)(TextFormatting.YELLOW + "This template is too far to connect to the shield!"));
            return;
        }
        int xCoord = this.func_174877_v().func_177958_n();
        int yCoord = this.func_174877_v().func_177956_o();
        int zCoord = this.func_174877_v().func_177952_p();
        Block origBlock = this.field_145850_b.func_180495_p(pos).func_177230_c();
        BlockPos c = pos;
        if (origBlock == ShieldSetup.shieldTemplateBlock) {
            if (this.isShapedShield()) {
                Logging.message((EntityPlayer)player, (String)(TextFormatting.YELLOW + "You cannot add template blocks to a shaped shield (using a shape card)!"));
                return;
            }
            HashSet<BlockPos> templateBlocks = new HashSet<BlockPos>();
            IBlockState state = this.field_145850_b.func_180495_p(c);
            this.findTemplateBlocks(templateBlocks, state.func_177230_c().func_176201_c(state), false, c);
            int[] camoId = this.calculateCamoId();
            int cddata = this.calculateShieldCollisionData();
            int damageBits = this.calculateDamageBits();
            Block block = this.calculateShieldBlock(damageBits);
            for (BlockPos templateBlock : templateBlocks) {
                RelCoordinate relc = new RelCoordinate(templateBlock.func_177958_n() - xCoord, templateBlock.func_177956_o() - yCoord, templateBlock.func_177952_p() - zCoord);
                this.shieldBlocks.add(relc);
                this.updateShieldBlock(camoId, cddata, damageBits, block, relc);
            }
        } else if (origBlock instanceof AbstractShieldBlock) {
            this.shieldBlocks.remove(new RelCoordinate(c.func_177958_n() - xCoord, c.func_177956_o() - yCoord, c.func_177952_p() - zCoord));
            if (this.isShapedShield()) {
                this.field_145850_b.func_175698_g(c);
            } else {
                this.field_145850_b.func_180501_a(c, ShieldSetup.shieldTemplateBlock.func_176203_a(this.templateMeta), 2);
            }
        } else {
            Logging.message((EntityPlayer)player, (String)(TextFormatting.YELLOW + "The selected shield can't do anything with this block!"));
            return;
        }
        this.markDirtyClient();
    }

    private void updateShield() {
        int[] camoId = this.calculateCamoId();
        int cddata = this.calculateShieldCollisionData();
        int damageBits = this.calculateDamageBits();
        Block block = this.calculateShieldBlock(damageBits);
        int xCoord = this.func_174877_v().func_177958_n();
        int yCoord = this.func_174877_v().func_177956_o();
        int zCoord = this.func_174877_v().func_177952_p();
        for (RelCoordinate c : this.shieldBlocks) {
            if (Blocks.field_150350_a.equals(block)) {
                this.field_145850_b.func_175698_g(new BlockPos(xCoord + c.getDx(), yCoord + c.getDy(), zCoord + c.getDz()));
                continue;
            }
            this.updateShieldBlock(camoId, cddata, damageBits, block, c);
        }
        this.markDirtyClient();
    }

    private void updateShieldBlock(int[] camoId, int cddata, int damageBits, Block block, RelCoordinate c) {
        int xCoord = this.func_174877_v().func_177958_n();
        int yCoord = this.func_174877_v().func_177956_o();
        int zCoord = this.func_174877_v().func_177952_p();
        BlockPos pp = new BlockPos(xCoord + c.getDx(), yCoord + c.getDy(), zCoord + c.getDz());
        this.field_145850_b.func_180501_a(pp, block.func_176203_a(camoId[1]), 2);
        TileEntity te = this.field_145850_b.func_175625_s(pp);
        if (te instanceof NoTickShieldBlockTileEntity) {
            NoTickShieldBlockTileEntity shieldBlockTileEntity = (NoTickShieldBlockTileEntity)te;
            shieldBlockTileEntity.setCamoBlock(camoId[0], camoId[2]);
            shieldBlockTileEntity.setShieldBlock(this.func_174877_v());
            shieldBlockTileEntity.setDamageBits(damageBits);
            shieldBlockTileEntity.setCollisionData(cddata);
            shieldBlockTileEntity.setShieldColor(this.shieldColor);
            shieldBlockTileEntity.setShieldRenderingMode(this.shieldRenderingMode);
        }
    }

    public void decomposeShield() {
        int xCoord = this.func_174877_v().func_177958_n();
        int yCoord = this.func_174877_v().func_177956_o();
        int zCoord = this.func_174877_v().func_177952_p();
        for (RelCoordinate c : this.shieldBlocks) {
            int cx = xCoord + c.getDx();
            int cy = yCoord + c.getDy();
            int cz = zCoord + c.getDz();
            BlockPos pp = new BlockPos(cx, cy, cz);
            Block block = this.field_145850_b.func_180495_p(pp).func_177230_c();
            if (this.field_145850_b.func_175623_d(pp) || block instanceof AbstractShieldBlock) {
                if (this.isShapedShield()) {
                    this.field_145850_b.func_175698_g(pp);
                    continue;
                }
                this.field_145850_b.func_180501_a(pp, ShieldSetup.shieldTemplateBlock.func_176203_a(this.templateMeta), 2);
                continue;
            }
            if (this.isShapedShield()) continue;
            BlockTools.spawnItemStack((World)this.field_145850_b, (int)cx, (int)cy, (int)cz, (ItemStack)new ItemStack((Block)ShieldSetup.shieldTemplateBlock, 1, this.templateMeta));
        }
        this.shieldComposed = false;
        this.shieldActive = false;
        this.shieldBlocks.clear();
        this.markDirtyClient();
    }

    private void findTemplateBlocks(Set<BlockPos> coordinateSet, int meta, boolean ctrl, BlockPos start) {
        ArrayDeque<BlockPos> todo = new ArrayDeque<BlockPos>();
        if (ctrl) {
            this.addToTodoCornered(coordinateSet, todo, start, meta);
            while (!todo.isEmpty() && coordinateSet.size() < this.supportedBlocks) {
                BlockPos coordinate = (BlockPos)todo.pollFirst();
                coordinateSet.add(coordinate);
                this.addToTodoCornered(coordinateSet, todo, coordinate, meta);
            }
        } else {
            this.addToTodoStraight(coordinateSet, todo, start, meta);
            while (!todo.isEmpty() && coordinateSet.size() < this.supportedBlocks) {
                BlockPos coordinate = (BlockPos)todo.pollFirst();
                coordinateSet.add(coordinate);
                this.addToTodoStraight(coordinateSet, todo, coordinate, meta);
            }
        }
    }

    private void addToTodoStraight(Set<BlockPos> coordinateSet, Deque<BlockPos> todo, BlockPos coordinate, int meta) {
        for (EnumFacing dir : EnumFacing.field_82609_l) {
            int m;
            IBlockState state;
            BlockPos pp = coordinate.func_177972_a(dir);
            if (pp.func_177956_o() < 0 || pp.func_177956_o() >= this.field_145850_b.func_72800_K() || coordinateSet.contains(pp) || !((Object)((Object)ShieldSetup.shieldTemplateBlock)).equals((state = this.field_145850_b.func_180495_p(pp)).func_177230_c()) || (m = state.func_177230_c().func_176201_c(state)) != meta || todo.contains(pp)) continue;
            todo.addLast(pp);
        }
    }

    private void addToTodoCornered(Set<BlockPos> coordinateSet, Deque<BlockPos> todo, BlockPos coordinate, int meta) {
        int x = coordinate.func_177958_n();
        int y = coordinate.func_177956_o();
        int z = coordinate.func_177952_p();
        for (int xx = x - 1; xx <= x + 1; ++xx) {
            for (int yy = y - 1; yy <= y + 1; ++yy) {
                for (int zz = z - 1; zz <= z + 1; ++zz) {
                    int m;
                    IBlockState state;
                    BlockPos c;
                    if (xx == x && yy == y && zz == z || yy < 0 || yy >= this.field_145850_b.func_72800_K() || coordinateSet.contains(c = new BlockPos(xx, yy, zz)) || !((Object)((Object)ShieldSetup.shieldTemplateBlock)).equals((state = this.field_145850_b.func_180495_p(c)).func_177230_c()) || (m = state.func_177230_c().func_176201_c(state)) != meta || todo.contains(c)) continue;
                    todo.addLast(c);
                }
            }
        }
    }

    private static short bytesToShort(byte b1, byte b2) {
        short s1 = (short)(b1 & 0xFF);
        short s2 = (short)(b2 & 0xFF);
        return (short)(s1 * 256 + s2);
    }

    private static byte shortToByte1(short s) {
        return (byte)((s & 0xFF00) >> 8);
    }

    private static byte shortToByte2(short s) {
        return (byte)(s & 0xFF);
    }

    public void readClientDataFromNBT(NBTTagCompound tagCompound) {
        this.powerLevel = tagCompound.func_74771_c("powered");
        this.shieldComposed = tagCompound.func_74767_n("composed");
        this.shieldActive = tagCompound.func_74767_n("active");
        this.powerTimeout = tagCompound.func_74762_e("powerTimeout");
        this.templateMeta = tagCompound.func_74762_e("templateMeta");
        this.shieldRenderingMode = ShieldRenderingMode.values()[tagCompound.func_74762_e("visMode")];
        this.rsMode = RedstoneMode.values()[tagCompound.func_74771_c(CMD_RSMODE)];
        this.damageMode = DamageTypeMode.values()[tagCompound.func_74771_c(CMD_DAMAGEMODE)];
        this.camoRenderPass = tagCompound.func_74762_e("camoRenderPass");
        this.shieldColor = tagCompound.func_74762_e("shieldColor");
        if (this.shieldColor == 0) {
            this.shieldColor = 9895880;
        }
        this.readFiltersFromNBT(tagCompound);
    }

    public void writeClientDataToNBT(NBTTagCompound tagCompound) {
        tagCompound.func_74774_a("powered", (byte)this.powerLevel);
        tagCompound.func_74757_a("composed", this.shieldComposed);
        tagCompound.func_74757_a("active", this.shieldActive);
        tagCompound.func_74768_a("powerTimeout", this.powerTimeout);
        tagCompound.func_74768_a("templateMeta", this.templateMeta);
        tagCompound.func_74768_a("visMode", this.shieldRenderingMode.ordinal());
        tagCompound.func_74774_a(CMD_RSMODE, (byte)this.rsMode.ordinal());
        tagCompound.func_74774_a(CMD_DAMAGEMODE, (byte)this.damageMode.ordinal());
        tagCompound.func_74768_a("camoRenderPass", this.camoRenderPass);
        tagCompound.func_74768_a("shieldColor", this.shieldColor);
        this.writeFiltersToNBT(tagCompound);
    }

    public void func_145839_a(NBTTagCompound tagCompound) {
        super.func_145839_a(tagCompound);
        this.shieldComposed = tagCompound.func_74767_n("composed");
        this.shieldActive = tagCompound.func_74767_n("active");
        this.powerTimeout = tagCompound.func_74762_e("powerTimeout");
        this.templateMeta = tagCompound.func_74762_e("templateMeta");
        this.shieldBlocks.clear();
        byte[] byteArray = tagCompound.func_74770_j("relcoords");
        int j = 0;
        for (int i = 0; i < byteArray.length / 6; ++i) {
            short dx = ShieldTEBase.bytesToShort(byteArray[j + 0], byteArray[j + 1]);
            short dy = ShieldTEBase.bytesToShort(byteArray[j + 2], byteArray[j + 3]);
            short dz = ShieldTEBase.bytesToShort(byteArray[j + 4], byteArray[j + 5]);
            j += 6;
            this.shieldBlocks.add(new RelCoordinate(dx, dy, dz));
        }
    }

    public void readRestorableFromNBT(NBTTagCompound tagCompound) {
        super.readRestorableFromNBT(tagCompound);
        this.readBufferFromNBT(tagCompound, this.inventoryHelper);
        this.shieldRenderingMode = ShieldRenderingMode.values()[tagCompound.func_74762_e("visMode")];
        this.damageMode = DamageTypeMode.values()[tagCompound.func_74771_c(CMD_DAMAGEMODE)];
        this.camoRenderPass = tagCompound.func_74762_e("camoRenderPass");
        this.shieldColor = tagCompound.func_74762_e("shieldColor");
        if (this.shieldColor == 0) {
            this.shieldColor = 9895880;
        }
        this.readFiltersFromNBT(tagCompound);
    }

    private void readFiltersFromNBT(NBTTagCompound tagCompound) {
        this.filters.clear();
        NBTTagList filterList = tagCompound.func_150295_c("filters", 10);
        if (filterList != null) {
            for (int i = 0; i < filterList.func_74745_c(); ++i) {
                NBTTagCompound compound = filterList.func_150305_b(i);
                this.filters.add(AbstractShieldFilter.createFilter(compound));
            }
        }
    }

    public NBTTagCompound func_189515_b(NBTTagCompound tagCompound) {
        super.func_189515_b(tagCompound);
        tagCompound.func_74757_a("composed", this.shieldComposed);
        tagCompound.func_74757_a("active", this.shieldActive);
        tagCompound.func_74768_a("powerTimeout", this.powerTimeout);
        tagCompound.func_74768_a("templateMeta", this.templateMeta);
        byte[] blocks = new byte[this.shieldBlocks.size() * 6];
        int j = 0;
        for (RelCoordinate c : this.shieldBlocks) {
            blocks[j + 0] = ShieldTEBase.shortToByte1((short)c.getDx());
            blocks[j + 1] = ShieldTEBase.shortToByte2((short)c.getDx());
            blocks[j + 2] = ShieldTEBase.shortToByte1((short)c.getDy());
            blocks[j + 3] = ShieldTEBase.shortToByte2((short)c.getDy());
            blocks[j + 4] = ShieldTEBase.shortToByte1((short)c.getDz());
            blocks[j + 5] = ShieldTEBase.shortToByte2((short)c.getDz());
            j += 6;
        }
        tagCompound.func_74773_a("relcoords", blocks);
        return tagCompound;
    }

    public void writeRestorableToNBT(NBTTagCompound tagCompound) {
        super.writeRestorableToNBT(tagCompound);
        this.writeBufferToNBT(tagCompound, this.inventoryHelper);
        tagCompound.func_74768_a("visMode", this.shieldRenderingMode.ordinal());
        tagCompound.func_74774_a(CMD_DAMAGEMODE, (byte)this.damageMode.ordinal());
        tagCompound.func_74768_a("camoRenderPass", this.camoRenderPass);
        tagCompound.func_74768_a("shieldColor", this.shieldColor);
        this.writeFiltersToNBT(tagCompound);
    }

    private void writeFiltersToNBT(NBTTagCompound tagCompound) {
        NBTTagList filterList = new NBTTagList();
        for (ShieldFilter filter : this.filters) {
            NBTTagCompound compound = new NBTTagCompound();
            filter.writeToNBT(compound);
            filterList.func_74742_a((NBTBase)compound);
        }
        tagCompound.func_74782_a("filters", (NBTBase)filterList);
    }

    public boolean execute(EntityPlayerMP playerMP, String command, Map<String, Argument> args) {
        boolean rc = super.execute(playerMP, command, args);
        if (rc) {
            return true;
        }
        if (CMD_SHIELDVISMODE.equals(command)) {
            String m = args.get("mode").getString();
            this.setShieldRenderingMode(ShieldRenderingMode.getMode(m));
            return true;
        }
        if (CMD_APPLYCAMO.equals(command)) {
            this.camoRenderPass = args.get("pass").getInteger();
            this.updateShield();
            return true;
        }
        if (CMD_ADDFILTER.equals(command)) {
            int action = args.get("action").getInteger();
            String type = args.get("type").getString();
            String player = args.get("player").getString();
            int selected = args.get("selected").getInteger();
            this.addFilter(action, type, player, selected);
            return true;
        }
        if (CMD_DELFILTER.equals(command)) {
            int selected = args.get("selected").getInteger();
            this.delFilter(selected);
            return true;
        }
        if (CMD_UPFILTER.equals(command)) {
            int selected = args.get("selected").getInteger();
            this.upFilter(selected);
            return true;
        }
        if (CMD_DOWNFILTER.equals(command)) {
            int selected = args.get("selected").getInteger();
            this.downFilter(selected);
            return true;
        }
        if (CMD_RSMODE.equals(command)) {
            String m = args.get("rs").getString();
            this.setRSMode(RedstoneMode.getMode((String)m));
            return true;
        }
        if (CMD_DAMAGEMODE.equals(command)) {
            String m = args.get("mode").getString();
            this.setDamageMode(DamageTypeMode.getMode(m));
            return true;
        }
        if (CMD_SETCOLOR.equals(command)) {
            int color = args.get("color").getInteger();
            this.setShieldColor(color);
            return true;
        }
        return false;
    }

    public List executeWithResultList(String command, Map<String, Argument> args) {
        List rc = super.executeWithResultList(command, args);
        if (rc != null) {
            return rc;
        }
        if ("getFilters".equals(command)) {
            return this.getFilters();
        }
        return null;
    }

    public boolean execute(String command, List list) {
        boolean rc = super.execute(command, list);
        if (rc) {
            return true;
        }
        if ("getFilters".equals(command)) {
            GuiShield.storeFiltersForClient(list);
            return true;
        }
        return false;
    }

    public ItemStack func_70298_a(int index, int amount) {
        ItemStack stackInSlot;
        if (index == 1 && this.inventoryHelper.getStackInSlot(index) != null && amount > 0) {
            this.decomposeShield();
        }
        if ((stackInSlot = this.inventoryHelper.getStackInSlot(index)) != null) {
            if (stackInSlot.field_77994_a <= amount) {
                ItemStack old = stackInSlot;
                this.inventoryHelper.setInventorySlotContents(this.func_70297_j_(), index, null);
                this.func_70296_d();
                return old;
            }
            ItemStack its = stackInSlot.func_77979_a(amount);
            if (stackInSlot.field_77994_a == 0) {
                this.inventoryHelper.setInventorySlotContents(this.func_70297_j_(), index, null);
            }
            this.func_70296_d();
            return its;
        }
        return null;
    }

    public void func_70299_a(int index, ItemStack stack) {
        if (index == 1 && (stack == null && this.inventoryHelper.getStackInSlot(index) != null || stack != null && this.inventoryHelper.getStackInSlot(index) == null)) {
            this.decomposeShield();
        }
        this.inventoryHelper.setInventorySlotContents(this.func_70297_j_(), index, stack);
        if (stack != null && stack.field_77994_a > this.func_70297_j_()) {
            stack.field_77994_a = this.func_70297_j_();
        }
        this.func_70296_d();
    }

    public InventoryHelper getInventoryHelper() {
        return this.inventoryHelper;
    }

    public boolean func_70300_a(EntityPlayer player) {
        return this.canPlayerAccess(player);
    }
}

