/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftools.blocks.shield;

import javax.annotation.Nullable;
import mcjty.rftools.blocks.shield.ShieldRenderingMode;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SPacketUpdateTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class NoTickShieldBlockTileEntity
extends TileEntity {
    private Block block;
    private int camoId = -1;
    private int hasTe = 0;
    private int shieldColor;
    private ShieldRenderingMode shieldRenderingMode = ShieldRenderingMode.MODE_SHIELD;
    protected int damageBits = 0;
    private int collisionData = 0;
    protected BlockPos shieldBlock;
    protected AxisAlignedBB beamBox = null;

    public boolean shouldRefresh(World world, BlockPos pos, IBlockState oldState, IBlockState newSate) {
        return oldState.func_177230_c() != newSate.func_177230_c();
    }

    public void setDamageBits(int damageBits) {
        this.damageBits = damageBits;
        this.markDirtyClient();
    }

    private void markDirtyClient() {
        this.func_70296_d();
        if (this.field_145850_b != null) {
            IBlockState state = this.field_145850_b.func_180495_p(this.func_174877_v());
            this.field_145850_b.func_184138_a(this.func_174877_v(), state, state, 3);
        }
    }

    public int getCollisionData() {
        return this.collisionData;
    }

    public void setCollisionData(int collisionData) {
        this.collisionData = collisionData;
        this.markDirtyClient();
    }

    public int getShieldColor() {
        return this.shieldColor;
    }

    public void setShieldColor(int shieldColor) {
        this.shieldColor = shieldColor;
        this.markDirtyClient();
    }

    public ShieldRenderingMode getShieldRenderingMode() {
        return this.shieldRenderingMode;
    }

    public void setShieldRenderingMode(ShieldRenderingMode shieldRenderingMode) {
        this.shieldRenderingMode = shieldRenderingMode;
        this.markDirtyClient();
    }

    public void setCamoBlock(int camoId, int hasTe) {
        this.camoId = camoId;
        this.hasTe = hasTe;
        this.block = camoId == -1 ? null : Block.func_149729_e((int)camoId);
        this.markDirtyClient();
    }

    public void setShieldBlock(BlockPos c) {
        this.shieldBlock = c;
        this.markDirtyClient();
    }

    public BlockPos getShieldBlock() {
        return this.shieldBlock;
    }

    public Block getBlock() {
        return this.block;
    }

    public boolean getHasTe() {
        return this.hasTe != 0;
    }

    public NBTTagCompound func_189515_b(NBTTagCompound tagCompound) {
        super.func_189515_b(tagCompound);
        tagCompound.func_74768_a("camoId", this.camoId);
        tagCompound.func_74768_a("hasTe", this.hasTe);
        tagCompound.func_74768_a("damageBits", this.damageBits);
        tagCompound.func_74768_a("collisionData", this.collisionData);
        tagCompound.func_74768_a("shieldColor", this.shieldColor);
        tagCompound.func_74768_a("stt", this.shieldRenderingMode.ordinal());
        if (this.shieldBlock != null) {
            tagCompound.func_74768_a("shieldX", this.shieldBlock.func_177958_n());
            tagCompound.func_74768_a("shieldY", this.shieldBlock.func_177956_o());
            tagCompound.func_74768_a("shieldZ", this.shieldBlock.func_177952_p());
        }
        return tagCompound;
    }

    public NBTTagCompound func_189517_E_() {
        NBTTagCompound updateTag = super.func_189517_E_();
        this.func_189515_b(updateTag);
        return updateTag;
    }

    public void func_145839_a(NBTTagCompound tagCompound) {
        super.func_145839_a(tagCompound);
        this.camoId = tagCompound.func_74762_e("camoId");
        this.hasTe = tagCompound.func_74762_e("hasTe");
        this.block = this.camoId == -1 ? null : Block.func_149729_e((int)this.camoId);
        this.damageBits = tagCompound.func_74762_e("damageBits");
        this.collisionData = tagCompound.func_74762_e("collisionData");
        this.shieldColor = tagCompound.func_74762_e("shieldColor");
        if (this.shieldColor == 0) {
            this.shieldColor = 9895880;
        }
        this.shieldRenderingMode = ShieldRenderingMode.values()[tagCompound.func_74762_e("stt")];
        int sx = tagCompound.func_74762_e("shieldX");
        int sy = tagCompound.func_74762_e("shieldY");
        int sz = tagCompound.func_74762_e("shieldZ");
        this.shieldBlock = new BlockPos(sx, sy, sz);
        if (this.field_145850_b != null && this.field_145850_b.field_72995_K) {
            this.field_145850_b.func_175704_b(this.func_174877_v(), this.func_174877_v());
        }
    }

    @Nullable
    public SPacketUpdateTileEntity func_189518_D_() {
        NBTTagCompound nbtTag = new NBTTagCompound();
        this.func_189515_b(nbtTag);
        return new SPacketUpdateTileEntity(this.func_174877_v(), 1, nbtTag);
    }

    public void onDataPacket(NetworkManager net, SPacketUpdateTileEntity packet) {
        this.func_145839_a(packet.func_148857_g());
    }
}

