/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftools.blocks.screens.modules;

import io.netty.buffer.ByteBuf;
import mcjty.lib.varia.BlockPosTools;
import mcjty.lib.varia.SoundTools;
import mcjty.rftools.api.screens.IScreenDataHelper;
import mcjty.rftools.api.screens.IScreenModule;
import mcjty.rftools.api.screens.IScreenModuleUpdater;
import mcjty.rftools.api.screens.ITooltipInfo;
import mcjty.rftools.api.screens.data.IModuleData;
import mcjty.rftools.blocks.screens.ScreenConfiguration;
import mcjty.rftools.blocks.storagemonitor.StorageScannerTileEntity;
import mcjty.rftools.varia.RFToolsTools;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumHand;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.common.DimensionManager;

public class StorageControlScreenModule
implements IScreenModule<ModuleDataStacks>,
ITooltipInfo,
IScreenModuleUpdater {
    private ItemStack[] stacks = new ItemStack[9];
    protected int dim = 0;
    protected BlockPos coordinate = BlockPosTools.INVALID;
    private boolean starred = false;
    private boolean oredict = false;
    private int dirty = -1;

    @Override
    public ModuleDataStacks getData(IScreenDataHelper helper, World worldObj, long millis) {
        StorageScannerTileEntity scannerTileEntity = StorageControlScreenModule.getStorageScanner(this.dim, this.coordinate);
        if (scannerTileEntity == null) {
            return null;
        }
        int[] amounts = new int[this.stacks.length];
        for (int i = 0; i < this.stacks.length; ++i) {
            amounts[i] = scannerTileEntity.countStack(this.stacks[i], this.starred, this.oredict);
        }
        return new ModuleDataStacks(amounts);
    }

    public static StorageScannerTileEntity getStorageScanner(int dim, BlockPos coordinate) {
        WorldServer world = DimensionManager.getWorld((int)dim);
        if (world == null) {
            return null;
        }
        if (!RFToolsTools.chunkLoaded((World)world, coordinate)) {
            return null;
        }
        TileEntity te = world.func_175625_s(coordinate);
        if (te == null) {
            return null;
        }
        if (!(te instanceof StorageScannerTileEntity)) {
            return null;
        }
        return (StorageScannerTileEntity)te;
    }

    @Override
    public void setupFromNBT(NBTTagCompound tagCompound, int dim, BlockPos pos) {
        StorageScannerTileEntity te;
        if (tagCompound != null) {
            this.setupCoordinateFromNBT(tagCompound, dim, pos);
            for (int i = 0; i < this.stacks.length; ++i) {
                if (!tagCompound.func_74764_b("stack" + i)) continue;
                this.stacks[i] = ItemStack.func_77949_a((NBTTagCompound)tagCompound.func_74775_l("stack" + i));
            }
        }
        if ((te = StorageControlScreenModule.getStorageScanner(dim, this.coordinate)) != null) {
            te.clearCachedCounts();
        }
    }

    private int getHighlightedStack(int hitx, int hity) {
        int i = 0;
        for (int yy = 0; yy < 3; ++yy) {
            int y = 7 + yy * 35;
            for (int xx = 0; xx < 3; ++xx) {
                boolean hilighted;
                int x = xx * 40;
                boolean bl = hilighted = hitx >= x + 8 && hitx <= x + 38 && hity >= y - 7 && hity <= y + 22;
                if (hilighted) {
                    return i;
                }
                ++i;
            }
        }
        return -1;
    }

    @Override
    public String[] getInfo(World world, int x, int y, EntityPlayer player) {
        int i;
        StorageScannerTileEntity te = StorageControlScreenModule.getStorageScanner(this.dim, this.coordinate);
        if (te != null && (i = this.getHighlightedStack(x, y)) != -1 && this.stacks[i] != null) {
            return new String[]{TextFormatting.GREEN + "Item: " + TextFormatting.WHITE + this.stacks[i].func_82833_r()};
        }
        return new String[0];
    }

    protected void setupCoordinateFromNBT(NBTTagCompound tagCompound, int dim, BlockPos pos) {
        this.coordinate = BlockPosTools.INVALID;
        this.starred = tagCompound.func_74767_n("starred");
        this.oredict = tagCompound.func_74767_n("oredict");
        if (tagCompound.func_74764_b("monitorx")) {
            this.dim = tagCompound.func_74764_b("monitordim") ? tagCompound.func_74762_e("monitordim") : tagCompound.func_74762_e("dim");
            if (dim == this.dim) {
                BlockPos c = new BlockPos(tagCompound.func_74762_e("monitorx"), tagCompound.func_74762_e("monitory"), tagCompound.func_74762_e("monitorz"));
                int dx = Math.abs(c.func_177958_n() - pos.func_177958_n());
                int dy = Math.abs(c.func_177956_o() - pos.func_177956_o());
                int dz = Math.abs(c.func_177952_p() - pos.func_177952_p());
                if (dx <= 64 && dy <= 64 && dz <= 64) {
                    this.coordinate = c;
                }
            }
        }
    }

    @Override
    public int getRfPerTick() {
        return ScreenConfiguration.STORAGE_CONTROL_RFPERTICK;
    }

    private boolean isShown(ItemStack stack) {
        if (stack == null) {
            return false;
        }
        for (ItemStack s : this.stacks) {
            if (!StorageScannerTileEntity.isItemEqual(stack, s, this.oredict)) continue;
            return true;
        }
        return false;
    }

    @Override
    public NBTTagCompound update(NBTTagCompound tagCompound, World world, EntityPlayer player) {
        if (this.dirty >= 0) {
            NBTTagCompound newCompound = tagCompound.func_74737_b();
            NBTTagCompound tc = new NBTTagCompound();
            this.stacks[this.dirty].func_77955_b(tc);
            newCompound.func_74782_a("stack" + this.dirty, (NBTBase)tc);
            if (player != null) {
                SoundTools.playSound((World)player.field_70170_p, (SoundEvent)SoundEvents.field_187604_bf, (double)player.func_180425_c().func_177958_n(), (double)player.func_180425_c().func_177956_o(), (double)player.func_180425_c().func_177952_p(), (double)1.0, (double)1.0);
            }
            this.dirty = -1;
            return newCompound;
        }
        return null;
    }

    @Override
    public void mouseClick(World world, int hitx, int hity, boolean clicked, EntityPlayer player) {
        if (!clicked || player == null) {
            return;
        }
        if (BlockPosTools.INVALID.equals((Object)this.coordinate)) {
            player.func_146105_b((ITextComponent)new TextComponentString(TextFormatting.RED + "Module is not linked to storage scanner!"));
            return;
        }
        StorageScannerTileEntity scannerTileEntity = StorageControlScreenModule.getStorageScanner(this.dim, this.coordinate);
        if (scannerTileEntity == null) {
            return;
        }
        if (hitx >= 0) {
            boolean insertAllActive;
            boolean insertStackActive;
            boolean bl = insertStackActive = hitx >= 0 && hitx < 60 && hity > 98;
            if (insertStackActive) {
                if (this.isShown(player.func_184586_b(EnumHand.MAIN_HAND))) {
                    ItemStack stack = scannerTileEntity.injectStack(player.func_184586_b(EnumHand.MAIN_HAND), player);
                    player.func_184611_a(EnumHand.MAIN_HAND, stack);
                }
                player.field_71070_bA.func_75142_b();
                return;
            }
            boolean bl2 = insertAllActive = hitx >= 60 && hity > 98;
            if (insertAllActive) {
                for (int i = 0; i < player.field_71071_by.func_70302_i_(); ++i) {
                    if (!this.isShown(player.field_71071_by.func_70301_a(i))) continue;
                    ItemStack stack = scannerTileEntity.injectStack(player.field_71071_by.func_70301_a(i), player);
                    player.field_71071_by.func_70299_a(i, stack);
                }
                player.field_71070_bA.func_75142_b();
                return;
            }
            int i = this.getHighlightedStack(hitx, hity);
            if (i != -1) {
                if (this.stacks[i] == null) {
                    ItemStack heldItem = player.func_184614_ca();
                    if (heldItem != null) {
                        this.stacks[i] = heldItem.func_77946_l();
                        this.stacks[i].field_77994_a = 1;
                        this.dirty = i;
                    }
                } else {
                    scannerTileEntity.giveToPlayer(this.stacks[i], player.func_70093_af(), player, this.oredict);
                }
            }
        }
    }

    public static class ModuleDataStacks
    implements IModuleData {
        public static final String ID = "rftools:storage";
        private int[] amounts = null;

        @Override
        public String getId() {
            return ID;
        }

        public ModuleDataStacks(int ... amountsIn) {
            this.amounts = amountsIn;
        }

        public ModuleDataStacks(ByteBuf buf) {
            int s = buf.readInt();
            this.amounts = new int[s];
            for (int i = 0; i < s; ++i) {
                this.amounts[i] = buf.readInt();
            }
        }

        public int getAmount(int idx) {
            return this.amounts[idx];
        }

        @Override
        public void writeToBuf(ByteBuf buf) {
            buf.writeInt(this.amounts.length);
            for (int i : this.amounts) {
                buf.writeInt(i);
            }
        }
    }
}

