/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftools.blocks.screens.modules;

import mcjty.lib.varia.BlockPosTools;
import mcjty.rftools.api.screens.IScreenDataHelper;
import mcjty.rftools.api.screens.IScreenModule;
import mcjty.rftools.api.screens.data.IModuleDataContents;
import mcjty.rftools.blocks.screens.ScreenConfiguration;
import mcjty.rftools.blocks.screens.modules.ScreenModuleHelper;
import mcjty.rftools.varia.EnergyTools;
import mcjty.rftools.varia.RFToolsTools;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.common.DimensionManager;

public class EnergyBarScreenModule
implements IScreenModule<IModuleDataContents> {
    protected int dim = 0;
    protected BlockPos coordinate = BlockPosTools.INVALID;
    protected ScreenModuleHelper helper = new ScreenModuleHelper();

    @Override
    public IModuleDataContents getData(IScreenDataHelper h, World worldObj, long millis) {
        WorldServer world = DimensionManager.getWorld((int)this.dim);
        if (world == null) {
            return null;
        }
        if (!RFToolsTools.chunkLoaded((World)world, this.coordinate)) {
            return null;
        }
        TileEntity te = world.func_175625_s(this.coordinate);
        if (!EnergyTools.isEnergyTE(te)) {
            return null;
        }
        EnergyTools.EnergyLevelMulti energyLevel = EnergyTools.getEnergyLevelMulti(te);
        long energy = energyLevel.getEnergy();
        long maxEnergy = energyLevel.getMaxEnergy();
        return this.helper.getContentsValue(millis, energy, maxEnergy);
    }

    @Override
    public void setupFromNBT(NBTTagCompound tagCompound, int dim, BlockPos pos) {
        if (tagCompound != null) {
            this.helper.setShowdiff(tagCompound.func_74767_n("showdiff"));
            this.coordinate = BlockPosTools.INVALID;
            if (tagCompound.func_74764_b("monitorx")) {
                this.dim = tagCompound.func_74764_b("monitordim") ? tagCompound.func_74762_e("monitordim") : tagCompound.func_74762_e("dim");
                if (dim == this.dim) {
                    BlockPos c = new BlockPos(tagCompound.func_74762_e("monitorx"), tagCompound.func_74762_e("monitory"), tagCompound.func_74762_e("monitorz"));
                    int dx = Math.abs(c.func_177958_n() - pos.func_177958_n());
                    int dy = Math.abs(c.func_177956_o() - pos.func_177956_o());
                    int dz = Math.abs(c.func_177952_p() - pos.func_177952_p());
                    if (dx <= 64 && dy <= 64 && dz <= 64) {
                        this.coordinate = c;
                    }
                }
            }
        }
    }

    @Override
    public int getRfPerTick() {
        return ScreenConfiguration.ENERGY_RFPERTICK;
    }

    @Override
    public void mouseClick(World world, int x, int y, boolean clicked, EntityPlayer player) {
    }
}

