/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftools.blocks.screens;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import mcjty.lib.container.GenericBlock;
import mcjty.lib.varia.GlobalCoordinate;
import mcjty.rftools.api.screens.IClientScreenModule;
import mcjty.rftools.api.screens.ModuleRenderInfo;
import mcjty.rftools.api.screens.data.IModuleData;
import mcjty.rftools.blocks.screens.ModelScreen;
import mcjty.rftools.blocks.screens.ScreenSetup;
import mcjty.rftools.blocks.screens.ScreenTileEntity;
import mcjty.rftools.blocks.screens.modulesclient.ClientScreenModuleHelper;
import mcjty.rftools.blocks.screens.network.PacketGetScreenData;
import mcjty.rftools.network.RFToolsMessages;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.VertexBuffer;
import net.minecraft.client.renderer.tileentity.TileEntitySpecialRenderer;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.lwjgl.opengl.GL11;

@SideOnly(value=Side.CLIENT)
public class ScreenRenderer
extends TileEntitySpecialRenderer<ScreenTileEntity> {
    private static final ResourceLocation texture = new ResourceLocation("rftools", "textures/blocks/screenFrame.png");
    private final ModelScreen screenModel = new ModelScreen(0);
    private final ModelScreen screenModelLarge = new ModelScreen(1);
    private final ModelScreen screenModelHuge = new ModelScreen(2);
    private ClientScreenModuleHelper clientScreenModuleHelper = new ClientScreenModuleHelper();

    public void renderTileEntityAt(ScreenTileEntity tileEntity, double x, double y, double z, float partialTicks, int destroyStage) {
        int meta;
        GlStateManager.func_179123_a();
        GlStateManager.func_179094_E();
        int n = meta = tileEntity == null ? 0 : tileEntity.func_145832_p();
        float f3 = meta == 2 ? 180.0f : (meta == 4 ? 90.0f : (meta == 5 ? -90.0f : 0.0f));
        GlStateManager.func_179109_b((float)((float)x + 0.5f), (float)((float)y + 0.75f), (float)((float)z + 0.5f));
        GlStateManager.func_179114_b((float)(-f3), (float)0.0f, (float)1.0f, (float)0.0f);
        GlStateManager.func_179109_b((float)0.0f, (float)-0.25f, (float)-0.4375f);
        if (tileEntity == null) {
            GlStateManager.func_179140_f();
            this.renderScreenBoard(0, 0);
        } else if (!tileEntity.isTransparent()) {
            GlStateManager.func_179140_f();
            this.renderScreenBoard(tileEntity.getSize(), tileEntity.getColor());
        }
        if (tileEntity != null && tileEntity.isRenderable()) {
            FontRenderer fontrenderer = this.func_147498_b();
            IClientScreenModule.TransformMode mode = IClientScreenModule.TransformMode.NONE;
            GlStateManager.func_179132_a((boolean)false);
            GlStateManager.func_179140_f();
            Map<Integer, IModuleData> screenData = this.updateScreenData(tileEntity);
            List<IClientScreenModule> modules = tileEntity.getClientScreenModules();
            this.renderModules(fontrenderer, tileEntity, mode, modules, screenData, tileEntity.getSize());
        }
        GlStateManager.func_179145_e();
        GlStateManager.func_179132_a((boolean)true);
        GlStateManager.func_179121_F();
        GlStateManager.func_179099_b();
    }

    private Map<Integer, IModuleData> updateScreenData(ScreenTileEntity screenTileEntity) {
        GlobalCoordinate key;
        Map screenData;
        long millis = System.currentTimeMillis();
        if (millis - screenTileEntity.lastTime > 500L && screenTileEntity.isNeedsServerData()) {
            screenTileEntity.lastTime = millis;
            GlobalCoordinate pos = new GlobalCoordinate(screenTileEntity.func_174877_v(), screenTileEntity.func_145831_w().field_73011_w.getDimension());
            RFToolsMessages.INSTANCE.sendToServer((IMessage)new PacketGetScreenData("rftools", pos, millis));
        }
        if ((screenData = ScreenTileEntity.screenData.get(key = new GlobalCoordinate(screenTileEntity.func_174877_v(), screenTileEntity.func_145831_w().field_73011_w.getDimension()))) == null) {
            screenData = Collections.EMPTY_MAP;
        }
        return screenData;
    }

    private void renderModules(FontRenderer fontrenderer, ScreenTileEntity tileEntity, IClientScreenModule.TransformMode mode, List<IClientScreenModule> modules, Map<Integer, IModuleData> screenData, int size) {
        float factor = (float)size + 1.0f;
        int currenty = 7;
        int moduleIndex = 0;
        BlockPos pos = tileEntity.func_174877_v();
        RayTraceResult mouseOver = Minecraft.func_71410_x().field_71476_x;
        IClientScreenModule hitModule = null;
        ScreenTileEntity.ModuleRaytraceResult hit = null;
        IBlockState blockState = this.func_178459_a().func_180495_p(pos);
        if (blockState.func_177230_c() != ScreenSetup.screenBlock && blockState.func_177230_c() != ScreenSetup.creativeScreenBlock && blockState.func_177230_c() != ScreenSetup.screenHitBlock) {
            return;
        }
        if (mouseOver != null && mouseOver.field_178784_b == blockState.func_177229_b((IProperty)GenericBlock.FACING)) {
            double zz;
            double yy;
            double xx = mouseOver.field_72307_f.field_72450_a - (double)pos.func_177958_n();
            hit = tileEntity.getHitModule(xx, yy = mouseOver.field_72307_f.field_72448_b - (double)pos.func_177956_o(), zz = mouseOver.field_72307_f.field_72449_c - (double)pos.func_177952_p(), mouseOver.field_178784_b);
            if (hit != null) {
                hitModule = modules.get(hit.getModuleIndex());
            }
            tileEntity.focusModuleClient(xx, yy, zz, mouseOver.field_178784_b);
        }
        for (IClientScreenModule module : modules) {
            int height;
            if (module != null && currenty + (height = module.getHeight()) <= 124) {
                if (module.getTransformMode() != mode) {
                    if (mode != IClientScreenModule.TransformMode.NONE) {
                        GlStateManager.func_179121_F();
                    }
                    GlStateManager.func_179094_E();
                    mode = module.getTransformMode();
                    switch (mode) {
                        case TEXT: {
                            GlStateManager.func_179109_b((float)-0.5f, (float)0.5f, (float)0.07f);
                            float f3 = 0.0075f;
                            GlStateManager.func_179152_a((float)(f3 * factor), (float)(-f3 * factor), (float)f3);
                            GL11.glNormal3f((float)0.0f, (float)0.0f, (float)-1.0f);
                            GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                            break;
                        }
                        case TEXTLARGE: {
                            GlStateManager.func_179109_b((float)-0.5f, (float)0.5f, (float)0.07f);
                            float f3 = 0.015f;
                            GlStateManager.func_179152_a((float)(f3 * factor), (float)(-f3 * factor), (float)f3);
                            GL11.glNormal3f((float)0.0f, (float)0.0f, (float)-1.0f);
                            GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                            break;
                        }
                        case ITEM: {
                            break;
                        }
                    }
                }
                IModuleData data = screenData.get(moduleIndex);
                try {
                    int hitx = -1;
                    int hity = -1;
                    if (module == hitModule) {
                        hitx = hit.getX();
                        hity = hit.getY() - hit.getCurrenty();
                    }
                    ModuleRenderInfo renderInfo = new ModuleRenderInfo(factor, pos, hitx, hity);
                    module.render(this.clientScreenModuleHelper, fontrenderer, currenty, data, renderInfo);
                }
                catch (ClassCastException classCastException) {
                    // empty catch block
                }
                currenty += height;
            }
            ++moduleIndex;
        }
        if (mode != IClientScreenModule.TransformMode.NONE) {
            GlStateManager.func_179121_F();
        }
    }

    private void renderScreenBoard(int size, int color) {
        this.func_147499_a(texture);
        GlStateManager.func_179094_E();
        GlStateManager.func_179152_a((float)1.0f, (float)-1.0f, (float)-1.0f);
        if (size == 2) {
            this.screenModelHuge.render();
        } else if (size == 1) {
            this.screenModelLarge.render();
        } else {
            this.screenModel.render();
        }
        GlStateManager.func_179132_a((boolean)false);
        Tessellator tessellator = Tessellator.func_178181_a();
        VertexBuffer renderer = tessellator.func_178180_c();
        renderer.func_181668_a(7, DefaultVertexFormats.field_181706_f);
        float dim = size == 2 ? 2.46f : (size == 1 ? 1.46f : 0.46f);
        float r = (float)((color & 0xFF0000) >> 16) / 255.0f;
        float g = (float)((color & 0xFF00) >> 8) / 255.0f;
        float b = (float)((color & 0xFF) >> 0) / 255.0f;
        renderer.func_181662_b((double)-0.46f, (double)dim, (double)-0.08f).func_181666_a(r, g, b, 1.0f).func_181675_d();
        renderer.func_181662_b((double)dim, (double)dim, (double)-0.08f).func_181666_a(r, g, b, 1.0f).func_181675_d();
        renderer.func_181662_b((double)dim, (double)-0.46f, (double)-0.08f).func_181666_a(r, g, b, 1.0f).func_181675_d();
        renderer.func_181662_b((double)-0.46f, (double)-0.46f, (double)-0.08f).func_181666_a(r, g, b, 1.0f).func_181675_d();
        tessellator.func_78381_a();
        GlStateManager.func_179121_F();
    }
}

