/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftools.blocks.screens;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import mcjty.lib.entity.GenericEnergyReceiverTileEntity;
import mcjty.lib.network.Argument;
import mcjty.rftools.blocks.screens.ScreenConfiguration;
import mcjty.rftools.blocks.screens.ScreenSetup;
import mcjty.rftools.blocks.screens.ScreenTileEntity;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ITickable;
import net.minecraft.util.math.BlockPos;

public class ScreenControllerTileEntity
extends GenericEnergyReceiverTileEntity
implements ITickable {
    public static final String CMD_SCAN = "scan";
    public static final String CMD_DETACH = "detach";
    public static final String COMPONENT_NAME = "screen_controller";
    private List<BlockPos> connectedScreens = new ArrayList<BlockPos>();
    private int tickCounter = 20;

    public ScreenControllerTileEntity() {
        super(ScreenConfiguration.CONTROLLER_MAXENERGY, ScreenConfiguration.CONTROLLER_RECEIVEPERTICK);
    }

    public void func_145839_a(NBTTagCompound tagCompound) {
        super.func_145839_a(tagCompound);
        int[] xes = tagCompound.func_74759_k("screensx");
        int[] yes = tagCompound.func_74759_k("screensy");
        int[] zes = tagCompound.func_74759_k("screensz");
        this.connectedScreens.clear();
        for (int i = 0; i < xes.length; ++i) {
            this.connectedScreens.add(new BlockPos(xes[i], yes[i], zes[i]));
        }
    }

    public void readRestorableFromNBT(NBTTagCompound tagCompound) {
        super.readRestorableFromNBT(tagCompound);
    }

    public NBTTagCompound func_189515_b(NBTTagCompound tagCompound) {
        super.func_189515_b(tagCompound);
        int[] xes = new int[this.connectedScreens.size()];
        int[] yes = new int[this.connectedScreens.size()];
        int[] zes = new int[this.connectedScreens.size()];
        for (int i = 0; i < this.connectedScreens.size(); ++i) {
            BlockPos c = this.connectedScreens.get(i);
            xes[i] = c.func_177958_n();
            yes[i] = c.func_177956_o();
            zes[i] = c.func_177952_p();
        }
        tagCompound.func_74783_a("screensx", xes);
        tagCompound.func_74783_a("screensy", yes);
        tagCompound.func_74783_a("screensz", zes);
        return tagCompound;
    }

    public void writeRestorableToNBT(NBTTagCompound tagCompound) {
        super.writeRestorableToNBT(tagCompound);
    }

    public void func_73660_a() {
        if (!this.field_145850_b.field_72995_K) {
            this.checkStateServer();
        }
    }

    private void checkStateServer() {
        int rf;
        --this.tickCounter;
        if (this.tickCounter > 0) {
            return;
        }
        this.tickCounter = 20;
        int rememberRf = rf = this.getEnergyStored(EnumFacing.DOWN);
        boolean fixesAreNeeded = false;
        for (BlockPos c : this.connectedScreens) {
            TileEntity te = this.field_145850_b.func_175625_s(c);
            if (te instanceof ScreenTileEntity) {
                ScreenTileEntity screenTileEntity = (ScreenTileEntity)te;
                int rfModule = screenTileEntity.getTotalRfPerTick() * 20;
                if (rfModule > rf) {
                    screenTileEntity.setPower(false);
                    continue;
                }
                rf -= rfModule;
                screenTileEntity.setPower(true);
                continue;
            }
            fixesAreNeeded = true;
        }
        if (rf < rememberRf) {
            this.consumeEnergy(rememberRf - rf);
        }
        if (fixesAreNeeded) {
            ArrayList<BlockPos> newScreens = new ArrayList<BlockPos>();
            for (BlockPos c : this.connectedScreens) {
                TileEntity te = this.field_145850_b.func_175625_s(c);
                if (!(te instanceof ScreenTileEntity)) continue;
                newScreens.add(c);
            }
            this.connectedScreens = newScreens;
            this.markDirtyClient();
        }
    }

    private void scan() {
        this.detach();
        int radius = 32 + (int)(this.getInfusedFactor() * 32.0f);
        int xCoord = this.func_174877_v().func_177958_n();
        int yCoord = this.func_174877_v().func_177956_o();
        int zCoord = this.func_174877_v().func_177952_p();
        for (int y = yCoord - radius; y <= yCoord + radius; ++y) {
            if (y < 0 || y >= 256) continue;
            for (int x = xCoord - radius; x <= xCoord + radius; ++x) {
                for (int z = zCoord - radius; z <= zCoord + radius; ++z) {
                    TileEntity te;
                    BlockPos spos = new BlockPos(x, y, z);
                    if (this.field_145850_b.func_180495_p(spos).func_177230_c() != ScreenSetup.screenBlock || !((te = this.field_145850_b.func_175625_s(spos)) instanceof ScreenTileEntity) || ((ScreenTileEntity)te).isConnected()) continue;
                    this.connectedScreens.add(spos);
                    ((ScreenTileEntity)te).setConnected(true);
                }
            }
        }
        this.markDirtyClient();
    }

    public void detach() {
        for (BlockPos c : this.connectedScreens) {
            TileEntity te = this.field_145850_b.func_175625_s(c);
            if (!(te instanceof ScreenTileEntity)) continue;
            ((ScreenTileEntity)te).setPower(false);
            ((ScreenTileEntity)te).setConnected(false);
        }
        this.connectedScreens.clear();
        this.markDirtyClient();
    }

    public List<BlockPos> getConnectedScreens() {
        return this.connectedScreens;
    }

    public boolean execute(EntityPlayerMP playerMP, String command, Map<String, Argument> args) {
        boolean rc = super.execute(playerMP, command, args);
        if (rc) {
            return true;
        }
        if (CMD_SCAN.equals(command)) {
            this.scan();
            return true;
        }
        if (CMD_DETACH.equals(command)) {
            this.detach();
            return true;
        }
        return false;
    }
}

