/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftools.blocks.relay;

import cofh.api.energy.IEnergyConnection;
import java.util.Map;
import mcjty.lib.entity.GenericEnergyHandlerTileEntity;
import mcjty.lib.network.Argument;
import mcjty.lib.varia.BlockTools;
import mcjty.rftools.varia.EnergyTools;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ITickable;

public class RelayTileEntity
extends GenericEnergyHandlerTileEntity
implements ITickable {
    public static final int MAXENERGY = 50000;
    public static final int RECEIVEPERTICK = 50000;
    public static final String CMD_SETTINGS = "settings";
    private boolean[] inputModeOn = new boolean[]{false, false, false, false, false, false};
    private boolean[] inputModeOff = new boolean[]{false, false, false, false, false, false};
    private int[] rfOn = new int[]{1000, 1000, 1000, 1000, 1000, 1000};
    private int[] rfOff = new int[]{0, 0, 0, 0, 0, 0};
    public static final String DUNSWE = "DUNSWE";

    public RelayTileEntity() {
        super(50000, 50000);
    }

    public void func_73660_a() {
        if (!this.field_145850_b.field_72995_K) {
            this.checkStateServer();
        }
    }

    public boolean isPowered() {
        return this.powerLevel > 0;
    }

    private void checkStateServer() {
        boolean redstoneSignal = this.powerLevel > 0;
        int[] rf = redstoneSignal ? this.rfOn : this.rfOff;
        boolean[] inputMode = redstoneSignal ? this.inputModeOn : this.inputModeOff;
        int energyStored = this.getEnergyStored(EnumFacing.DOWN);
        if (energyStored <= 0) {
            return;
        }
        IBlockState state = this.field_145850_b.func_180495_p(this.func_174877_v());
        int meta = state.func_177230_c().func_176201_c(state);
        for (EnumFacing facing : EnumFacing.field_82609_l) {
            int rfToGive;
            int received;
            EnumFacing opposite;
            IEnergyConnection connection;
            TileEntity te;
            int side = BlockTools.reorient((EnumFacing)facing, (int)meta).ordinal();
            if (rf[side] <= 0 || inputMode[side] || !EnergyTools.isEnergyTE(te = this.field_145850_b.func_175625_s(this.func_174877_v().func_177972_a(facing))) || !(connection = (IEnergyConnection)te).canConnectEnergy(opposite = facing.func_176734_d()) || (energyStored -= this.storage.extractEnergy(received = EnergyTools.receiveEnergy(te, opposite, rfToGive = rf[side] <= energyStored ? rf[side] : energyStored), false)) > 0) continue;
            return;
        }
    }

    public int extractEnergy(EnumFacing from, int maxExtract, boolean simulate) {
        return 0;
    }

    public int receiveEnergy(EnumFacing from, int maxReceive, boolean simulate) {
        IBlockState state;
        int meta;
        int side;
        boolean redstoneSignal = this.powerLevel > 0;
        boolean[] inputMode = redstoneSignal ? this.inputModeOn : this.inputModeOff;
        if (inputMode[side = BlockTools.reorient((EnumFacing)from, (int)(meta = (state = this.field_145850_b.func_180495_p(this.func_174877_v())).func_177230_c().func_176201_c(state))).ordinal()]) {
            int[] rf = redstoneSignal ? this.rfOn : this.rfOff;
            return super.receiveEnergy(from, Math.min(maxReceive, rf[side]), simulate);
        }
        return 0;
    }

    public boolean isInputModeOn(int side) {
        return this.inputModeOn[side];
    }

    public boolean isInputModeOff(int side) {
        return this.inputModeOff[side];
    }

    public int getRfOn(int side) {
        return this.rfOn[side];
    }

    public int getRfOff(int side) {
        return this.rfOff[side];
    }

    public void readRestorableFromNBT(NBTTagCompound tagCompound) {
        super.readRestorableFromNBT(tagCompound);
        if (tagCompound.func_74764_b("rfOn")) {
            int on = tagCompound.func_74762_e("rfOn");
            int off = tagCompound.func_74762_e("rfOff");
            for (int i = 0; i < 6; ++i) {
                this.rfOn[i] = on;
                this.rfOff[i] = off;
                this.inputModeOn[i] = false;
                this.inputModeOff[i] = false;
            }
        } else {
            int i;
            int[] on = tagCompound.func_74759_k("on");
            int[] off = tagCompound.func_74759_k("off");
            System.arraycopy(on, 0, this.rfOn, 0, Math.min(6, on.length));
            System.arraycopy(off, 0, this.rfOff, 0, Math.min(6, off.length));
            byte[] inOn = tagCompound.func_74770_j("inputOn");
            byte[] inOff = tagCompound.func_74770_j("inputOff");
            for (i = 0; i < Math.min(6, inOn.length); ++i) {
                this.inputModeOn[i] = inOn[i] > 0;
            }
            for (i = 0; i < Math.min(6, inOff.length); ++i) {
                this.inputModeOff[i] = inOff[i] > 0;
            }
        }
    }

    public void writeRestorableToNBT(NBTTagCompound tagCompound) {
        super.writeRestorableToNBT(tagCompound);
        tagCompound.func_74783_a("on", this.rfOn);
        tagCompound.func_74783_a("off", this.rfOff);
        byte[] inOn = new byte[6];
        byte[] inOff = new byte[6];
        for (int i = 0; i < 6; ++i) {
            inOn[i] = (byte)(this.inputModeOn[i] ? 1 : 0);
            inOff[i] = (byte)(this.inputModeOff[i] ? 1 : 0);
        }
        tagCompound.func_74773_a("inputOn", inOn);
        tagCompound.func_74773_a("inputOff", inOff);
    }

    public boolean execute(EntityPlayerMP playerMP, String command, Map<String, Argument> args) {
        boolean rc = super.execute(playerMP, command, args);
        if (rc) {
            return true;
        }
        if (CMD_SETTINGS.equals(command)) {
            for (int i = 0; i < 6; ++i) {
                char prefix = DUNSWE.charAt(i);
                this.inputModeOn[i] = args.get(prefix + "InOn").getBoolean();
                this.inputModeOff[i] = args.get(prefix + "InOff").getBoolean();
                this.rfOn[i] = args.get(prefix + "On").getInteger();
                this.rfOff[i] = args.get(prefix + "Off").getInteger();
            }
            this.markDirtyClient();
            return true;
        }
        return false;
    }
}

