/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftools.blocks.logic.invchecker;

import java.awt.Rectangle;
import mcjty.lib.base.ModBase;
import mcjty.lib.container.GenericGuiContainer;
import mcjty.lib.entity.GenericTileEntity;
import mcjty.lib.gui.Window;
import mcjty.lib.gui.events.ChoiceEvent;
import mcjty.lib.gui.events.TextEvent;
import mcjty.lib.gui.layout.HorizontalAlignment;
import mcjty.lib.gui.layout.Layout;
import mcjty.lib.gui.layout.LayoutHint;
import mcjty.lib.gui.layout.PositionalLayout;
import mcjty.lib.gui.widgets.ChoiceLabel;
import mcjty.lib.gui.widgets.Label;
import mcjty.lib.gui.widgets.Panel;
import mcjty.lib.gui.widgets.TextField;
import mcjty.lib.gui.widgets.Widget;
import mcjty.lib.network.Argument;
import mcjty.rftools.RFTools;
import mcjty.rftools.blocks.logic.invchecker.InvCheckerContainer;
import mcjty.rftools.blocks.logic.invchecker.InvCheckerTileEntity;
import mcjty.rftools.network.RFToolsMessages;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.inventory.Container;
import net.minecraft.util.ResourceLocation;

public class GuiInvChecker
extends GenericGuiContainer<InvCheckerTileEntity> {
    public static final int INVCHECKER_WIDTH = 180;
    public static final int INVCHECKER_HEIGHT = 152;
    public static final String OREDICT_USE = "Use";
    public static final String OREDICT_IGNORE = "Ignore";
    public static final String META_MATCH = "Match";
    public static final String META_IGNORE = "Ignore";
    private TextField amountField;
    private TextField slotField;
    private ChoiceLabel oreDictLabel;
    private ChoiceLabel metaLabel;
    private static final ResourceLocation iconLocation = new ResourceLocation("rftools", "textures/gui/invchecker.png");

    public GuiInvChecker(InvCheckerTileEntity invCheckerTileEntity, InvCheckerContainer container) {
        super((ModBase)RFTools.instance, RFToolsMessages.INSTANCE, (GenericTileEntity)invCheckerTileEntity, (Container)container, RFTools.GUI_MANUAL_MAIN, "invchecker");
        this.field_146999_f = 180;
        this.field_147000_g = 152;
    }

    public void func_73866_w_() {
        super.func_73866_w_();
        Panel toplevel = ((Panel)new Panel(this.field_146297_k, (Gui)this).setBackground(iconLocation)).setLayout((Layout)new PositionalLayout());
        this.amountField = ((TextField)((TextField)new TextField(this.field_146297_k, (Gui)this).setTooltips(new String[]{"Set the amount of items in slot"})).setLayoutHint((LayoutHint)new PositionalLayout.PositionalHint(60, 19, 80, 14))).addTextEvent(new TextEvent(){

            public void textChanged(Widget parent, String newText) {
                GuiInvChecker.this.setAmount();
            }
        });
        int amount = ((InvCheckerTileEntity)this.tileEntity).getAmount();
        this.amountField.setText(String.valueOf(amount));
        this.slotField = ((TextField)((TextField)new TextField(this.field_146297_k, (Gui)this).setTooltips(new String[]{"Set the slot index"})).setLayoutHint((LayoutHint)new PositionalLayout.PositionalHint(60, 3, 80, 14))).addTextEvent(new TextEvent(){

            public void textChanged(Widget parent, String newText) {
                GuiInvChecker.this.setSlot();
            }
        });
        int current = ((InvCheckerTileEntity)this.tileEntity).getSlot();
        this.slotField.setText(String.valueOf(current));
        this.metaLabel = new ChoiceLabel(this.field_146297_k, (Gui)this).addChoices(new String[]{"Ignore", META_MATCH}).addChoiceEvent(new ChoiceEvent(){

            public void choiceChanged(Widget parent, String newChoice) {
                GuiInvChecker.this.setMetaUsage();
            }
        }).setChoiceTooltip("Ignore", new String[]{"Ignore meta/damage on item"}).setChoiceTooltip(META_MATCH, new String[]{"Meta/damage on item must match"});
        this.metaLabel.setLayoutHint((LayoutHint)new PositionalLayout.PositionalHint(60, 35, 80, 14));
        this.metaLabel.setChoice(((InvCheckerTileEntity)this.tileEntity).isUseMeta() ? META_MATCH : META_IGNORE);
        this.oreDictLabel = new ChoiceLabel(this.field_146297_k, (Gui)this).addChoices(new String[]{"Ignore", OREDICT_USE}).addChoiceEvent(new ChoiceEvent(){

            public void choiceChanged(Widget parent, String newChoice) {
                GuiInvChecker.this.setOredictUsage();
            }
        }).setChoiceTooltip("Ignore", new String[]{"Ingore ore dictionary"}).setChoiceTooltip(OREDICT_USE, new String[]{"Use ore dictionary matching"});
        this.oreDictLabel.setLayoutHint((LayoutHint)new PositionalLayout.PositionalHint(60, 51, 80, 14));
        this.oreDictLabel.setChoice(((InvCheckerTileEntity)this.tileEntity).isOreDict() ? OREDICT_USE : OREDICT_IGNORE);
        ((Panel)((Panel)((Panel)((Panel)((Panel)((Panel)((Panel)toplevel.addChild((Widget)new Label(this.field_146297_k, (Gui)this).setText("Slot:").setHorizontalAlignment(HorizontalAlignment.ALIGH_LEFT).setLayoutHint((LayoutHint)new PositionalLayout.PositionalHint(10, 3, 50, 14)))).addChild((Widget)this.slotField)).addChild((Widget)new Label(this.field_146297_k, (Gui)this).setText("Amount:").setHorizontalAlignment(HorizontalAlignment.ALIGH_LEFT).setLayoutHint((LayoutHint)new PositionalLayout.PositionalHint(10, 19, 50, 14)))).addChild((Widget)this.amountField)).addChild((Widget)new Label(this.field_146297_k, (Gui)this).setText("Meta:").setHorizontalAlignment(HorizontalAlignment.ALIGH_LEFT).setLayoutHint((LayoutHint)new PositionalLayout.PositionalHint(10, 35, 50, 14)))).addChild((Widget)this.metaLabel)).addChild((Widget)new Label(this.field_146297_k, (Gui)this).setText("Oredict:").setHorizontalAlignment(HorizontalAlignment.ALIGH_LEFT).setLayoutHint((LayoutHint)new PositionalLayout.PositionalHint(10, 51, 50, 14)))).addChild((Widget)this.oreDictLabel);
        toplevel.setBounds(new Rectangle(this.field_147003_i, this.field_147009_r, this.field_146999_f, this.field_147000_g));
        this.window = new Window((GuiScreen)this, (Widget)toplevel);
    }

    private void setMetaUsage() {
        boolean b = META_MATCH.equals(this.metaLabel.getCurrentChoice());
        ((InvCheckerTileEntity)this.tileEntity).setUseMeta(b);
        this.sendServerCommand(RFToolsMessages.INSTANCE, "setUseMeta", new Argument[]{new Argument("b", b)});
    }

    private void setOredictUsage() {
        boolean b = OREDICT_USE.equals(this.oreDictLabel.getCurrentChoice());
        ((InvCheckerTileEntity)this.tileEntity).setOreDict(b);
        this.sendServerCommand(RFToolsMessages.INSTANCE, "setOreDict", new Argument[]{new Argument("b", b)});
    }

    private void setAmount() {
        int amount;
        String d = this.amountField.getText();
        try {
            amount = Integer.parseInt(d);
        }
        catch (NumberFormatException e) {
            amount = 1;
        }
        ((InvCheckerTileEntity)this.tileEntity).setAmount(amount);
        this.sendServerCommand(RFToolsMessages.INSTANCE, "setCounter", new Argument[]{new Argument("amount", amount)});
    }

    private void setSlot() {
        int slot;
        String d = this.slotField.getText();
        try {
            slot = Integer.parseInt(d);
        }
        catch (NumberFormatException e) {
            slot = 0;
        }
        ((InvCheckerTileEntity)this.tileEntity).setSlot(slot);
        this.sendServerCommand(RFToolsMessages.INSTANCE, "setSlot", new Argument[]{new Argument("slot", slot)});
    }

    protected void func_146976_a(float v, int i, int i2) {
        this.drawWindow();
    }
}

