/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftools.blocks.logic.generic;

import mcjty.lib.container.GenericItemBlock;
import mcjty.rftools.blocks.logic.generic.LogicFacing;
import mcjty.rftools.blocks.logic.generic.LogicSlabBlock;
import mcjty.rftools.blocks.logic.generic.LogicTileEntity;
import net.minecraft.block.Block;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class LogicItemBlock
extends GenericItemBlock {
    public LogicItemBlock(Block block) {
        super(block);
    }

    public boolean placeBlockAt(ItemStack stack, EntityPlayer player, World world, BlockPos pos, EnumFacing side, float hitX, float hitY, float hitZ, IBlockState newState) {
        boolean rc = super.placeBlockAt(stack, player, world, pos, side, hitX, hitY, hitZ, newState);
        TileEntity te = world.func_175625_s(pos);
        if (te instanceof LogicTileEntity) {
            LogicFacing facing;
            float dx = Math.abs(0.5f - hitX);
            float dy = Math.abs(0.5f - hitY);
            float dz = Math.abs(0.5f - hitZ);
            side = side.func_176734_d();
            switch (side) {
                case DOWN: {
                    if (dx < dz) {
                        facing = (double)hitZ < 0.5 ? LogicFacing.DOWN_TOSOUTH : LogicFacing.DOWN_TONORTH;
                        break;
                    }
                    facing = (double)hitX < 0.5 ? LogicFacing.DOWN_TOEAST : LogicFacing.DOWN_TOWEST;
                    break;
                }
                case UP: {
                    if (dx < dz) {
                        facing = (double)hitZ < 0.5 ? LogicFacing.UP_TOSOUTH : LogicFacing.UP_TONORTH;
                        break;
                    }
                    facing = (double)hitX < 0.5 ? LogicFacing.UP_TOEAST : LogicFacing.UP_TOWEST;
                    break;
                }
                case NORTH: {
                    if (dx < dy) {
                        facing = (double)hitY < 0.5 ? LogicFacing.NORTH_TOUP : LogicFacing.NORTH_TODOWN;
                        break;
                    }
                    facing = (double)hitX < 0.5 ? LogicFacing.NORTH_TOEAST : LogicFacing.NORTH_TOWEST;
                    break;
                }
                case SOUTH: {
                    if (dx < dy) {
                        facing = (double)hitY < 0.5 ? LogicFacing.SOUTH_TOUP : LogicFacing.SOUTH_TODOWN;
                        break;
                    }
                    facing = (double)hitX < 0.5 ? LogicFacing.SOUTH_TOEAST : LogicFacing.SOUTH_TOWEST;
                    break;
                }
                case WEST: {
                    if (dy < dz) {
                        facing = (double)hitZ < 0.5 ? LogicFacing.WEST_TOSOUTH : LogicFacing.WEST_TONORTH;
                        break;
                    }
                    facing = (double)hitY < 0.5 ? LogicFacing.WEST_TOUP : LogicFacing.WEST_TODOWN;
                    break;
                }
                case EAST: {
                    if (dy < dz) {
                        facing = (double)hitZ < 0.5 ? LogicFacing.EAST_TOSOUTH : LogicFacing.EAST_TONORTH;
                        break;
                    }
                    facing = (double)hitY < 0.5 ? LogicFacing.EAST_TOUP : LogicFacing.EAST_TODOWN;
                    break;
                }
                default: {
                    facing = LogicFacing.DOWN_TOWEST;
                }
            }
            LogicTileEntity logicTileEntity = (LogicTileEntity)te;
            logicTileEntity.setFacing(facing);
            world.func_180501_a(pos, newState.func_177230_c().func_176223_P().func_177226_a((IProperty)LogicSlabBlock.META_INTERMEDIATE, (Comparable)Integer.valueOf(facing.getMeta())).func_177226_a((IProperty)LogicSlabBlock.OUTPUTPOWER, (Comparable)Boolean.valueOf(false)), 3);
        }
        return rc;
    }
}

