/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftools.blocks.logic.counter;

import java.util.Map;
import mcjty.lib.network.Argument;
import mcjty.rftools.blocks.logic.generic.LogicTileEntity;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.nbt.NBTTagCompound;

public class CounterTileEntity
extends LogicTileEntity {
    public static final String CMD_SETCOUNTER = "setCounter";
    public static final String CMD_SETCURRENT = "setCurrent";
    private boolean prevIn = false;
    private int counter = 1;
    private int current = 0;

    public int getCounter() {
        return this.counter;
    }

    public int getCurrent() {
        return this.current;
    }

    public void setCounter(int counter) {
        this.counter = counter;
        this.current = 0;
        this.markDirtyClient();
    }

    public void setCurrent(int current) {
        this.current = current;
        this.markDirtyClient();
    }

    protected void update() {
        if (this.field_145850_b.field_72995_K) {
            return;
        }
        boolean pulse = this.powerLevel > 0 && !this.prevIn;
        this.prevIn = this.powerLevel > 0;
        boolean newout = false;
        if (pulse) {
            ++this.current;
            if (this.current >= this.counter) {
                this.current = 0;
                newout = true;
            }
            this.func_70296_d();
            this.setRedstoneState(newout);
        }
    }

    @Override
    public void func_145839_a(NBTTagCompound tagCompound) {
        super.func_145839_a(tagCompound);
        this.powered = tagCompound.func_74767_n("rs");
        this.prevIn = tagCompound.func_74767_n("prevIn");
    }

    public void readRestorableFromNBT(NBTTagCompound tagCompound) {
        super.readRestorableFromNBT(tagCompound);
        this.counter = tagCompound.func_74762_e("counter");
        if (this.counter == 0) {
            this.counter = 1;
        }
        this.current = tagCompound.func_74762_e("current");
    }

    @Override
    public NBTTagCompound func_189515_b(NBTTagCompound tagCompound) {
        super.func_189515_b(tagCompound);
        tagCompound.func_74757_a("rs", this.powered);
        tagCompound.func_74757_a("prevIn", this.prevIn);
        return tagCompound;
    }

    public void writeRestorableToNBT(NBTTagCompound tagCompound) {
        super.writeRestorableToNBT(tagCompound);
        tagCompound.func_74768_a("counter", this.counter);
        tagCompound.func_74768_a("current", this.current);
    }

    public boolean execute(EntityPlayerMP playerMP, String command, Map<String, Argument> args) {
        boolean rc = super.execute(playerMP, command, args);
        if (rc) {
            return true;
        }
        if (CMD_SETCOUNTER.equals(command)) {
            this.setCounter(args.get("counter").getInteger());
            return true;
        }
        if (CMD_SETCURRENT.equals(command)) {
            this.setCurrent(args.get("current").getInteger());
            return true;
        }
        return false;
    }
}

