/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftools.blocks.builder;

import io.netty.buffer.ByteBuf;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import mcjty.lib.network.NetworkTools;
import mcjty.lib.varia.BlockMeta;
import mcjty.rftools.RFTools;
import mcjty.rftools.items.builder.GuiChamberDetails;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityList;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.PacketBuffer;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;

public class PacketChamberInfoReady
implements IMessage {
    private Map<BlockMeta, Integer> blocks;
    private Map<BlockMeta, Integer> costs;
    private Map<BlockMeta, ItemStack> stacks;
    private Map<String, Integer> entities;
    private Map<String, Integer> entityCosts;
    private Map<String, Entity> realEntities;
    private Map<String, String> playerNames;
    private static final byte ENTITY_NONE = 0;
    private static final byte ENTITY_NORMAL = 1;
    private static final byte ENTITY_PLAYER = 2;

    public void fromBytes(ByteBuf buf) {
        int i;
        int size = buf.readInt();
        this.blocks = new HashMap<BlockMeta, Integer>(size);
        this.costs = new HashMap<BlockMeta, Integer>(size);
        this.stacks = new HashMap<BlockMeta, ItemStack>();
        for (i = 0; i < size; ++i) {
            int id = buf.readInt();
            byte meta = buf.readByte();
            int count = buf.readInt();
            int cost = buf.readInt();
            Block block = (Block)Block.field_149771_c.func_148754_a(id);
            BlockMeta bm = new BlockMeta(block, meta);
            this.blocks.put(bm, count);
            this.costs.put(bm, cost);
            if (!buf.readBoolean()) continue;
            ItemStack stack = NetworkTools.readItemStack((ByteBuf)buf);
            this.stacks.put(bm, stack);
        }
        size = buf.readInt();
        this.entities = new HashMap<String, Integer>(size);
        this.entityCosts = new HashMap<String, Integer>(size);
        this.realEntities = new HashMap<String, Entity>();
        this.playerNames = new HashMap<String, String>();
        for (i = 0; i < size; ++i) {
            String className = NetworkTools.readString((ByteBuf)buf);
            int count = buf.readInt();
            int cost = buf.readInt();
            this.entities.put(className, count);
            this.entityCosts.put(className, cost);
            byte how = buf.readByte();
            if (how == 1) {
                NBTTagCompound nbt = PacketChamberInfoReady.readNBT(buf);
                Entity entity = EntityList.func_75615_a((NBTTagCompound)nbt, (World)RFTools.proxy.getClientWorld());
                this.realEntities.put(className, entity);
                continue;
            }
            if (how != 2) continue;
            int entityId = buf.readInt();
            String entityName = NetworkTools.readString((ByteBuf)buf);
            Entity entity = RFTools.proxy.getClientWorld().func_73045_a(entityId);
            if (entity != null) {
                this.realEntities.put(className, entity);
            }
            this.playerNames.put(className, entityName);
        }
    }

    public void toBytes(ByteBuf buf) {
        buf.writeInt(this.blocks.size());
        for (Map.Entry<BlockMeta, Integer> entry : this.blocks.entrySet()) {
            BlockMeta bm = entry.getKey();
            Block block = bm.getBlock();
            buf.writeInt(Block.field_149771_c.func_148757_b((Object)block));
            buf.writeByte((int)bm.getMeta());
            buf.writeInt(entry.getValue().intValue());
            buf.writeInt(this.costs.get(bm).intValue());
            if (this.stacks.containsKey(bm)) {
                buf.writeBoolean(true);
                NetworkTools.writeItemStack((ByteBuf)buf, (ItemStack)this.stacks.get(bm));
                continue;
            }
            buf.writeBoolean(false);
        }
        buf.writeInt(this.entities.size());
        for (Map.Entry<Object, Integer> entry : this.entities.entrySet()) {
            String name = (String)entry.getKey();
            NetworkTools.writeString((ByteBuf)buf, (String)name);
            buf.writeInt(entry.getValue().intValue());
            buf.writeInt(this.entityCosts.get(name).intValue());
            if (this.realEntities.containsKey(name)) {
                Entity entity = this.realEntities.get(name);
                if (entity instanceof EntityPlayer) {
                    buf.writeByte(2);
                    int entityId = entity.func_145782_y();
                    buf.writeInt(entityId);
                    NetworkTools.writeString((ByteBuf)buf, (String)entity.func_145748_c_().func_150254_d());
                    continue;
                }
                buf.writeByte(1);
                NBTTagCompound nbt = entity.serializeNBT();
                PacketChamberInfoReady.writeNBT(buf, nbt);
                continue;
            }
            buf.writeByte(0);
        }
    }

    private static NBTTagCompound readNBT(ByteBuf dataIn) {
        PacketBuffer buf = new PacketBuffer(dataIn);
        try {
            return buf.func_150793_b();
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    private static void writeNBT(ByteBuf dataOut, NBTTagCompound nbt) {
        PacketBuffer buf = new PacketBuffer(dataOut);
        try {
            buf.func_150786_a(nbt);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public PacketChamberInfoReady() {
    }

    public PacketChamberInfoReady(Map<BlockMeta, Integer> blocks, Map<BlockMeta, Integer> costs, Map<BlockMeta, ItemStack> stacks, Map<String, Integer> entities, Map<String, Integer> entityCosts, Map<String, Entity> realEntities) {
        this.blocks = new HashMap<BlockMeta, Integer>(blocks);
        this.costs = new HashMap<BlockMeta, Integer>(costs);
        this.stacks = new HashMap<BlockMeta, ItemStack>(stacks);
        this.entities = new HashMap<String, Integer>(entities);
        this.entityCosts = new HashMap<String, Integer>(entityCosts);
        this.realEntities = new HashMap<String, Entity>(realEntities);
    }

    public static class Handler
    implements IMessageHandler<PacketChamberInfoReady, IMessage> {
        public IMessage onMessage(PacketChamberInfoReady message, MessageContext ctx) {
            RFTools.proxy.addScheduledTaskClient(() -> this.handle(message, ctx));
            return null;
        }

        private void handle(PacketChamberInfoReady message, MessageContext ctx) {
            GuiChamberDetails.setItemsWithCount(message.blocks, message.costs, message.stacks, message.entities, message.entityCosts, message.realEntities, message.playerNames);
        }
    }
}

