/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftools.blocks.builder;

import java.util.List;
import mcjty.lib.api.IModuleSupport;
import mcjty.lib.api.Infusable;
import mcjty.lib.container.GenericGuiContainer;
import mcjty.lib.varia.ModuleSupport;
import mcjty.rftools.Achievements;
import mcjty.rftools.RFTools;
import mcjty.rftools.blocks.GenericRFToolsBlock;
import mcjty.rftools.blocks.builder.BuilderContainer;
import mcjty.rftools.blocks.builder.BuilderSetup;
import mcjty.rftools.blocks.builder.BuilderTileEntity;
import mcjty.rftools.blocks.builder.GuiBuilder;
import mcjty.theoneprobe.api.IProbeHitData;
import mcjty.theoneprobe.api.IProbeInfo;
import mcjty.theoneprobe.api.ProbeMode;
import mcp.mobius.waila.api.IWailaConfigHandler;
import mcp.mobius.waila.api.IWailaDataAccessor;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.lwjgl.input.Keyboard;

public class BuilderBlock
extends GenericRFToolsBlock<BuilderTileEntity, BuilderContainer>
implements Infusable {
    private static long lastTime = 0L;

    public BuilderBlock() {
        super(Material.field_151573_f, BuilderTileEntity.class, BuilderContainer.class, "builder", true);
    }

    public boolean isHorizRotation() {
        return true;
    }

    public boolean needsRedstoneCheck() {
        return true;
    }

    @SideOnly(value=Side.CLIENT)
    public void addInformation(ItemStack itemStack, EntityPlayer player, List<String> list, boolean whatIsThis) {
        super.addInformation(itemStack, player, list, whatIsThis);
        if (Keyboard.isKeyDown((int)42) || Keyboard.isKeyDown((int)54)) {
            list.add(TextFormatting.WHITE + "This block is linked to a space chamber and");
            list.add(TextFormatting.WHITE + "can move/copy/swap the blocks from the space chamber");
            list.add(TextFormatting.WHITE + "to here. Insert a chamber card to make a link.");
            list.add(TextFormatting.YELLOW + "Infusing bonus: reduced power consumption and");
            list.add(TextFormatting.YELLOW + "increased building speed.");
        } else {
            list.add(TextFormatting.WHITE + "<Press Shift>");
        }
    }

    protected IModuleSupport getModuleSupport() {
        return new ModuleSupport(0){

            public boolean isModule(ItemStack itemStack) {
                return itemStack.func_77973_b() == BuilderSetup.shapeCardItem || itemStack.func_77973_b() == BuilderSetup.spaceChamberCardItem;
            }
        };
    }

    public void addProbeInfo(ProbeMode mode, IProbeInfo probeInfo, EntityPlayer player, World world, IBlockState blockState, IProbeHitData data) {
        super.addProbeInfo(mode, probeInfo, player, world, blockState, data);
        TileEntity te = world.func_175625_s(data.getPos());
        if (te instanceof BuilderTileEntity) {
            int scan = BuilderTileEntity.getCurrentLevel();
            probeInfo.text(TextFormatting.GREEN + "Current level: " + (scan == -1 ? "not scanning" : Integer.valueOf(scan)));
        }
    }

    @SideOnly(value=Side.CLIENT)
    public List<String> getWailaBody(ItemStack itemStack, List<String> currenttip, IWailaDataAccessor accessor, IWailaConfigHandler config) {
        super.getWailaBody(itemStack, currenttip, accessor, config);
        TileEntity te = accessor.getTileEntity();
        if (te instanceof BuilderTileEntity) {
            if (System.currentTimeMillis() - lastTime > 250L) {
                lastTime = System.currentTimeMillis();
                BuilderTileEntity builderTileEntity = (BuilderTileEntity)te;
                builderTileEntity.requestCurrentLevel();
            }
            int scan = BuilderTileEntity.getCurrentLevel();
            currenttip.add(TextFormatting.GREEN + "Current level: " + (scan == -1 ? "not scanning" : Integer.valueOf(scan)));
        }
        return currenttip;
    }

    public boolean rotateBlock(World world, BlockPos pos, EnumFacing axis) {
        BuilderTileEntity builderTileEntity;
        boolean rc = super.rotateBlock(world, pos, axis);
        TileEntity te = world.func_175625_s(pos);
        if (te instanceof BuilderTileEntity && !world.field_72995_K && (builderTileEntity = (BuilderTileEntity)te).hasSupportMode()) {
            builderTileEntity.clearSupportBlocks();
            builderTileEntity.resetBox();
        }
        return rc;
    }

    @SideOnly(value=Side.CLIENT)
    public Class<? extends GenericGuiContainer> getGuiClass() {
        return GuiBuilder.class;
    }

    public int getGuiID() {
        return RFTools.GUI_BUILDER;
    }

    public void func_180663_b(World world, BlockPos pos, IBlockState state) {
        BuilderTileEntity builderTileEntity;
        TileEntity te = world.func_175625_s(pos);
        if (te instanceof BuilderTileEntity && !world.field_72995_K && (builderTileEntity = (BuilderTileEntity)te).hasSupportMode()) {
            builderTileEntity.clearSupportBlocks();
        }
        super.func_180663_b(world, pos, state);
    }

    public void func_180633_a(World world, BlockPos pos, IBlockState state, EntityLivingBase placer, ItemStack stack) {
        super.func_180633_a(world, pos, state, placer, stack);
        if (placer instanceof EntityPlayer) {
            Achievements.trigger((EntityPlayer)placer, Achievements.theBuilder);
        }
    }
}

