/*
 * Decompiled with CFR 0.152.
 */
package refinedstorage.tile.grid;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.items.IItemHandler;
import refinedstorage.RefinedStorage;
import refinedstorage.api.network.grid.IItemGridHandler;
import refinedstorage.block.EnumGridType;
import refinedstorage.gui.grid.GridFilteredItem;
import refinedstorage.gui.grid.GuiGrid;
import refinedstorage.inventory.ItemHandlerBasic;
import refinedstorage.inventory.ItemHandlerGridFilterInGrid;
import refinedstorage.item.ItemWirelessGrid;
import refinedstorage.network.MessageWirelessGridSettingsUpdate;
import refinedstorage.tile.TileBase;
import refinedstorage.tile.TileController;
import refinedstorage.tile.data.TileDataParameter;
import refinedstorage.tile.grid.IGrid;

public class WirelessGrid
implements IGrid {
    private World world;
    private ItemStack stack;
    private BlockPos controller;
    private int viewType;
    private int sortingType;
    private int sortingDirection;
    private int searchBoxMode;
    private List<GridFilteredItem> filteredItems = new ArrayList<GridFilteredItem>();
    private ItemHandlerGridFilterInGrid filter = new ItemHandlerGridFilterInGrid(this.filteredItems){

        @Override
        protected void onContentsChanged(int slot) {
            super.onContentsChanged(slot);
            if (!((WirelessGrid)WirelessGrid.this).world.field_72995_K) {
                if (!WirelessGrid.this.stack.func_77942_o()) {
                    WirelessGrid.this.stack.func_77982_d(new NBTTagCompound());
                }
                TileBase.writeItems((IItemHandler)this, slot, WirelessGrid.this.stack.func_77978_p());
            }
        }
    };

    public WirelessGrid(World world, ItemStack stack) {
        this.world = world;
        this.stack = stack;
        this.controller = new BlockPos(ItemWirelessGrid.getX(stack), ItemWirelessGrid.getY(stack), ItemWirelessGrid.getZ(stack));
        this.viewType = ItemWirelessGrid.getViewType(stack);
        this.sortingType = ItemWirelessGrid.getSortingType(stack);
        this.sortingDirection = ItemWirelessGrid.getSortingDirection(stack);
        this.searchBoxMode = ItemWirelessGrid.getSearchBoxMode(stack);
        if (stack.func_77942_o()) {
            for (int i = 0; i < 4; ++i) {
                TileBase.readItems((IItemHandler)this.filter, i, stack.func_77978_p());
            }
        }
    }

    public ItemStack getStack() {
        return this.stack;
    }

    @Override
    public EnumGridType getType() {
        return EnumGridType.NORMAL;
    }

    @Override
    public BlockPos getNetworkPosition() {
        return this.controller;
    }

    @Override
    public IItemGridHandler getHandler() {
        TileController controller = this.getController();
        return controller != null ? controller.getItemGridHandler() : null;
    }

    @Override
    public int getViewType() {
        return this.viewType;
    }

    @Override
    public int getSortingType() {
        return this.sortingType;
    }

    @Override
    public int getSortingDirection() {
        return this.sortingDirection;
    }

    @Override
    public int getSearchBoxMode() {
        return this.searchBoxMode;
    }

    @Override
    public void onViewTypeChanged(int type) {
        RefinedStorage.INSTANCE.network.sendToServer((IMessage)new MessageWirelessGridSettingsUpdate(type, this.getSortingDirection(), this.getSortingType(), this.getSearchBoxMode()));
        this.viewType = type;
        GuiGrid.markForSorting();
    }

    @Override
    public void onSortingTypeChanged(int type) {
        RefinedStorage.INSTANCE.network.sendToServer((IMessage)new MessageWirelessGridSettingsUpdate(this.getViewType(), this.getSortingDirection(), type, this.getSearchBoxMode()));
        this.sortingType = type;
        GuiGrid.markForSorting();
    }

    @Override
    public void onSortingDirectionChanged(int direction) {
        RefinedStorage.INSTANCE.network.sendToServer((IMessage)new MessageWirelessGridSettingsUpdate(this.getViewType(), direction, this.getSortingType(), this.getSearchBoxMode()));
        this.sortingDirection = direction;
        GuiGrid.markForSorting();
    }

    @Override
    public void onSearchBoxModeChanged(int searchBoxMode) {
        RefinedStorage.INSTANCE.network.sendToServer((IMessage)new MessageWirelessGridSettingsUpdate(this.getViewType(), this.getSortingDirection(), this.getSortingType(), searchBoxMode));
        this.searchBoxMode = searchBoxMode;
    }

    @Override
    public List<GridFilteredItem> getFilteredItems() {
        return this.filteredItems;
    }

    @Override
    public ItemHandlerBasic getFilter() {
        return this.filter;
    }

    @Override
    public TileDataParameter<Integer> getRedstoneModeConfig() {
        return null;
    }

    @Override
    public boolean isConnected() {
        return true;
    }

    public void onClose(EntityPlayer player) {
        TileController controller = this.getController();
        if (controller != null) {
            controller.getWirelessGridHandler().onClose(player);
        }
    }

    private TileController getController() {
        TileEntity tile = this.world.func_175625_s(this.controller);
        return tile instanceof TileController ? (TileController)tile : null;
    }
}

