/*
 * Decompiled with CFR 0.152.
 */
package refinedstorage.tile.externalstorage;

import com.jaquadro.minecraft.storagedrawers.api.storage.IDrawer;
import com.jaquadro.minecraft.storagedrawers.api.storage.IDrawerGroup;
import java.util.ArrayList;
import java.util.List;
import mcmultipart.microblock.IMicroblock;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.items.IItemHandler;
import powercrystals.minefactoryreloaded.api.IDeepStorageUnit;
import refinedstorage.RefinedStorage;
import refinedstorage.api.network.INetworkMaster;
import refinedstorage.api.storage.IStorageProvider;
import refinedstorage.api.storage.item.IItemStorage;
import refinedstorage.inventory.IItemValidator;
import refinedstorage.inventory.ItemHandlerBasic;
import refinedstorage.tile.IStorageGui;
import refinedstorage.tile.TileMultipartNode;
import refinedstorage.tile.config.IComparable;
import refinedstorage.tile.config.IFilterable;
import refinedstorage.tile.config.IPrioritizable;
import refinedstorage.tile.data.ITileDataProducer;
import refinedstorage.tile.data.TileDataParameter;
import refinedstorage.tile.externalstorage.ItemStorageDSU;
import refinedstorage.tile.externalstorage.ItemStorageDrawer;
import refinedstorage.tile.externalstorage.ItemStorageExternal;
import refinedstorage.tile.externalstorage.ItemStorageItemHandler;

public class TileExternalStorage
extends TileMultipartNode
implements IStorageProvider,
IStorageGui,
IComparable,
IFilterable,
IPrioritizable {
    public static final TileDataParameter<Integer> PRIORITY = IPrioritizable.createParameter();
    public static final TileDataParameter<Integer> COMPARE = IComparable.createParameter();
    public static final TileDataParameter<Integer> MODE = IFilterable.createParameter();
    public static final TileDataParameter<Integer> STORED = new TileDataParameter<Integer>(DataSerializers.field_187192_b, 0, new ITileDataProducer<Integer, TileExternalStorage>(){

        @Override
        public Integer getValue(TileExternalStorage tile) {
            int stored = 0;
            for (ItemStorageExternal storage : tile.storages) {
                stored += storage.getStored();
            }
            return stored;
        }
    });
    public static final TileDataParameter<Integer> CAPACITY = new TileDataParameter<Integer>(DataSerializers.field_187192_b, 0, new ITileDataProducer<Integer, TileExternalStorage>(){

        @Override
        public Integer getValue(TileExternalStorage tile) {
            int capacity = 0;
            for (ItemStorageExternal storage : tile.storages) {
                capacity += storage.getCapacity();
            }
            return capacity;
        }
    });
    private static final String NBT_PRIORITY = "Priority";
    private static final String NBT_COMPARE = "Compare";
    private static final String NBT_MODE = "Mode";
    private ItemHandlerBasic filters = new ItemHandlerBasic(9, this, new IItemValidator[0]);
    private int priority = 0;
    private int compare = 0;
    private int mode = 0;
    private List<ItemStorageExternal> storages = new ArrayList<ItemStorageExternal>();
    private int lastDrawerCount;

    public TileExternalStorage() {
        this.dataManager.addWatchedParameter(PRIORITY);
        this.dataManager.addWatchedParameter(COMPARE);
        this.dataManager.addWatchedParameter(MODE);
        this.dataManager.addWatchedParameter(STORED);
        this.dataManager.addWatchedParameter(CAPACITY);
    }

    @Override
    public boolean canAddMicroblock(IMicroblock microblock) {
        return !TileExternalStorage.isBlockingMicroblock(microblock, this.getDirection());
    }

    @Override
    public int getEnergyUsage() {
        return RefinedStorage.INSTANCE.externalStorageUsage + this.storages.size() * RefinedStorage.INSTANCE.externalStoragePerStorageUsage;
    }

    @Override
    public void updateNode() {
    }

    @Override
    public void onConnectionChange(INetworkMaster network, boolean state) {
        super.onConnectionChange(network, state);
        this.updateStorage(network);
        network.getItemStorage().rebuild();
    }

    @Override
    public void func_73660_a() {
        if (!this.field_145850_b.field_72995_K && this.network != null) {
            boolean changeDetected = false;
            for (ItemStorageExternal storage : this.storages) {
                if (!storage.updateCache()) continue;
                changeDetected = true;
            }
            if (changeDetected) {
                this.network.getItemStorage().rebuild();
            }
            if (this.getFacingTile() instanceof IDrawerGroup && this.lastDrawerCount != ((IDrawerGroup)this.getFacingTile()).getDrawerCount()) {
                this.lastDrawerCount = ((IDrawerGroup)this.getFacingTile()).getDrawerCount();
                this.updateStorage(this.network);
            }
        }
        super.func_73660_a();
    }

    @Override
    public void read(NBTTagCompound tag) {
        super.read(tag);
        TileExternalStorage.readItems((IItemHandler)this.filters, 0, tag);
        if (tag.func_74764_b(NBT_PRIORITY)) {
            this.priority = tag.func_74762_e(NBT_PRIORITY);
        }
        if (tag.func_74764_b(NBT_COMPARE)) {
            this.compare = tag.func_74762_e(NBT_COMPARE);
        }
        if (tag.func_74764_b(NBT_MODE)) {
            this.mode = tag.func_74762_e(NBT_MODE);
        }
    }

    @Override
    public NBTTagCompound write(NBTTagCompound tag) {
        super.write(tag);
        TileExternalStorage.writeItems((IItemHandler)this.filters, 0, tag);
        tag.func_74768_a(NBT_PRIORITY, this.priority);
        tag.func_74768_a(NBT_COMPARE, this.compare);
        tag.func_74768_a(NBT_MODE, this.mode);
        return tag;
    }

    @Override
    public int getCompare() {
        return this.compare;
    }

    @Override
    public void setCompare(int compare) {
        this.compare = compare;
        this.func_70296_d();
    }

    @Override
    public int getMode() {
        return this.mode;
    }

    @Override
    public void setMode(int mode) {
        this.mode = mode;
        this.func_70296_d();
    }

    @Override
    public int getPriority() {
        return this.priority;
    }

    @Override
    public void setPriority(int priority) {
        this.priority = priority;
        this.func_70296_d();
    }

    public void updateStorage(INetworkMaster network) {
        this.storages.clear();
        TileEntity facing = this.getFacingTile();
        if (facing instanceof IDrawerGroup) {
            IDrawerGroup group = (IDrawerGroup)facing;
            for (int i = 0; i < group.getDrawerCount(); ++i) {
                if (!group.isDrawerEnabled(i)) continue;
                this.storages.add(new ItemStorageDrawer(this, group.getDrawer(i)));
            }
        } else if (facing instanceof IDrawer) {
            this.storages.add(new ItemStorageDrawer(this, (IDrawer)facing));
        } else if (facing instanceof IDeepStorageUnit) {
            this.storages.add(new ItemStorageDSU(this, (IDeepStorageUnit)facing));
        } else {
            IItemHandler handler = this.getItemHandler(facing, this.getDirection().func_176734_d());
            if (handler != null) {
                this.storages.add(new ItemStorageItemHandler(this, handler));
            }
        }
        network.getItemStorage().rebuild();
    }

    @Override
    public void addItemStorages(List<IItemStorage> storages) {
        storages.addAll(this.storages);
    }

    @Override
    public String getGuiTitle() {
        return "gui.refinedstorage:external_storage";
    }

    @Override
    public TileDataParameter<Integer> getRedstoneModeParameter() {
        return REDSTONE_MODE;
    }

    @Override
    public TileDataParameter<Integer> getCompareParameter() {
        return COMPARE;
    }

    @Override
    public TileDataParameter<Integer> getFilterParameter() {
        return MODE;
    }

    @Override
    public TileDataParameter<Integer> getPriorityParameter() {
        return PRIORITY;
    }

    @Override
    public int getStored() {
        return STORED.getValue();
    }

    @Override
    public int getCapacity() {
        return CAPACITY.getValue();
    }

    @Override
    public IItemHandler getFilters() {
        return this.filters;
    }
}

