/*
 * Decompiled with CFR 0.152.
 */
package refinedstorage.tile.externalstorage;

import com.jaquadro.minecraft.storagedrawers.api.storage.IDrawer;
import com.jaquadro.minecraft.storagedrawers.api.storage.attribute.IVoidable;
import java.util.Collections;
import java.util.List;
import net.minecraft.item.ItemStack;
import net.minecraftforge.items.ItemHandlerHelper;
import refinedstorage.api.storage.CompareUtils;
import refinedstorage.tile.config.IFilterable;
import refinedstorage.tile.externalstorage.ItemStorageExternal;
import refinedstorage.tile.externalstorage.TileExternalStorage;

public class ItemStorageDrawer
extends ItemStorageExternal {
    private TileExternalStorage externalStorage;
    private IDrawer drawer;

    public ItemStorageDrawer(TileExternalStorage externalStorage, IDrawer drawer) {
        this.externalStorage = externalStorage;
        this.drawer = drawer;
    }

    @Override
    public int getCapacity() {
        return this.drawer.getMaxCapacity();
    }

    @Override
    public List<ItemStack> getItems() {
        if (!this.drawer.isEmpty() && this.drawer.getStoredItemCount() > 0) {
            return Collections.singletonList(this.drawer.getStoredItemCopy());
        }
        return Collections.emptyList();
    }

    private boolean isVoidable() {
        return this.drawer instanceof IVoidable && ((IVoidable)((Object)this.drawer)).isVoid();
    }

    @Override
    public ItemStack insertItem(ItemStack stack, int size, boolean simulate) {
        if (IFilterable.canTake(this.externalStorage.getFilters(), this.externalStorage.getMode(), this.externalStorage.getCompare(), stack) && this.drawer.canItemBeStored(stack)) {
            if (!this.drawer.isEmpty()) {
                if (this.getStored() + size > this.drawer.getMaxCapacity(stack)) {
                    int remainingSpace = this.getCapacity() - this.getStored();
                    if (remainingSpace <= 0) {
                        return this.isVoidable() ? null : ItemHandlerHelper.copyStackWithSize((ItemStack)stack, (int)size);
                    }
                    if (!simulate) {
                        this.drawer.setStoredItemCount(this.drawer.getStoredItemCount() + remainingSpace);
                    }
                    return this.isVoidable() ? null : ItemHandlerHelper.copyStackWithSize((ItemStack)stack, (int)(size - remainingSpace));
                }
                if (!simulate) {
                    this.drawer.setStoredItemCount(this.drawer.getStoredItemCount() + size);
                }
                return null;
            }
            if (this.getStored() + size > this.drawer.getMaxCapacity(stack)) {
                int remainingSpace = this.getCapacity() - this.getStored();
                if (remainingSpace <= 0) {
                    return this.isVoidable() ? null : ItemHandlerHelper.copyStackWithSize((ItemStack)stack, (int)size);
                }
                if (!simulate) {
                    this.drawer.setStoredItem(stack, remainingSpace);
                }
                return this.isVoidable() ? null : ItemHandlerHelper.copyStackWithSize((ItemStack)stack, (int)(size - remainingSpace));
            }
            if (!simulate) {
                this.drawer.setStoredItem(stack, size);
            }
            return null;
        }
        return ItemHandlerHelper.copyStackWithSize((ItemStack)stack, (int)size);
    }

    @Override
    public ItemStack extractItem(ItemStack stack, int size, int flags) {
        if (CompareUtils.compareStack(stack, this.drawer.getStoredItemPrototype(), flags) && this.drawer.canItemBeExtracted(stack)) {
            if (size > this.drawer.getStoredItemCount()) {
                size = this.drawer.getStoredItemCount();
            }
            ItemStack stored = this.drawer.getStoredItemPrototype();
            this.drawer.setStoredItemCount(this.drawer.getStoredItemCount() - size);
            return ItemHandlerHelper.copyStackWithSize((ItemStack)stored, (int)size);
        }
        return null;
    }

    @Override
    public int getStored() {
        return this.drawer.getStoredItemCount();
    }

    @Override
    public int getPriority() {
        return this.externalStorage.getPriority();
    }
}

