/*
 * Decompiled with CFR 0.152.
 */
package refinedstorage.tile.externalstorage;

import java.util.Collections;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.item.ItemStack;
import net.minecraftforge.items.ItemHandlerHelper;
import powercrystals.minefactoryreloaded.api.IDeepStorageUnit;
import refinedstorage.api.storage.CompareUtils;
import refinedstorage.tile.config.IFilterable;
import refinedstorage.tile.externalstorage.ItemStorageExternal;
import refinedstorage.tile.externalstorage.TileExternalStorage;

public class ItemStorageDSU
extends ItemStorageExternal {
    private TileExternalStorage externalStorage;
    private IDeepStorageUnit unit;

    public ItemStorageDSU(TileExternalStorage externalStorage, IDeepStorageUnit unit) {
        this.externalStorage = externalStorage;
        this.unit = unit;
    }

    @Override
    public int getCapacity() {
        return this.unit.getMaxStoredCount();
    }

    @Override
    public List<ItemStack> getItems() {
        if (this.unit.getStoredItemType() != null && this.unit.getStoredItemType().field_77994_a > 0) {
            return Collections.singletonList(this.unit.getStoredItemType().func_77946_l());
        }
        return Collections.emptyList();
    }

    @Override
    public ItemStack insertItem(@Nonnull ItemStack stack, int size, boolean simulate) {
        if (IFilterable.canTake(this.externalStorage.getFilters(), this.externalStorage.getMode(), this.externalStorage.getCompare(), stack)) {
            if (this.unit.getStoredItemType() != null) {
                if (CompareUtils.compareStackNoQuantity(this.unit.getStoredItemType(), stack)) {
                    if (this.getStored() + size > this.unit.getMaxStoredCount()) {
                        int remainingSpace = this.getCapacity() - this.getStored();
                        if (remainingSpace <= 0) {
                            return ItemHandlerHelper.copyStackWithSize((ItemStack)stack, (int)size);
                        }
                        if (!simulate) {
                            this.unit.setStoredItemCount(this.unit.getStoredItemType().field_77994_a + remainingSpace);
                        }
                        return ItemHandlerHelper.copyStackWithSize((ItemStack)stack, (int)(size - remainingSpace));
                    }
                    if (!simulate) {
                        this.unit.setStoredItemCount(this.unit.getStoredItemType().field_77994_a + size);
                    }
                    return null;
                }
            } else {
                if (this.getStored() + size > this.unit.getMaxStoredCount()) {
                    int remainingSpace = this.getCapacity() - this.getStored();
                    if (remainingSpace <= 0) {
                        return ItemHandlerHelper.copyStackWithSize((ItemStack)stack, (int)size);
                    }
                    if (!simulate) {
                        this.unit.setStoredItemType(stack.func_77946_l(), remainingSpace);
                    }
                    return ItemHandlerHelper.copyStackWithSize((ItemStack)stack, (int)(size - remainingSpace));
                }
                if (!simulate) {
                    this.unit.setStoredItemType(stack.func_77946_l(), size);
                }
                return null;
            }
        }
        return ItemHandlerHelper.copyStackWithSize((ItemStack)stack, (int)size);
    }

    @Override
    public ItemStack extractItem(@Nonnull ItemStack stack, int size, int flags) {
        if (CompareUtils.compareStack(stack, this.unit.getStoredItemType(), flags)) {
            if (size > this.unit.getStoredItemType().field_77994_a) {
                size = this.unit.getStoredItemType().field_77994_a;
            }
            ItemStack stored = this.unit.getStoredItemType();
            this.unit.setStoredItemCount(stored.field_77994_a - size);
            return ItemHandlerHelper.copyStackWithSize((ItemStack)stored, (int)size);
        }
        return null;
    }

    @Override
    public int getStored() {
        return this.unit.getStoredItemType() != null ? this.unit.getStoredItemType().field_77994_a : 0;
    }

    @Override
    public int getPriority() {
        return this.externalStorage.getPriority();
    }
}

