/*
 * Decompiled with CFR 0.152.
 */
package refinedstorage.tile.data;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.inventory.Container;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import refinedstorage.RefinedStorage;
import refinedstorage.container.ContainerBase;
import refinedstorage.network.MessageTileDataParameter;
import refinedstorage.network.MessageTileDataParameterUpdate;
import refinedstorage.tile.TileBase;
import refinedstorage.tile.data.TileDataParameter;

public class TileDataManager {
    private static int LAST_ID = 0;
    private static Map<Integer, TileDataParameter> REGISTRY = new HashMap<Integer, TileDataParameter>();
    private List<TileDataParameter> parameters = new ArrayList<TileDataParameter>();
    private List<TileDataParameter> watchedParameters = new ArrayList<TileDataParameter>();
    private List<Object> watchedParametersCache = new ArrayList<Object>();
    private TileEntity tile;

    public static void registerParameter(TileDataParameter<?> parameter) {
        parameter.setId(LAST_ID);
        REGISTRY.put(LAST_ID++, parameter);
    }

    public static TileDataParameter<?> getParameter(int id) {
        return REGISTRY.get(id);
    }

    public static <T> void setParameter(TileDataParameter<T> parameter, T value) {
        RefinedStorage.INSTANCE.network.sendToServer((IMessage)new MessageTileDataParameterUpdate(parameter, value));
    }

    public TileDataManager(TileEntity tile) {
        this.tile = tile;
    }

    public void addParameter(TileDataParameter<?> parameter) {
        this.parameters.add(parameter);
    }

    public List<TileDataParameter> getParameters() {
        return this.parameters;
    }

    public void addWatchedParameter(TileDataParameter<?> parameter) {
        this.addParameter(parameter);
        this.watchedParameters.add(parameter);
        this.watchedParametersCache.add(null);
    }

    public void detectAndSendChanges() {
        for (int i = 0; i < this.watchedParameters.size(); ++i) {
            Object cached;
            TileDataParameter parameter = this.watchedParameters.get(i);
            Object real = parameter.getValueProducer().getValue(this.tile);
            if (real.equals(cached = this.watchedParametersCache.get(i))) continue;
            this.watchedParametersCache.set(i, real);
            this.sendParameterToWatchers(parameter);
        }
    }

    public void sendParametersTo(EntityPlayerMP player) {
        for (TileDataParameter parameter : this.parameters) {
            this.sendParameter(player, parameter);
        }
    }

    public void sendParameter(EntityPlayerMP player, TileDataParameter<?> parameter) {
        RefinedStorage.INSTANCE.network.sendTo((IMessage)new MessageTileDataParameter(this.tile, parameter), player);
    }

    public void sendParameterToWatchers(TileDataParameter<?> parameter) {
        for (EntityPlayer player : this.tile.func_145831_w().field_73010_i) {
            TileBase tile;
            Container container = player.field_71070_bA;
            if (!(container instanceof ContainerBase) || (tile = ((ContainerBase)container).getTile()) == null || !tile.func_174877_v().equals((Object)this.tile.func_174877_v())) continue;
            this.sendParameter((EntityPlayerMP)player, parameter);
        }
    }
}

