/*
 * Decompiled with CFR 0.152.
 */
package refinedstorage.tile.data;

import io.netty.buffer.ByteBuf;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.minecraft.item.ItemStack;
import net.minecraft.network.PacketBuffer;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraftforge.fml.common.network.ByteBufUtils;
import refinedstorage.tile.ClientCraftingTask;
import refinedstorage.tile.ClientNode;

public final class RefinedStorageSerializers {
    public static final DataSerializer<List<ClientNode>> CLIENT_NODE_SERIALIZER = new DataSerializer<List<ClientNode>>(){

        public void write(PacketBuffer buf, List<ClientNode> nodes) {
            buf.writeInt(nodes.size());
            for (ClientNode node : nodes) {
                ByteBufUtils.writeItemStack((ByteBuf)buf, (ItemStack)node.getStack());
                buf.writeInt(node.getAmount());
                buf.writeInt(node.getEnergyUsage());
            }
        }

        public List<ClientNode> read(PacketBuffer buf) throws IOException {
            ArrayList<ClientNode> nodes = new ArrayList<ClientNode>();
            int size = buf.readInt();
            for (int i = 0; i < size; ++i) {
                nodes.add(new ClientNode(ByteBufUtils.readItemStack((ByteBuf)buf), buf.readInt(), buf.readInt()));
            }
            return nodes;
        }

        public DataParameter<List<ClientNode>> func_187161_a(int id) {
            return null;
        }
    };
    public static final DataSerializer<List<ClientCraftingTask>> CLIENT_CRAFTING_TASK_SERIALIZER = new DataSerializer<List<ClientCraftingTask>>(){

        public void write(PacketBuffer buf, List<ClientCraftingTask> tasks) {
            buf.writeInt(tasks.size());
            for (ClientCraftingTask task : tasks) {
                ByteBufUtils.writeUTF8String((ByteBuf)buf, (String)task.getInfo());
                buf.writeInt(task.getOutputs().length);
                for (ItemStack output : task.getOutputs()) {
                    ByteBufUtils.writeItemStack((ByteBuf)buf, (ItemStack)output);
                }
            }
        }

        public List<ClientCraftingTask> read(PacketBuffer buf) throws IOException {
            int size = buf.readInt();
            ArrayList<ClientCraftingTask> tasks = new ArrayList<ClientCraftingTask>();
            for (int i = 0; i < size; ++i) {
                String info = ByteBufUtils.readUTF8String((ByteBuf)buf);
                int outputs = buf.readInt();
                for (int j = 0; j < outputs; ++j) {
                    tasks.add(new ClientCraftingTask(ByteBufUtils.readItemStack((ByteBuf)buf), i, info));
                }
            }
            Collections.reverse(tasks);
            return tasks;
        }

        public DataParameter<List<ClientCraftingTask>> func_187161_a(int id) {
            return null;
        }
    };
}

