/*
 * Decompiled with CFR 0.152.
 */
package refinedstorage.tile.config;

import net.minecraft.item.ItemStack;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.items.IItemHandler;
import refinedstorage.api.storage.CompareUtils;
import refinedstorage.tile.data.ITileDataConsumer;
import refinedstorage.tile.data.ITileDataProducer;
import refinedstorage.tile.data.TileDataParameter;

public interface IFilterable {
    public static final int WHITELIST = 0;
    public static final int BLACKLIST = 1;

    public static <T extends TileEntity> TileDataParameter<Integer> createParameter() {
        return new TileDataParameter<Integer>(DataSerializers.field_187192_b, 0, new ITileDataProducer<Integer, T>(){

            @Override
            public Integer getValue(T tile) {
                return ((IFilterable)tile).getMode();
            }
        }, new ITileDataConsumer<Integer, T>(){

            @Override
            public void setValue(T tile, Integer value) {
                if (value == 0 || value == 1) {
                    ((IFilterable)tile).setMode(value);
                }
            }
        });
    }

    public static boolean canTake(IItemHandler filters, int mode, int compare, ItemStack stack) {
        if (mode == 0) {
            int slots = 0;
            for (int i = 0; i < filters.getSlots(); ++i) {
                ItemStack slot = filters.getStackInSlot(i);
                if (slot == null) continue;
                ++slots;
                if (!CompareUtils.compareStack(slot, stack, compare)) continue;
                return true;
            }
            return slots == 0;
        }
        if (mode == 1) {
            for (int i = 0; i < filters.getSlots(); ++i) {
                ItemStack slot = filters.getStackInSlot(i);
                if (slot == null || !CompareUtils.compareStack(slot, stack, compare)) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public void setMode(int var1);

    public int getMode();
}

