/*
 * Decompiled with CFR 0.152.
 */
package refinedstorage.tile;

import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.wrapper.CombinedInvWrapper;
import refinedstorage.RefinedStorage;
import refinedstorage.api.RefinedStorageAPI;
import refinedstorage.api.network.INetworkMaster;
import refinedstorage.api.solderer.ISoldererRecipe;
import refinedstorage.api.storage.CompareUtils;
import refinedstorage.inventory.IItemValidator;
import refinedstorage.inventory.ItemHandlerBasic;
import refinedstorage.inventory.ItemHandlerSolderer;
import refinedstorage.inventory.ItemHandlerUpgrade;
import refinedstorage.tile.TileNode;
import refinedstorage.tile.data.ITileDataProducer;
import refinedstorage.tile.data.TileDataParameter;

public class TileSolderer
extends TileNode {
    public static final TileDataParameter<Integer> DURATION = new TileDataParameter<Integer>(DataSerializers.field_187192_b, 0, new ITileDataProducer<Integer, TileSolderer>(){

        @Override
        public Integer getValue(TileSolderer tile) {
            return tile.recipe != null ? tile.recipe.getDuration() : 0;
        }
    });
    public static final TileDataParameter<Integer> PROGRESS = new TileDataParameter<Integer>(DataSerializers.field_187192_b, 0, new ITileDataProducer<Integer, TileSolderer>(){

        @Override
        public Integer getValue(TileSolderer tile) {
            return tile.progress;
        }
    });
    private static final String NBT_WORKING = "Working";
    private static final String NBT_PROGRESS = "Progress";
    private ItemHandlerBasic items = new ItemHandlerBasic(4, this, new IItemValidator[0]);
    private ItemHandlerUpgrade upgrades = new ItemHandlerUpgrade(4, (TileEntity)this, 2);
    private ItemHandlerSolderer[] itemsFacade = new ItemHandlerSolderer[EnumFacing.values().length];
    private ISoldererRecipe recipe;
    private boolean working = false;
    private int progress = 0;

    public TileSolderer() {
        this.dataManager.addWatchedParameter(DURATION);
        this.dataManager.addWatchedParameter(PROGRESS);
    }

    @Override
    public int getEnergyUsage() {
        return RefinedStorage.INSTANCE.soldererUsage + this.upgrades.getEnergyUsage();
    }

    @Override
    public void updateNode() {
        boolean wasWorking = this.working;
        if (this.items.getStackInSlot(1) == null && this.items.getStackInSlot(2) == null && this.items.getStackInSlot(3) == null) {
            this.stop();
        } else {
            ISoldererRecipe newRecipe = RefinedStorageAPI.SOLDERER_REGISTRY.getRecipe((IItemHandler)this.items);
            if (newRecipe == null) {
                this.stop();
            } else if (newRecipe != this.recipe) {
                boolean sameItem;
                boolean bl = sameItem = this.items.getStackInSlot(3) != null ? CompareUtils.compareStackNoQuantity(this.items.getStackInSlot(3), newRecipe.getResult()) : false;
                if (this.items.getStackInSlot(3) == null || sameItem && this.items.getStackInSlot((int)3).field_77994_a + newRecipe.getResult().field_77994_a <= this.items.getStackInSlot(3).func_77976_d()) {
                    this.recipe = newRecipe;
                    this.progress = 0;
                    this.working = true;
                    this.func_70296_d();
                }
            } else if (this.working) {
                this.progress += 1 + this.upgrades.getUpgradeCount(2);
                if (this.progress >= this.recipe.getDuration()) {
                    if (this.items.getStackInSlot(3) != null) {
                        this.items.getStackInSlot((int)3).field_77994_a += this.recipe.getResult().field_77994_a;
                    } else {
                        this.items.setStackInSlot(3, this.recipe.getResult().func_77946_l());
                    }
                    for (int i = 0; i < 3; ++i) {
                        if (this.recipe.getRow(i) == null) continue;
                        this.items.extractItem(i, this.recipe.getRow((int)i).field_77994_a, false);
                    }
                    this.recipe = null;
                    this.progress = 0;
                    this.func_70296_d();
                }
            }
        }
        if (wasWorking != this.working) {
            this.updateBlock();
        }
    }

    @Override
    public void onConnectionChange(INetworkMaster network, boolean state) {
        super.onConnectionChange(network, state);
        if (!state) {
            this.stop();
        }
    }

    public void stop() {
        this.progress = 0;
        this.working = false;
        this.recipe = null;
        this.func_70296_d();
    }

    @Override
    public void read(NBTTagCompound tag) {
        super.read(tag);
        TileSolderer.readItems((IItemHandler)this.items, 0, tag);
        TileSolderer.readItems((IItemHandler)this.upgrades, 1, tag);
        this.recipe = RefinedStorageAPI.SOLDERER_REGISTRY.getRecipe((IItemHandler)this.items);
        if (tag.func_74764_b(NBT_WORKING)) {
            this.working = tag.func_74767_n(NBT_WORKING);
        }
        if (tag.func_74764_b(NBT_PROGRESS)) {
            this.progress = tag.func_74762_e(NBT_PROGRESS);
        }
    }

    @Override
    public NBTTagCompound write(NBTTagCompound tag) {
        super.write(tag);
        TileSolderer.writeItems((IItemHandler)this.items, 0, tag);
        TileSolderer.writeItems((IItemHandler)this.upgrades, 1, tag);
        tag.func_74757_a(NBT_WORKING, this.working);
        tag.func_74768_a(NBT_PROGRESS, this.progress);
        return tag;
    }

    @Override
    public NBTTagCompound writeUpdate(NBTTagCompound tag) {
        super.writeUpdate(tag);
        tag.func_74757_a(NBT_WORKING, this.working);
        return tag;
    }

    @Override
    public void readUpdate(NBTTagCompound tag) {
        this.working = tag.func_74767_n(NBT_WORKING);
        super.readUpdate(tag);
    }

    public boolean isWorking() {
        return this.working;
    }

    public ItemHandlerBasic getItems() {
        return this.items;
    }

    public IItemHandler getUpgrades() {
        return this.upgrades;
    }

    @Override
    public IItemHandler getDrops() {
        return new CombinedInvWrapper(new IItemHandlerModifiable[]{this.items, this.upgrades});
    }

    public <T> T getCapability(Capability<T> capability, EnumFacing facing) {
        if (capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            if (facing == null) {
                return (T)((Object)this.items);
            }
            int i = facing.ordinal();
            if (this.itemsFacade[i] == null) {
                this.itemsFacade[i] = new ItemHandlerSolderer(this, facing);
            }
            return (T)this.itemsFacade[i];
        }
        return (T)super.getCapability(capability, facing);
    }

    public boolean hasCapability(Capability<?> capability, EnumFacing facing) {
        return capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY || super.hasCapability(capability, facing);
    }
}

