/*
 * Decompiled with CFR 0.152.
 */
package refinedstorage.tile;

import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemHandlerHelper;
import refinedstorage.RefinedStorageItems;
import refinedstorage.inventory.IItemValidator;
import refinedstorage.inventory.ItemHandlerBasic;
import refinedstorage.inventory.ItemValidatorBasic;
import refinedstorage.item.ItemPattern;
import refinedstorage.tile.TileBase;

public class TileProcessingPatternEncoder
extends TileBase {
    private ItemHandlerBasic patterns = new ItemHandlerBasic(2, this, new ItemValidatorBasic(RefinedStorageItems.PATTERN));
    private ItemHandlerBasic configuration = new ItemHandlerBasic(18, this, new IItemValidator[0]);

    @Override
    public NBTTagCompound write(NBTTagCompound tag) {
        super.write(tag);
        TileProcessingPatternEncoder.writeItems((IItemHandler)this.patterns, 0, tag);
        TileProcessingPatternEncoder.writeItems((IItemHandler)this.configuration, 1, tag);
        return tag;
    }

    @Override
    public void read(NBTTagCompound tag) {
        super.read(tag);
        TileProcessingPatternEncoder.readItems((IItemHandler)this.patterns, 0, tag);
        TileProcessingPatternEncoder.readItems((IItemHandler)this.configuration, 1, tag);
    }

    public void onCreatePattern() {
        if (this.canCreatePattern()) {
            ItemStack pattern = new ItemStack((Item)RefinedStorageItems.PATTERN);
            ItemPattern.setProcessing(pattern, true);
            for (int i = 0; i < 18; ++i) {
                if (this.configuration.getStackInSlot(i) == null) continue;
                for (int j = 0; j < this.configuration.getStackInSlot((int)i).field_77994_a; ++j) {
                    if (i >= 9) {
                        ItemPattern.addOutput(pattern, ItemHandlerHelper.copyStackWithSize((ItemStack)this.configuration.getStackInSlot(i), (int)1));
                        continue;
                    }
                    ItemPattern.addInput(pattern, ItemHandlerHelper.copyStackWithSize((ItemStack)this.configuration.getStackInSlot(i), (int)1));
                }
            }
            this.patterns.extractItem(0, 1, false);
            this.patterns.setStackInSlot(1, pattern);
        }
    }

    public boolean canCreatePattern() {
        int i;
        int inputsFilled = 0;
        int outputsFilled = 0;
        for (i = 0; i < 9; ++i) {
            if (this.configuration.getStackInSlot(i) == null) continue;
            ++inputsFilled;
        }
        for (i = 9; i < 18; ++i) {
            if (this.configuration.getStackInSlot(i) == null) continue;
            ++outputsFilled;
        }
        return inputsFilled > 0 && outputsFilled > 0 && this.patterns.getStackInSlot(0) != null && this.patterns.getStackInSlot(1) == null;
    }

    public ItemHandlerBasic getPatterns() {
        return this.patterns;
    }

    public ItemHandlerBasic getConfiguration() {
        return this.configuration;
    }

    @Override
    public IItemHandler getDrops() {
        return this.patterns;
    }

    public <T> T getCapability(Capability<T> capability, EnumFacing facing) {
        if (capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            return (T)((Object)this.patterns);
        }
        return (T)super.getCapability(capability, facing);
    }

    public boolean hasCapability(Capability<?> capability, EnumFacing facing) {
        return capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY || super.hasCapability(capability, facing);
    }
}

