/*
 * Decompiled with CFR 0.152.
 */
package refinedstorage.tile;

import net.minecraft.block.Block;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import refinedstorage.api.network.INetworkMaster;
import refinedstorage.api.network.INetworkNode;
import refinedstorage.api.network.NetworkUtils;
import refinedstorage.block.BlockNode;
import refinedstorage.tile.TileBase;
import refinedstorage.tile.config.IRedstoneConfigurable;
import refinedstorage.tile.config.RedstoneMode;
import refinedstorage.tile.data.TileDataParameter;

public abstract class TileNode
extends TileBase
implements INetworkNode,
IRedstoneConfigurable {
    public static final TileDataParameter<Integer> REDSTONE_MODE = RedstoneMode.createParameter();
    private static final String NBT_CONNECTED = "Connected";
    private RedstoneMode redstoneMode = RedstoneMode.IGNORE;
    private boolean active;
    private boolean update;
    protected boolean rebuildOnUpdateChange;
    protected boolean connected;
    protected INetworkMaster network;

    public TileNode() {
        this.dataManager.addWatchedParameter(REDSTONE_MODE);
    }

    @Override
    public boolean canUpdate() {
        return this.redstoneMode.isEnabled(this.field_145850_b, this.field_174879_c);
    }

    public boolean isActive() {
        return this.isConnected() && this.canUpdate();
    }

    private boolean canSendConnectivityUpdate() {
        Block block = this.func_145838_q();
        return block instanceof BlockNode ? ((BlockNode)block).hasConnectivityState() : false;
    }

    @Override
    public void func_73660_a() {
        if (!this.field_145850_b.field_72995_K) {
            if (this.update != this.canUpdate() && this.network != null) {
                this.update = this.canUpdate();
                this.onConnectionChange(this.network, this.update);
                if (this.rebuildOnUpdateChange) {
                    NetworkUtils.rebuildGraph(this.network);
                }
            }
            if (this.active != this.isActive() && this.canSendConnectivityUpdate()) {
                this.updateBlock();
                this.active = this.isActive();
            }
            if (this.isActive()) {
                this.updateNode();
            }
        }
        super.func_73660_a();
    }

    @Override
    public void onConnected(INetworkMaster network) {
        this.connected = true;
        this.network = network;
        this.onConnectionChange(network, true);
    }

    @Override
    public void onDisconnected(INetworkMaster network) {
        this.onConnectionChange(network, false);
        this.connected = false;
        this.network = null;
    }

    @Override
    public void onConnectionChange(INetworkMaster network, boolean state) {
    }

    @Override
    public boolean canConduct(EnumFacing direction) {
        return true;
    }

    @Override
    public INetworkMaster getNetwork() {
        return this.network;
    }

    @Override
    public World getNodeWorld() {
        return this.field_145850_b;
    }

    @Override
    public BlockPos getPosition() {
        return this.field_174879_c;
    }

    @Override
    public boolean isConnected() {
        return this.connected;
    }

    public void setConnected(boolean connected) {
        this.connected = connected;
    }

    @Override
    public RedstoneMode getRedstoneMode() {
        return this.redstoneMode;
    }

    @Override
    public void setRedstoneMode(RedstoneMode mode) {
        this.redstoneMode = mode;
        this.func_70296_d();
    }

    @Override
    public void read(NBTTagCompound tag) {
        super.read(tag);
        if (tag.func_74764_b("RedstoneMode")) {
            this.redstoneMode = RedstoneMode.getById(tag.func_74762_e("RedstoneMode"));
        }
    }

    @Override
    public NBTTagCompound write(NBTTagCompound tag) {
        super.write(tag);
        tag.func_74768_a("RedstoneMode", this.redstoneMode.ordinal());
        return tag;
    }

    @Override
    public NBTTagCompound writeUpdate(NBTTagCompound tag) {
        super.writeUpdate(tag);
        if (this.canSendConnectivityUpdate()) {
            tag.func_74757_a(NBT_CONNECTED, this.isActive());
        }
        return tag;
    }

    @Override
    public void readUpdate(NBTTagCompound tag) {
        if (this.canSendConnectivityUpdate()) {
            this.connected = tag.func_74767_n(NBT_CONNECTED);
        }
        super.readUpdate(tag);
    }
}

