/*
 * Decompiled with CFR 0.152.
 */
package refinedstorage.tile;

import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.wrapper.CombinedInvWrapper;
import refinedstorage.RefinedStorage;
import refinedstorage.inventory.IItemValidator;
import refinedstorage.inventory.ItemHandlerBasic;
import refinedstorage.inventory.ItemHandlerUpgrade;
import refinedstorage.tile.TileNode;
import refinedstorage.tile.config.IComparable;
import refinedstorage.tile.data.TileDataParameter;

public class TileInterface
extends TileNode
implements IComparable {
    public static final TileDataParameter<Integer> COMPARE = IComparable.createParameter();
    private static final String NBT_COMPARE = "Compare";
    private ItemHandlerBasic importItems = new ItemHandlerBasic(9, this, new IItemValidator[0]);
    private ItemHandlerBasic exportSpecimenItems = new ItemHandlerBasic(9, this, new IItemValidator[0]);
    private ItemHandlerBasic exportItems = new ItemHandlerBasic(9, this, new IItemValidator[0]);
    private ItemHandlerUpgrade upgrades = new ItemHandlerUpgrade(4, (TileEntity)this, 2, 4);
    private int compare = 0;
    private int currentSlot = 0;

    public TileInterface() {
        this.dataManager.addWatchedParameter(COMPARE);
    }

    @Override
    public int getEnergyUsage() {
        return RefinedStorage.INSTANCE.interfaceUsage + this.upgrades.getEnergyUsage();
    }

    @Override
    public void updateNode() {
        ItemStack slot;
        if (this.currentSlot >= this.importItems.getSlots()) {
            this.currentSlot = 0;
        }
        if ((slot = this.importItems.getStackInSlot(this.currentSlot)) == null) {
            ++this.currentSlot;
        } else if (this.ticks % this.upgrades.getSpeed() == 0) {
            int size = Math.min(slot.field_77994_a, this.upgrades.hasUpgrade(4) ? 64 : 1);
            ItemStack remainder = this.network.insertItem(slot, size, false);
            if (remainder == null) {
                this.importItems.extractItem(this.currentSlot, size, false);
            } else {
                this.importItems.extractItem(this.currentSlot, size - remainder.field_77994_a, false);
            }
        }
        for (int i = 0; i < 9; ++i) {
            int delta;
            ItemStack wanted = this.exportSpecimenItems.getStackInSlot(i);
            ItemStack got = this.exportItems.getStackInSlot(i);
            if (wanted == null) {
                if (got == null) continue;
                this.exportItems.setStackInSlot(i, this.network.insertItem(got, got.field_77994_a, false));
                continue;
            }
            int n = delta = got == null ? wanted.field_77994_a : wanted.field_77994_a - got.field_77994_a;
            if (delta > 0) {
                ItemStack result = this.network.extractItem(wanted, delta, this.compare);
                if (result == null) continue;
                if (got == null) {
                    this.exportItems.setStackInSlot(i, result);
                    continue;
                }
                this.exportItems.getStackInSlot((int)i).field_77994_a += result.field_77994_a;
                continue;
            }
            if (delta >= 0) continue;
            ItemStack remainder = this.network.insertItem(got, Math.abs(delta), false);
            if (remainder == null) {
                this.exportItems.extractItem(i, Math.abs(delta), false);
                continue;
            }
            this.exportItems.extractItem(i, Math.abs(delta) - remainder.field_77994_a, false);
        }
    }

    @Override
    public int getCompare() {
        return this.compare;
    }

    @Override
    public void setCompare(int compare) {
        this.compare = compare;
        this.func_70296_d();
    }

    @Override
    public void read(NBTTagCompound tag) {
        super.read(tag);
        TileInterface.readItems((IItemHandler)this.importItems, 0, tag);
        TileInterface.readItems((IItemHandler)this.exportSpecimenItems, 1, tag);
        TileInterface.readItems((IItemHandler)this.exportItems, 2, tag);
        TileInterface.readItems((IItemHandler)this.upgrades, 3, tag);
        if (tag.func_74764_b(NBT_COMPARE)) {
            this.compare = tag.func_74762_e(NBT_COMPARE);
        }
    }

    @Override
    public NBTTagCompound write(NBTTagCompound tag) {
        super.write(tag);
        TileInterface.writeItems((IItemHandler)this.importItems, 0, tag);
        TileInterface.writeItems((IItemHandler)this.exportSpecimenItems, 1, tag);
        TileInterface.writeItems((IItemHandler)this.exportItems, 2, tag);
        TileInterface.writeItems((IItemHandler)this.upgrades, 3, tag);
        tag.func_74768_a(NBT_COMPARE, this.compare);
        return tag;
    }

    public IItemHandler getImportItems() {
        return this.importItems;
    }

    public IItemHandler getExportSpecimenItems() {
        return this.exportSpecimenItems;
    }

    public IItemHandler getExportItems() {
        return this.exportItems;
    }

    public IItemHandler getUpgrades() {
        return this.upgrades;
    }

    @Override
    public IItemHandler getDrops() {
        return new CombinedInvWrapper(new IItemHandlerModifiable[]{this.importItems, this.exportItems, this.upgrades});
    }

    public <T> T getCapability(Capability<T> capability, EnumFacing facing) {
        if (capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            if (facing == EnumFacing.DOWN) {
                return (T)((Object)this.exportItems);
            }
            return (T)((Object)this.importItems);
        }
        return (T)super.getCapability(capability, facing);
    }

    public boolean hasCapability(Capability<?> capability, EnumFacing facing) {
        return capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY || super.hasCapability(capability, facing);
    }
}

