/*
 * Decompiled with CFR 0.152.
 */
package refinedstorage.tile;

import mcmultipart.microblock.IMicroblock;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemHandlerHelper;
import refinedstorage.RefinedStorage;
import refinedstorage.apiimpl.autocrafting.CraftingTaskScheduler;
import refinedstorage.inventory.IItemValidator;
import refinedstorage.inventory.ItemHandlerBasic;
import refinedstorage.inventory.ItemHandlerUpgrade;
import refinedstorage.tile.TileMultipartNode;
import refinedstorage.tile.config.IComparable;
import refinedstorage.tile.data.TileDataParameter;

public class TileExporter
extends TileMultipartNode
implements IComparable {
    public static final TileDataParameter<Integer> COMPARE = IComparable.createParameter();
    private static final String NBT_COMPARE = "Compare";
    private ItemHandlerBasic filters = new ItemHandlerBasic(9, this, new IItemValidator[0]);
    private ItemHandlerUpgrade upgrades = new ItemHandlerUpgrade(4, (TileEntity)this, 2, 3, 4);
    private int compare = 0;
    private CraftingTaskScheduler scheduler = new CraftingTaskScheduler(this);

    public TileExporter() {
        this.dataManager.addWatchedParameter(COMPARE);
    }

    @Override
    public boolean canAddMicroblock(IMicroblock microblock) {
        return !TileExporter.isBlockingMicroblock(microblock, this.getDirection());
    }

    @Override
    public int getEnergyUsage() {
        return RefinedStorage.INSTANCE.exporterUsage + this.upgrades.getEnergyUsage();
    }

    @Override
    public void updateNode() {
        int size;
        IItemHandler handler = this.getItemHandler(this.getFacingTile(), this.getDirection().func_176734_d());
        int n = size = this.upgrades.hasUpgrade(4) ? 64 : 1;
        if (handler != null && this.ticks % this.upgrades.getSpeed() == 0) {
            for (int i = 0; i < this.filters.getSlots(); ++i) {
                ItemStack slot = this.filters.getStackInSlot(i);
                if (slot == null) continue;
                ItemStack took = this.network.extractItem(slot, size, this.compare);
                if (took != null) {
                    this.scheduler.resetSchedule();
                    ItemStack remainder = ItemHandlerHelper.insertItem((IItemHandler)handler, (ItemStack)took, (boolean)false);
                    if (remainder == null) continue;
                    this.network.insertItem(remainder, remainder.field_77994_a, false);
                    continue;
                }
                if (!this.upgrades.hasUpgrade(3) || !this.scheduler.canSchedule(this.compare, slot)) continue;
                this.scheduler.schedule(this.network, this.compare, slot);
            }
        }
    }

    @Override
    public int getCompare() {
        return this.compare;
    }

    @Override
    public void setCompare(int compare) {
        this.compare = compare;
        this.func_70296_d();
    }

    @Override
    public void read(NBTTagCompound tag) {
        super.read(tag);
        if (tag.func_74764_b(NBT_COMPARE)) {
            this.compare = tag.func_74762_e(NBT_COMPARE);
        }
        TileExporter.readItems((IItemHandler)this.filters, 0, tag);
        TileExporter.readItems((IItemHandler)this.upgrades, 1, tag);
        this.scheduler.read(tag);
    }

    @Override
    public NBTTagCompound write(NBTTagCompound tag) {
        super.write(tag);
        tag.func_74768_a(NBT_COMPARE, this.compare);
        TileExporter.writeItems((IItemHandler)this.filters, 0, tag);
        TileExporter.writeItems((IItemHandler)this.upgrades, 1, tag);
        this.scheduler.writeToNBT(tag);
        return tag;
    }

    public IItemHandler getFilters() {
        return this.filters;
    }

    public IItemHandler getUpgrades() {
        return this.upgrades;
    }

    @Override
    public IItemHandler getDrops() {
        return this.upgrades;
    }

    @Override
    public <T> T getCapability(Capability<T> capability, EnumFacing facing) {
        if (capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            return (T)((Object)this.upgrades);
        }
        return super.getCapability(capability, facing);
    }

    @Override
    public boolean hasCapability(Capability<?> capability, EnumFacing facing) {
        return capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY || super.hasCapability(capability, facing);
    }
}

