/*
 * Decompiled with CFR 0.152.
 */
package refinedstorage.tile;

import java.util.List;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemHandlerHelper;
import refinedstorage.RefinedStorage;
import refinedstorage.RefinedStorageItems;
import refinedstorage.api.network.INetworkMaster;
import refinedstorage.api.storage.IStorageProvider;
import refinedstorage.api.storage.item.IItemStorage;
import refinedstorage.apiimpl.storage.item.ItemStorageNBT;
import refinedstorage.block.EnumStorageType;
import refinedstorage.inventory.IItemValidator;
import refinedstorage.inventory.ItemHandlerBasic;
import refinedstorage.inventory.ItemValidatorBasic;
import refinedstorage.tile.IStorageGui;
import refinedstorage.tile.TileNode;
import refinedstorage.tile.config.IComparable;
import refinedstorage.tile.config.IFilterable;
import refinedstorage.tile.config.IPrioritizable;
import refinedstorage.tile.data.TileDataParameter;

public class TileDiskDrive
extends TileNode
implements IStorageProvider,
IStorageGui,
IComparable,
IFilterable,
IPrioritizable {
    public static final TileDataParameter<Integer> PRIORITY = IPrioritizable.createParameter();
    public static final TileDataParameter<Integer> COMPARE = IComparable.createParameter();
    public static final TileDataParameter<Integer> MODE = IFilterable.createParameter();
    private static final String NBT_PRIORITY = "Priority";
    private static final String NBT_COMPARE = "Compare";
    private static final String NBT_MODE = "Mode";
    private static final String NBT_STORED = "Stored";
    private ItemHandlerBasic disks = new ItemHandlerBasic(8, this, new IItemValidator[]{new ItemValidatorBasic(RefinedStorageItems.STORAGE_DISK){

        @Override
        public boolean isValid(ItemStack disk) {
            return super.isValid(disk) && ItemStorageNBT.isValid(disk);
        }
    }}){

        @Override
        protected void onContentsChanged(int slot) {
            super.onContentsChanged(slot);
            if (FMLCommonHandler.instance().getEffectiveSide() == Side.SERVER) {
                ItemStack disk = this.getStackInSlot(slot);
                ((TileDiskDrive)TileDiskDrive.this).storages[slot] = disk == null ? null : new ItemStorage(disk);
                if (TileDiskDrive.this.network != null) {
                    TileDiskDrive.this.network.getItemStorage().rebuild();
                }
            }
        }

        public ItemStack extractItem(int slot, int amount, boolean simulate) {
            if (TileDiskDrive.this.storages[slot] != null) {
                TileDiskDrive.this.storages[slot].writeToNBT();
            }
            return super.extractItem(slot, amount, simulate);
        }
    };
    private ItemHandlerBasic filters = new ItemHandlerBasic(9, this, new IItemValidator[0]);
    private ItemStorage[] storages = new ItemStorage[8];
    private int priority = 0;
    private int compare = 0;
    private int mode = 0;
    private int stored = 0;

    public TileDiskDrive() {
        this.dataManager.addWatchedParameter(PRIORITY);
        this.dataManager.addWatchedParameter(COMPARE);
        this.dataManager.addWatchedParameter(MODE);
    }

    @Override
    public void func_73660_a() {
        if (!this.field_145850_b.field_72995_K && this.stored != this.getStoredForDisplayServer()) {
            this.stored = this.getStoredForDisplayServer();
            this.updateBlock();
        }
        super.func_73660_a();
    }

    @Override
    public int getEnergyUsage() {
        int usage = RefinedStorage.INSTANCE.diskDriveUsage;
        for (int i = 0; i < this.disks.getSlots(); ++i) {
            if (this.disks.getStackInSlot(i) == null) continue;
            usage += RefinedStorage.INSTANCE.diskDrivePerDiskUsage;
        }
        return usage;
    }

    @Override
    public void updateNode() {
    }

    public void onBreak() {
        for (ItemStorage storage : this.storages) {
            if (storage == null) continue;
            storage.writeToNBT();
        }
    }

    @Override
    public void onConnectionChange(INetworkMaster network, boolean state) {
        super.onConnectionChange(network, state);
        network.getItemStorage().rebuild();
    }

    @Override
    public void addItemStorages(List<IItemStorage> storages) {
        for (ItemStorage storage : this.storages) {
            if (storage == null) continue;
            storages.add(storage);
        }
    }

    @Override
    public void read(NBTTagCompound tag) {
        super.read(tag);
        TileDiskDrive.readItems((IItemHandler)this.disks, 0, tag);
        TileDiskDrive.readItems((IItemHandler)this.filters, 1, tag);
        if (tag.func_74764_b(NBT_PRIORITY)) {
            this.priority = tag.func_74762_e(NBT_PRIORITY);
        }
        if (tag.func_74764_b(NBT_COMPARE)) {
            this.compare = tag.func_74762_e(NBT_COMPARE);
        }
        if (tag.func_74764_b(NBT_MODE)) {
            this.mode = tag.func_74762_e(NBT_MODE);
        }
    }

    @Override
    public NBTTagCompound write(NBTTagCompound tag) {
        super.write(tag);
        for (int i = 0; i < this.disks.getSlots(); ++i) {
            if (this.storages[i] == null) continue;
            this.storages[i].writeToNBT();
        }
        TileDiskDrive.writeItems((IItemHandler)this.disks, 0, tag);
        TileDiskDrive.writeItems((IItemHandler)this.filters, 1, tag);
        tag.func_74768_a(NBT_PRIORITY, this.priority);
        tag.func_74768_a(NBT_COMPARE, this.compare);
        tag.func_74768_a(NBT_MODE, this.mode);
        return tag;
    }

    @Override
    public NBTTagCompound writeUpdate(NBTTagCompound tag) {
        super.writeUpdate(tag);
        tag.func_74768_a(NBT_STORED, this.stored);
        return tag;
    }

    @Override
    public void readUpdate(NBTTagCompound tag) {
        this.stored = tag.func_74762_e(NBT_STORED);
        super.readUpdate(tag);
    }

    @Override
    public int getCompare() {
        return this.compare;
    }

    @Override
    public void setCompare(int compare) {
        this.compare = compare;
        this.func_70296_d();
    }

    @Override
    public int getMode() {
        return this.mode;
    }

    @Override
    public void setMode(int mode) {
        this.mode = mode;
        this.func_70296_d();
    }

    public int getStoredForDisplayServer() {
        float stored = 0.0f;
        float storedMax = 0.0f;
        for (int i = 0; i < this.disks.getSlots(); ++i) {
            ItemStack disk = this.disks.getStackInSlot(i);
            if (disk == null) continue;
            int capacity = EnumStorageType.getById(disk.func_77952_i()).getCapacity();
            if (capacity == -1) {
                return 0;
            }
            stored += (float)ItemStorageNBT.getStoredFromNBT(disk.func_77978_p());
            storedMax += (float)EnumStorageType.getById(disk.func_77952_i()).getCapacity();
        }
        if (storedMax == 0.0f) {
            return 0;
        }
        return (int)Math.floor(stored / storedMax * 7.0f);
    }

    public int getStoredForDisplay() {
        return this.stored;
    }

    @Override
    public String getGuiTitle() {
        return "block.refinedstorage:disk_drive.name";
    }

    @Override
    public IItemHandler getFilters() {
        return this.filters;
    }

    @Override
    public TileDataParameter<Integer> getRedstoneModeParameter() {
        return REDSTONE_MODE;
    }

    @Override
    public TileDataParameter<Integer> getCompareParameter() {
        return COMPARE;
    }

    @Override
    public TileDataParameter<Integer> getFilterParameter() {
        return MODE;
    }

    @Override
    public TileDataParameter<Integer> getPriorityParameter() {
        return PRIORITY;
    }

    @Override
    public int getPriority() {
        return this.priority;
    }

    @Override
    public void setPriority(int priority) {
        this.priority = priority;
        this.func_70296_d();
    }

    @Override
    public int getStored() {
        int stored = 0;
        for (int i = 0; i < this.disks.getSlots(); ++i) {
            ItemStack stack = this.disks.getStackInSlot(i);
            if (stack == null) continue;
            stored += ItemStorageNBT.getStoredFromNBT(stack.func_77978_p());
        }
        return stored;
    }

    @Override
    public int getCapacity() {
        int capacity = 0;
        for (int i = 0; i < this.disks.getSlots(); ++i) {
            ItemStack stack = this.disks.getStackInSlot(i);
            if (stack == null) continue;
            int diskCapacity = EnumStorageType.getById(stack.func_77952_i()).getCapacity();
            if (diskCapacity == -1) {
                return -1;
            }
            capacity += diskCapacity;
        }
        return capacity;
    }

    public IItemHandler getDisks() {
        return this.disks;
    }

    @Override
    public IItemHandler getDrops() {
        return this.disks;
    }

    public <T> T getCapability(Capability<T> capability, EnumFacing facing) {
        if (capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            return (T)((Object)this.disks);
        }
        return (T)super.getCapability(capability, facing);
    }

    public boolean hasCapability(Capability<?> capability, EnumFacing facing) {
        return capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY || super.hasCapability(capability, facing);
    }

    public class ItemStorage
    extends ItemStorageNBT {
        public ItemStorage(ItemStack disk) {
            super(disk.func_77978_p(), EnumStorageType.getById(disk.func_77952_i()).getCapacity(), TileDiskDrive.this);
        }

        @Override
        public int getPriority() {
            return TileDiskDrive.this.priority;
        }

        @Override
        public ItemStack insertItem(ItemStack stack, int size, boolean simulate) {
            if (!IFilterable.canTake(TileDiskDrive.this.getFilters(), TileDiskDrive.this.mode, TileDiskDrive.this.getCompare(), stack)) {
                return ItemHandlerHelper.copyStackWithSize((ItemStack)stack, (int)size);
            }
            return super.insertItem(stack, size, simulate);
        }
    }
}

