/*
 * Decompiled with CFR 0.152.
 */
package refinedstorage.tile;

import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.items.IItemHandler;
import refinedstorage.RefinedStorage;
import refinedstorage.RefinedStorageBlocks;
import refinedstorage.api.network.INetworkMaster;
import refinedstorage.gui.GuiDetector;
import refinedstorage.inventory.IItemValidator;
import refinedstorage.inventory.ItemHandlerBasic;
import refinedstorage.tile.TileNode;
import refinedstorage.tile.config.IComparable;
import refinedstorage.tile.config.RedstoneMode;
import refinedstorage.tile.data.ITileDataConsumer;
import refinedstorage.tile.data.ITileDataProducer;
import refinedstorage.tile.data.TileDataParameter;

public class TileDetector
extends TileNode
implements IComparable {
    public static final TileDataParameter<Integer> COMPARE = IComparable.createParameter();
    public static final TileDataParameter<Integer> MODE = new TileDataParameter<Integer>(DataSerializers.field_187192_b, 0, new ITileDataProducer<Integer, TileDetector>(){

        @Override
        public Integer getValue(TileDetector tile) {
            return tile.mode;
        }
    }, new ITileDataConsumer<Integer, TileDetector>(){

        @Override
        public void setValue(TileDetector tile, Integer value) {
            if (value == 0 || value == 1 || value == 2) {
                tile.mode = value;
                tile.func_70296_d();
            }
        }
    });
    public static final TileDataParameter<Integer> AMOUNT = new TileDataParameter<Integer>(DataSerializers.field_187192_b, 0, new ITileDataProducer<Integer, TileDetector>(){

        @Override
        public Integer getValue(TileDetector tile) {
            return tile.amount;
        }
    }, new ITileDataConsumer<Integer, TileDetector>(){

        @Override
        public void setValue(TileDetector tile, Integer value) {
            tile.amount = value;
            tile.func_70296_d();
        }
    }, parameter -> {
        GuiScreen gui;
        if (FMLCommonHandler.instance().getEffectiveSide() == Side.CLIENT && (gui = Minecraft.func_71410_x().field_71462_r) instanceof GuiDetector) {
            GuiDetector cfr_ignored_0 = (GuiDetector)gui;
            GuiDetector.AMOUNT.func_146180_a(String.valueOf(parameter.getValue()));
        }
    });
    private static final int SPEED = 5;
    public static final int MODE_UNDER = 0;
    public static final int MODE_EQUAL = 1;
    public static final int MODE_ABOVE = 2;
    private static final String NBT_COMPARE = "Compare";
    private static final String NBT_MODE = "Mode";
    private static final String NBT_AMOUNT = "Amount";
    private static final String NBT_POWERED = "Powered";
    private ItemHandlerBasic filter = new ItemHandlerBasic(1, this, new IItemValidator[0]);
    private int compare = 0;
    private int mode = 1;
    private int amount = 0;
    private boolean powered = false;
    private boolean wasPowered;

    public TileDetector() {
        this.dataManager.addWatchedParameter(COMPARE);
        this.dataManager.addWatchedParameter(MODE);
        this.dataManager.addWatchedParameter(AMOUNT);
    }

    @Override
    public int getEnergyUsage() {
        return RefinedStorage.INSTANCE.detectorUsage;
    }

    @Override
    public void updateNode() {
        if (this.ticks % 5 == 0) {
            ItemStack slot = this.filter.getStackInSlot(0);
            if (slot != null) {
                ItemStack stack = this.network.getItemStorage().get(slot, this.compare);
                if (stack != null) {
                    switch (this.mode) {
                        case 0: {
                            this.powered = stack.field_77994_a < this.amount;
                            break;
                        }
                        case 1: {
                            this.powered = stack.field_77994_a == this.amount;
                            break;
                        }
                        case 2: {
                            this.powered = stack.field_77994_a > this.amount;
                        }
                    }
                } else {
                    this.powered = this.mode == 0 && this.amount != 0 ? true : this.mode == 1 && this.amount == 0;
                }
            } else {
                this.powered = false;
            }
        }
    }

    @Override
    public void func_73660_a() {
        if (this.powered != this.wasPowered) {
            this.wasPowered = this.powered;
            this.field_145850_b.func_175685_c(this.field_174879_c, (Block)RefinedStorageBlocks.DETECTOR);
            this.updateBlock();
        }
        super.func_73660_a();
    }

    @Override
    public void onConnectionChange(INetworkMaster network, boolean state) {
        super.onConnectionChange(network, state);
        if (!state) {
            this.powered = false;
        }
    }

    public boolean isPowered() {
        return this.powered;
    }

    @Override
    public int getCompare() {
        return this.compare;
    }

    @Override
    public void setCompare(int compare) {
        this.compare = compare;
        this.func_70296_d();
    }

    @Override
    public void read(NBTTagCompound tag) {
        super.read(tag);
        if (tag.func_74764_b(NBT_COMPARE)) {
            this.compare = tag.func_74762_e(NBT_COMPARE);
        }
        if (tag.func_74764_b(NBT_MODE)) {
            this.mode = tag.func_74762_e(NBT_MODE);
        }
        if (tag.func_74764_b(NBT_AMOUNT)) {
            this.amount = tag.func_74762_e(NBT_AMOUNT);
        }
        TileDetector.readItems((IItemHandler)this.filter, 0, tag);
    }

    @Override
    public NBTTagCompound write(NBTTagCompound tag) {
        super.write(tag);
        tag.func_74768_a(NBT_COMPARE, this.compare);
        tag.func_74768_a(NBT_MODE, this.mode);
        tag.func_74768_a(NBT_AMOUNT, this.amount);
        TileDetector.writeItems((IItemHandler)this.filter, 0, tag);
        return tag;
    }

    @Override
    public void readUpdate(NBTTagCompound tag) {
        this.powered = tag.func_74767_n(NBT_POWERED);
        super.readUpdate(tag);
    }

    @Override
    public NBTTagCompound writeUpdate(NBTTagCompound tag) {
        super.writeUpdate(tag);
        tag.func_74757_a(NBT_POWERED, this.powered);
        return tag;
    }

    public IItemHandler getInventory() {
        return this.filter;
    }

    @Override
    public void setRedstoneMode(RedstoneMode mode) {
    }
}

