/*
 * Decompiled with CFR 0.152.
 */
package refinedstorage.tile;

import java.util.List;
import mcmultipart.microblock.IMicroblock;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.inventory.InventoryHelper;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import refinedstorage.RefinedStorage;
import refinedstorage.inventory.IItemValidator;
import refinedstorage.inventory.ItemHandlerBasic;
import refinedstorage.inventory.ItemHandlerUpgrade;
import refinedstorage.tile.TileMultipartNode;
import refinedstorage.tile.config.IComparable;
import refinedstorage.tile.config.IFilterable;
import refinedstorage.tile.data.TileDataParameter;

public class TileDestructor
extends TileMultipartNode
implements IComparable,
IFilterable {
    public static final TileDataParameter<Integer> COMPARE = IComparable.createParameter();
    public static final TileDataParameter<Integer> MODE = IFilterable.createParameter();
    private static final String NBT_COMPARE = "Compare";
    private static final String NBT_MODE = "Mode";
    private static final int BASE_SPEED = 20;
    private ItemHandlerBasic filters = new ItemHandlerBasic(9, this, new IItemValidator[0]);
    private ItemHandlerUpgrade upgrades = new ItemHandlerUpgrade(4, (TileEntity)this, 2);
    private int compare = 0;
    private int mode = 0;

    public TileDestructor() {
        this.dataManager.addWatchedParameter(COMPARE);
        this.dataManager.addWatchedParameter(MODE);
    }

    @Override
    public boolean canAddMicroblock(IMicroblock microblock) {
        return !TileDestructor.isBlockingMicroblock(microblock, this.getDirection());
    }

    @Override
    public int getEnergyUsage() {
        return RefinedStorage.INSTANCE.destructorUsage + this.upgrades.getEnergyUsage();
    }

    @Override
    public void updateNode() {
        BlockPos front;
        IBlockState frontBlockState;
        ItemStack frontStack;
        if (this.ticks % this.upgrades.getSpeed(20, 4) == 0 && (frontStack = (frontBlockState = this.field_145850_b.func_180495_p(front = this.field_174879_c.func_177972_a(this.getDirection()))).func_177230_c().func_185473_a(this.field_145850_b, front, frontBlockState)) != null && IFilterable.canTake((IItemHandler)this.filters, this.mode, this.compare, frontStack)) {
            List drops = frontBlockState.func_177230_c().getDrops((IBlockAccess)this.field_145850_b, front, frontBlockState, 0);
            this.field_145850_b.func_180498_a(null, 2001, front, Block.func_176210_f((IBlockState)frontBlockState));
            this.field_145850_b.func_175698_g(front);
            for (ItemStack drop : drops) {
                if (this.network == null) {
                    InventoryHelper.func_180173_a((World)this.field_145850_b, (double)front.func_177958_n(), (double)front.func_177956_o(), (double)front.func_177952_p(), (ItemStack)drop);
                    continue;
                }
                ItemStack remainder = this.network.insertItem(drop, drop.field_77994_a, false);
                if (remainder == null) continue;
                InventoryHelper.func_180173_a((World)this.field_145850_b, (double)front.func_177958_n(), (double)front.func_177956_o(), (double)front.func_177952_p(), (ItemStack)remainder);
            }
        }
    }

    @Override
    public int getCompare() {
        return this.compare;
    }

    @Override
    public void setCompare(int compare) {
        this.compare = compare;
        this.func_70296_d();
    }

    @Override
    public int getMode() {
        return this.mode;
    }

    @Override
    public void setMode(int mode) {
        this.mode = mode;
        this.func_70296_d();
    }

    @Override
    public void read(NBTTagCompound tag) {
        super.read(tag);
        if (tag.func_74764_b(NBT_COMPARE)) {
            this.compare = tag.func_74762_e(NBT_COMPARE);
        }
        if (tag.func_74764_b(NBT_MODE)) {
            this.mode = tag.func_74762_e(NBT_MODE);
        }
        TileDestructor.readItems((IItemHandler)this.filters, 0, tag);
        TileDestructor.readItems((IItemHandler)this.upgrades, 1, tag);
    }

    @Override
    public NBTTagCompound write(NBTTagCompound tag) {
        super.write(tag);
        tag.func_74768_a(NBT_COMPARE, this.compare);
        tag.func_74768_a(NBT_MODE, this.mode);
        TileDestructor.writeItems((IItemHandler)this.filters, 0, tag);
        TileDestructor.writeItems((IItemHandler)this.upgrades, 1, tag);
        return tag;
    }

    public IItemHandler getUpgrades() {
        return this.upgrades;
    }

    public IItemHandler getInventory() {
        return this.filters;
    }

    @Override
    public IItemHandler getDrops() {
        return this.upgrades;
    }

    @Override
    public <T> T getCapability(Capability<T> capability, EnumFacing facing) {
        if (capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            return (T)((Object)this.upgrades);
        }
        return super.getCapability(capability, facing);
    }

    @Override
    public boolean hasCapability(Capability<?> capability, EnumFacing facing) {
        return capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY || super.hasCapability(capability, facing);
    }
}

