/*
 * Decompiled with CFR 0.152.
 */
package refinedstorage.tile;

import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.wrapper.CombinedInvWrapper;
import refinedstorage.RefinedStorage;
import refinedstorage.RefinedStorageItems;
import refinedstorage.api.autocrafting.ICraftingPatternContainer;
import refinedstorage.api.network.INetworkMaster;
import refinedstorage.inventory.IItemValidator;
import refinedstorage.inventory.ItemHandlerBasic;
import refinedstorage.inventory.ItemHandlerUpgrade;
import refinedstorage.item.ItemPattern;
import refinedstorage.tile.TileNode;

public class TileCrafter
extends TileNode
implements ICraftingPatternContainer {
    private ItemHandlerBasic patterns = new ItemHandlerBasic(9, this, new IItemValidator[]{stack -> stack.func_77973_b() == RefinedStorageItems.PATTERN && ItemPattern.isValid(stack)}){

        @Override
        protected void onContentsChanged(int slot) {
            super.onContentsChanged(slot);
            if (TileCrafter.this.network != null) {
                TileCrafter.this.network.rebuildPatterns();
            }
        }
    };
    private ItemHandlerUpgrade upgrades = new ItemHandlerUpgrade(4, (TileEntity)this, 2);

    @Override
    public int getEnergyUsage() {
        int usage = RefinedStorage.INSTANCE.crafterUsage + this.upgrades.getEnergyUsage();
        for (int i = 0; i < this.patterns.getSlots(); ++i) {
            if (this.patterns.getStackInSlot(i) == null) continue;
            usage += RefinedStorage.INSTANCE.crafterPerPatternUsage;
        }
        return usage;
    }

    @Override
    public void updateNode() {
    }

    @Override
    public void onConnectionChange(INetworkMaster network, boolean state) {
        if (!state) {
            network.getCraftingTasks().stream().filter(task -> task.getPattern().getContainerPosition().equals((Object)this.field_174879_c)).forEach(network::cancelCraftingTask);
        }
        network.rebuildPatterns();
    }

    @Override
    public void read(NBTTagCompound tag) {
        super.read(tag);
        TileCrafter.readItems((IItemHandler)this.patterns, 0, tag);
        TileCrafter.readItems((IItemHandler)this.upgrades, 1, tag);
    }

    @Override
    public NBTTagCompound write(NBTTagCompound tag) {
        super.write(tag);
        TileCrafter.writeItems((IItemHandler)this.patterns, 0, tag);
        TileCrafter.writeItems((IItemHandler)this.upgrades, 1, tag);
        return tag;
    }

    @Override
    public int getSpeed() {
        return 20 - this.upgrades.getUpgradeCount(2) * 4;
    }

    @Override
    public IItemHandler getConnectedItems() {
        return this.getItemHandler(this.getFacingTile(), this.getDirection().func_176734_d());
    }

    public IItemHandler getPatterns() {
        return this.patterns;
    }

    public IItemHandler getUpgrades() {
        return this.upgrades;
    }

    @Override
    public IItemHandler getDrops() {
        return new CombinedInvWrapper(new IItemHandlerModifiable[]{this.patterns, this.upgrades});
    }

    public <T> T getCapability(Capability<T> capability, EnumFacing facing) {
        if (capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY && facing != this.getDirection()) {
            return (T)((Object)this.patterns);
        }
        return (T)super.getCapability(capability, facing);
    }

    public boolean hasCapability(Capability<?> capability, EnumFacing facing) {
        return capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY && facing != this.getDirection() || super.hasCapability(capability, facing);
    }
}

