/*
 * Decompiled with CFR 0.152.
 */
package refinedstorage.tile;

import cofh.api.energy.EnergyStorage;
import cofh.api.energy.IEnergyReceiver;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Stack;
import net.darkhax.tesla.capability.TeslaCapabilities;
import net.minecraft.block.Block;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.items.ItemHandlerHelper;
import refinedstorage.RefinedStorage;
import refinedstorage.RefinedStorageBlocks;
import refinedstorage.api.autocrafting.ICraftingPattern;
import refinedstorage.api.autocrafting.ICraftingPatternContainer;
import refinedstorage.api.autocrafting.ICraftingTask;
import refinedstorage.api.network.INetworkMaster;
import refinedstorage.api.network.INetworkNode;
import refinedstorage.api.network.INetworkNodeGraph;
import refinedstorage.api.network.IWirelessGridHandler;
import refinedstorage.api.network.NetworkUtils;
import refinedstorage.api.network.grid.IItemGridHandler;
import refinedstorage.api.storage.CompareUtils;
import refinedstorage.api.storage.item.IGroupedItemStorage;
import refinedstorage.api.storage.item.IItemStorage;
import refinedstorage.apiimpl.autocrafting.BasicCraftingTask;
import refinedstorage.apiimpl.autocrafting.CraftingPattern;
import refinedstorage.apiimpl.autocrafting.ProcessingCraftingTask;
import refinedstorage.apiimpl.network.ItemGridHandler;
import refinedstorage.apiimpl.network.NetworkNodeGraph;
import refinedstorage.apiimpl.network.WirelessGridHandler;
import refinedstorage.apiimpl.storage.item.GroupedItemStorage;
import refinedstorage.block.BlockController;
import refinedstorage.block.EnumControllerType;
import refinedstorage.container.ContainerGrid;
import refinedstorage.integration.ic2.ControllerEnergyIC2;
import refinedstorage.integration.ic2.ControllerEnergyIC2None;
import refinedstorage.integration.ic2.IControllerEnergyIC2;
import refinedstorage.integration.ic2.IntegrationIC2;
import refinedstorage.integration.tesla.ControllerEnergyTesla;
import refinedstorage.integration.tesla.IntegrationTesla;
import refinedstorage.item.ItemPattern;
import refinedstorage.network.MessageGridDelta;
import refinedstorage.network.MessageGridUpdate;
import refinedstorage.tile.ClientNode;
import refinedstorage.tile.TileBase;
import refinedstorage.tile.TileCrafter;
import refinedstorage.tile.TileCraftingMonitor;
import refinedstorage.tile.config.IRedstoneConfigurable;
import refinedstorage.tile.config.RedstoneMode;
import refinedstorage.tile.data.ITileDataProducer;
import refinedstorage.tile.data.RefinedStorageSerializers;
import refinedstorage.tile.data.TileDataParameter;
import refinedstorage.tile.externalstorage.ItemStorageExternal;

public class TileController
extends TileBase
implements INetworkMaster,
IEnergyReceiver,
IRedstoneConfigurable {
    public static final TileDataParameter<Integer> REDSTONE_MODE = RedstoneMode.createParameter();
    public static final TileDataParameter<Integer> ENERGY_USAGE = new TileDataParameter<Integer>(DataSerializers.field_187192_b, 0, new ITileDataProducer<Integer, TileController>(){

        @Override
        public Integer getValue(TileController tile) {
            return tile.getEnergyUsage();
        }
    });
    public static final TileDataParameter<Integer> ENERGY_STORED = new TileDataParameter<Integer>(DataSerializers.field_187192_b, 0, new ITileDataProducer<Integer, TileController>(){

        @Override
        public Integer getValue(TileController tile) {
            return tile.getEnergy().getEnergyStored();
        }
    });
    public static final TileDataParameter<Integer> ENERGY_CAPACITY = new TileDataParameter<Integer>(DataSerializers.field_187192_b, 0, new ITileDataProducer<Integer, TileController>(){

        @Override
        public Integer getValue(TileController tile) {
            return tile.getEnergy().getMaxEnergyStored();
        }
    });
    public static final TileDataParameter<List<ClientNode>> NODES = new TileDataParameter<List<ClientNode>>(RefinedStorageSerializers.CLIENT_NODE_SERIALIZER, new ArrayList(), new ITileDataProducer<List<ClientNode>, TileController>(){

        @Override
        public List<ClientNode> getValue(TileController tile) {
            ArrayList<ClientNode> nodes = new ArrayList<ClientNode>();
            block0: for (INetworkNode node : tile.nodeGraph.all()) {
                IBlockState state;
                ClientNode clientNode;
                if (!node.canUpdate() || (clientNode = new ClientNode(new ItemStack((state = tile.field_145850_b.func_180495_p(node.getPosition())).func_177230_c(), 1, state.func_177230_c().func_176201_c(state)), 1, node.getEnergyUsage())).getStack().func_77973_b() == null) continue;
                if (nodes.contains(clientNode)) {
                    for (ClientNode other : nodes) {
                        if (!other.equals(clientNode)) continue;
                        other.setAmount(other.getAmount() + 1);
                        continue block0;
                    }
                    continue;
                }
                nodes.add(clientNode);
            }
            return nodes;
        }
    });
    public static final String NBT_ENERGY = "Energy";
    public static final String NBT_ENERGY_CAPACITY = "EnergyCapacity";
    private static final String NBT_CRAFTING_TASKS = "CraftingTasks";
    private static final Comparator<IItemStorage> SIZE_COMPARATOR = (left, right) -> {
        if (left.getStored() == right.getStored()) {
            return 0;
        }
        return left.getStored() > right.getStored() ? -1 : 1;
    };
    private static final Comparator<IItemStorage> PRIORITY_COMPARATOR = (left, right) -> {
        if (left.getPriority() == right.getPriority()) {
            return 0;
        }
        return left.getPriority() > right.getPriority() ? -1 : 1;
    };
    private ItemGridHandler itemGridHandler = new ItemGridHandler(this);
    private WirelessGridHandler wirelessGridHandler = new WirelessGridHandler(this);
    private INetworkNodeGraph nodeGraph = new NetworkNodeGraph(this);
    private IGroupedItemStorage itemStorage = new GroupedItemStorage(this);
    private List<ICraftingPattern> patterns = new ArrayList<ICraftingPattern>();
    private Stack<ICraftingTask> craftingTasks = new Stack();
    private List<ICraftingTask> craftingTasksToAddAsLast = new ArrayList<ICraftingTask>();
    private List<ICraftingTask> craftingTasksToAdd = new ArrayList<ICraftingTask>();
    private List<ICraftingTask> craftingTasksToCancel = new ArrayList<ICraftingTask>();
    private EnergyStorage energy;
    private IControllerEnergyIC2 energyEU;
    private ControllerEnergyTesla energyTesla;
    private int lastEnergyDisplay;
    private int lastEnergyComparator;
    private boolean couldRun;
    private EnumControllerType type;
    private RedstoneMode redstoneMode;

    public TileController() {
        this.energy = new EnergyStorage(RefinedStorage.INSTANCE.controllerCapacity);
        this.redstoneMode = RedstoneMode.IGNORE;
        this.dataManager.addWatchedParameter(REDSTONE_MODE);
        this.dataManager.addWatchedParameter(ENERGY_USAGE);
        this.dataManager.addWatchedParameter(ENERGY_STORED);
        this.dataManager.addParameter(ENERGY_CAPACITY);
        this.dataManager.addParameter(NODES);
        this.energyEU = IntegrationIC2.isLoaded() ? new ControllerEnergyIC2(this) : new ControllerEnergyIC2None();
        if (IntegrationTesla.isLoaded()) {
            this.energyTesla = new ControllerEnergyTesla(this.energy);
        }
    }

    @Override
    public BlockPos getPosition() {
        return this.field_174879_c;
    }

    @Override
    public EnergyStorage getEnergy() {
        return this.energy;
    }

    @Override
    public boolean canRun() {
        return this.energy.getEnergyStored() > 0 && this.redstoneMode.isEnabled(this.field_145850_b, this.field_174879_c);
    }

    @Override
    public INetworkNodeGraph getNodeGraph() {
        return this.nodeGraph;
    }

    @Override
    public void func_73660_a() {
        if (!this.field_145850_b.field_72995_K) {
            this.energyEU.update();
            if (this.canRun()) {
                Collections.sort(this.itemStorage.getStorages(), SIZE_COMPARATOR);
                Collections.sort(this.itemStorage.getStorages(), PRIORITY_COMPARATOR);
                boolean craftingTasksChanged = !this.craftingTasksToAdd.isEmpty() || !this.craftingTasksToAddAsLast.isEmpty() || !this.craftingTasksToCancel.isEmpty();
                for (ICraftingTask taskToCancel : this.craftingTasksToCancel) {
                    taskToCancel.onCancelled(this);
                }
                this.craftingTasks.removeAll(this.craftingTasksToCancel);
                this.craftingTasksToCancel.clear();
                for (ICraftingTask task : this.craftingTasksToAdd) {
                    this.craftingTasks.push(task);
                }
                this.craftingTasksToAdd.clear();
                for (ICraftingTask task : this.craftingTasksToAddAsLast) {
                    this.craftingTasks.add(0, task);
                }
                this.craftingTasksToAddAsLast.clear();
                this.updateTopCraftingTask(true);
                if (craftingTasksChanged) {
                    this.updateCraftingTasks();
                }
            }
            this.wirelessGridHandler.update();
            if (this.getType() == EnumControllerType.NORMAL) {
                if (!RefinedStorage.INSTANCE.controllerUsesEnergy) {
                    this.energy.setEnergyStored(this.energy.getMaxEnergyStored());
                } else if (this.energy.getEnergyStored() - this.getEnergyUsage() >= 0) {
                    this.energy.extractEnergy(this.getEnergyUsage(), false);
                } else {
                    this.energy.setEnergyStored(0);
                }
            } else if (this.getType() == EnumControllerType.CREATIVE) {
                this.energy.setEnergyStored(this.energy.getMaxEnergyStored());
            }
            if (this.couldRun != this.canRun()) {
                this.couldRun = this.canRun();
                NetworkUtils.rebuildGraph(this);
            }
            if (this.getEnergyScaledForDisplay() != this.lastEnergyDisplay) {
                this.lastEnergyDisplay = this.getEnergyScaledForDisplay();
                this.updateBlock();
            }
            if (this.getEnergyScaledForComparator() != this.lastEnergyComparator) {
                this.lastEnergyComparator = this.getEnergyScaledForComparator();
                this.field_145850_b.func_175666_e(this.field_174879_c, (Block)RefinedStorageBlocks.CONTROLLER);
            }
        }
        super.func_73660_a();
    }

    private void updateCraftingTasks() {
        for (INetworkNode node : this.nodeGraph.all()) {
            if (!(node instanceof TileCraftingMonitor)) continue;
            ((TileCraftingMonitor)node).dataManager.sendParameterToWatchers(TileCraftingMonitor.TASKS);
        }
    }

    private void updateTopCraftingTask(boolean withSpeed) {
        if (!this.craftingTasks.empty()) {
            this.func_70296_d();
            ICraftingTask top = this.craftingTasks.peek();
            ICraftingPatternContainer container = top.getPattern().getContainer(this.field_145850_b);
            if (container != null && (!withSpeed || this.ticks % container.getSpeed() == 0) && top.update(this.field_145850_b, this)) {
                top.onDone(this);
                this.craftingTasks.pop();
                this.updateCraftingTasks();
            }
        }
    }

    public void func_145843_s() {
        this.energyEU.invalidate();
        super.func_145843_s();
    }

    @Override
    public IItemGridHandler getItemGridHandler() {
        return this.itemGridHandler;
    }

    @Override
    public IWirelessGridHandler getWirelessGridHandler() {
        return this.wirelessGridHandler;
    }

    public void onChunkUnload() {
        super.onChunkUnload();
        this.energyEU.onChunkUnload();
    }

    @Override
    public IGroupedItemStorage getItemStorage() {
        return this.itemStorage;
    }

    @Override
    public List<ICraftingTask> getCraftingTasks() {
        return this.craftingTasks;
    }

    @Override
    public void addCraftingTask(ICraftingTask task) {
        this.craftingTasksToAdd.add(task);
        this.func_70296_d();
    }

    @Override
    public void addCraftingTaskAsLast(ICraftingTask task) {
        this.craftingTasksToAddAsLast.add(task);
        this.func_70296_d();
    }

    @Override
    public ICraftingTask createCraftingTask(ICraftingPattern pattern) {
        if (pattern.isProcessing()) {
            return new ProcessingCraftingTask(pattern);
        }
        return new BasicCraftingTask(pattern);
    }

    @Override
    public void cancelCraftingTask(ICraftingTask task) {
        this.craftingTasksToCancel.add(task);
        this.func_70296_d();
    }

    @Override
    public List<ICraftingPattern> getPatterns() {
        return this.patterns;
    }

    @Override
    public List<ICraftingPattern> getPatterns(ItemStack pattern, int flags) {
        ArrayList<ICraftingPattern> patterns = new ArrayList<ICraftingPattern>();
        for (ICraftingPattern craftingPattern : this.getPatterns()) {
            for (ItemStack output : craftingPattern.getOutputs()) {
                if (!CompareUtils.compareStack(output, pattern, flags)) continue;
                patterns.add(craftingPattern);
            }
        }
        return patterns;
    }

    @Override
    public ICraftingPattern getPattern(ItemStack pattern, int flags) {
        List<ICraftingPattern> patterns = this.getPatterns(pattern, flags);
        if (patterns.isEmpty()) {
            return null;
        }
        if (patterns.size() == 1) {
            return patterns.get(0);
        }
        int highestScore = 0;
        int highestPattern = 0;
        for (int i = 0; i < patterns.size(); ++i) {
            int score = 0;
            for (ItemStack input : patterns.get(i).getInputs()) {
                ItemStack stored = this.itemStorage.get(input, 3);
                score += stored != null ? stored.field_77994_a : 0;
            }
            if (score <= highestScore) continue;
            highestScore = score;
            highestPattern = i;
        }
        return patterns.get(highestPattern);
    }

    @Override
    public void rebuildPatterns() {
        this.patterns.clear();
        for (INetworkNode node : this.nodeGraph.all()) {
            if (!(node instanceof TileCrafter) || !node.canUpdate()) continue;
            TileCrafter crafter = (TileCrafter)node;
            for (int i = 0; i < crafter.getPatterns().getSlots(); ++i) {
                ItemStack pattern = crafter.getPatterns().getStackInSlot(i);
                if (pattern == null || !ItemPattern.isValid(pattern)) continue;
                this.patterns.add(new CraftingPattern(crafter.func_174877_v(), ItemPattern.isProcessing(pattern), ItemPattern.getInputs(pattern), ItemPattern.getOutputs(pattern), ItemPattern.getByproducts(pattern)));
            }
        }
        this.itemStorage.rebuild();
    }

    @Override
    public void sendItemStorageToClient() {
        this.field_145850_b.func_73046_m().func_184103_al().func_181057_v().stream().filter(this::isWatchingGrid).forEach(this::sendItemStorageToClient);
    }

    @Override
    public void sendItemStorageToClient(EntityPlayerMP player) {
        RefinedStorage.INSTANCE.network.sendTo((IMessage)new MessageGridUpdate(this), player);
    }

    @Override
    public void sendItemStorageDeltaToClient(ItemStack stack, int delta) {
        this.field_145850_b.func_73046_m().func_184103_al().func_181057_v().stream().filter(this::isWatchingGrid).forEach(player -> RefinedStorage.INSTANCE.network.sendTo((IMessage)new MessageGridDelta(this, stack, delta), player));
    }

    private boolean isWatchingGrid(EntityPlayer player) {
        return player.field_71070_bA.getClass() == ContainerGrid.class && this.field_174879_c.equals((Object)((ContainerGrid)player.field_71070_bA).getGrid().getNetworkPosition());
    }

    @Override
    public ItemStack insertItem(ItemStack stack, int size, boolean simulate) {
        int inserted;
        if (stack == null || stack.func_77973_b() == null || this.itemStorage.getStorages().isEmpty()) {
            return ItemHandlerHelper.copyStackWithSize((ItemStack)stack, (int)size);
        }
        int orginalSize = size;
        ItemStack remainder = stack;
        for (IItemStorage storage : this.itemStorage.getStorages()) {
            remainder = storage.insertItem(remainder, size, simulate);
            if (storage instanceof ItemStorageExternal && !simulate) {
                ((ItemStorageExternal)storage).updateCacheForcefully();
            }
            if (remainder == null) break;
            size = remainder.field_77994_a;
        }
        int n = inserted = remainder != null ? orginalSize - remainder.field_77994_a : orginalSize;
        if (!simulate && inserted > 0) {
            for (int i = 0; i < inserted; ++i) {
                if (this.craftingTasks.empty() || !(this.craftingTasks.peek() instanceof ProcessingCraftingTask) || !((ProcessingCraftingTask)this.craftingTasks.peek()).onInserted(stack)) continue;
                this.updateTopCraftingTask(false);
            }
            this.itemStorage.add(ItemHandlerHelper.copyStackWithSize((ItemStack)stack, (int)inserted), false);
        }
        return remainder;
    }

    @Override
    public ItemStack extractItem(ItemStack stack, int size, int flags) {
        int requested = size;
        int received = 0;
        ItemStack newStack = null;
        for (IItemStorage storage : this.itemStorage.getStorages()) {
            ItemStack took = storage.extractItem(stack, requested - received, flags);
            if (took != null) {
                if (storage instanceof ItemStorageExternal) {
                    ((ItemStorageExternal)storage).updateCacheForcefully();
                }
                if (newStack == null) {
                    newStack = took;
                } else {
                    newStack.field_77994_a += took.field_77994_a;
                }
                received += took.field_77994_a;
            }
            if (requested != received) continue;
            break;
        }
        if (newStack != null) {
            this.itemStorage.remove(newStack);
        }
        return newStack;
    }

    @Override
    public void func_145839_a(NBTTagCompound tag) {
        super.func_145839_a(tag);
        this.energy.readFromNBT(tag);
        if (tag.func_74764_b("RedstoneMode")) {
            this.redstoneMode = RedstoneMode.getById(tag.func_74762_e("RedstoneMode"));
        }
        if (tag.func_74764_b(NBT_CRAFTING_TASKS)) {
            NBTTagList taskList = tag.func_150295_c(NBT_CRAFTING_TASKS, 10);
            block4: for (int i = 0; i < taskList.func_74745_c(); ++i) {
                NBTTagCompound taskTag = taskList.func_150305_b(i);
                CraftingPattern pattern = CraftingPattern.readFromNBT(taskTag.func_74775_l("Pattern"));
                if (pattern == null) continue;
                switch (taskTag.func_74762_e("Type")) {
                    case 0: {
                        this.addCraftingTask(new BasicCraftingTask(taskTag, pattern));
                        continue block4;
                    }
                    case 1: {
                        this.addCraftingTask(new ProcessingCraftingTask(taskTag, pattern));
                    }
                }
            }
        }
    }

    @Override
    public NBTTagCompound func_189515_b(NBTTagCompound tag) {
        super.func_189515_b(tag);
        this.energy.writeToNBT(tag);
        tag.func_74768_a("RedstoneMode", this.redstoneMode.ordinal());
        NBTTagList list = new NBTTagList();
        for (ICraftingTask task : this.craftingTasks) {
            NBTTagCompound taskTag = new NBTTagCompound();
            task.writeToNBT(taskTag);
            list.func_74742_a((NBTBase)taskTag);
        }
        tag.func_74782_a(NBT_CRAFTING_TASKS, (NBTBase)list);
        return tag;
    }

    @Override
    public NBTTagCompound writeUpdate(NBTTagCompound tag) {
        super.writeUpdate(tag);
        tag.func_74768_a(NBT_ENERGY_CAPACITY, this.energy.getMaxEnergyStored());
        tag.func_74768_a(NBT_ENERGY, this.energy.getEnergyStored());
        return tag;
    }

    @Override
    public void readUpdate(NBTTagCompound tag) {
        this.energy.setCapacity(tag.func_74762_e(NBT_ENERGY_CAPACITY));
        this.energy.setEnergyStored(tag.func_74762_e(NBT_ENERGY));
        super.readUpdate(tag);
    }

    @Override
    public int receiveEnergy(EnumFacing from, int maxReceive, boolean simulate) {
        return this.energy.receiveEnergy(maxReceive, simulate);
    }

    @Override
    public int getEnergyStored(EnumFacing from) {
        return this.energy.getEnergyStored();
    }

    public static int getEnergyScaled(int stored, int capacity, int scale) {
        return (int)((float)stored / (float)capacity * (float)scale);
    }

    public int getEnergyScaledForDisplay() {
        return TileController.getEnergyScaled(this.energy.getEnergyStored(), this.energy.getMaxEnergyStored(), 7);
    }

    public int getEnergyScaledForComparator() {
        return TileController.getEnergyScaled(this.energy.getEnergyStored(), this.energy.getMaxEnergyStored(), 15);
    }

    @Override
    public int getMaxEnergyStored(EnumFacing from) {
        return this.energy.getMaxEnergyStored();
    }

    @Override
    public boolean canConnectEnergy(EnumFacing from) {
        return true;
    }

    @Override
    public RedstoneMode getRedstoneMode() {
        return this.redstoneMode;
    }

    @Override
    public void setRedstoneMode(RedstoneMode mode) {
        this.redstoneMode = mode;
        this.func_70296_d();
    }

    @Override
    public int getEnergyUsage() {
        int usage = RefinedStorage.INSTANCE.controllerBaseUsage;
        for (INetworkNode node : this.nodeGraph.all()) {
            if (!node.canUpdate()) continue;
            usage += node.getEnergyUsage();
        }
        return usage;
    }

    public EnumControllerType getType() {
        if (this.type == null && this.field_145850_b.func_180495_p(this.field_174879_c).func_177230_c() == RefinedStorageBlocks.CONTROLLER) {
            this.type = (EnumControllerType)((Object)this.field_145850_b.func_180495_p(this.field_174879_c).func_177229_b((IProperty)BlockController.TYPE));
        }
        return this.type == null ? EnumControllerType.NORMAL : this.type;
    }

    public <T> T getCapability(Capability<T> capability, EnumFacing facing) {
        if (this.energyTesla != null && (capability == TeslaCapabilities.CAPABILITY_HOLDER || capability == TeslaCapabilities.CAPABILITY_CONSUMER)) {
            return (T)this.energyTesla;
        }
        return (T)super.getCapability(capability, facing);
    }

    public boolean hasCapability(Capability<?> capability, EnumFacing facing) {
        return this.energyTesla != null && (capability == TeslaCapabilities.CAPABILITY_HOLDER || capability == TeslaCapabilities.CAPABILITY_CONSUMER) || super.hasCapability(capability, facing);
    }
}

