/*
 * Decompiled with CFR 0.152.
 */
package refinedstorage.tile;

import mcmultipart.microblock.IMicroblock;
import net.minecraft.block.SoundType;
import net.minecraft.block.state.IBlockState;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import refinedstorage.RefinedStorage;
import refinedstorage.apiimpl.autocrafting.CraftingTaskScheduler;
import refinedstorage.container.slot.SlotSpecimen;
import refinedstorage.inventory.IItemValidator;
import refinedstorage.inventory.ItemHandlerBasic;
import refinedstorage.inventory.ItemHandlerUpgrade;
import refinedstorage.tile.TileMultipartNode;
import refinedstorage.tile.config.IComparable;
import refinedstorage.tile.data.TileDataParameter;

public class TileConstructor
extends TileMultipartNode
implements IComparable {
    public static final TileDataParameter<Integer> COMPARE = IComparable.createParameter();
    private static final String NBT_COMPARE = "Compare";
    private static final int BASE_SPEED = 20;
    private ItemHandlerBasic filter = new ItemHandlerBasic(1, this, new IItemValidator[0]){

        @Override
        protected void onContentsChanged(int slot) {
            super.onContentsChanged(slot);
            TileConstructor.this.block = SlotSpecimen.getBlockState((IBlockAccess)TileConstructor.this.field_145850_b, TileConstructor.this.field_174879_c.func_177972_a(TileConstructor.this.getDirection()), this.getStackInSlot(0));
        }
    };
    private ItemHandlerUpgrade upgrades = new ItemHandlerUpgrade(4, (TileEntity)this, 2, 3);
    private int compare = 0;
    private IBlockState block;
    private CraftingTaskScheduler scheduler = new CraftingTaskScheduler(this);

    public TileConstructor() {
        this.dataManager.addWatchedParameter(COMPARE);
    }

    @Override
    public boolean canAddMicroblock(IMicroblock microblock) {
        return !TileConstructor.isBlockingMicroblock(microblock, this.getDirection());
    }

    @Override
    public int getEnergyUsage() {
        return RefinedStorage.INSTANCE.constructorUsage + this.upgrades.getEnergyUsage();
    }

    @Override
    public void updateNode() {
        BlockPos front;
        if (this.block != null && this.ticks % this.upgrades.getSpeed(20, 4) == 0 && this.field_145850_b.func_175623_d(front = this.field_174879_c.func_177972_a(this.getDirection())) && this.block.func_177230_c().func_176196_c(this.field_145850_b, front)) {
            ItemStack craft;
            ItemStack took = this.network.extractItem(this.filter.getStackInSlot(0), 1, this.compare);
            if (took != null) {
                this.scheduler.resetSchedule();
                this.field_145850_b.func_180501_a(front, this.block.func_177230_c().func_176203_a(took.func_77960_j()), 3);
                SoundType blockSound = this.block.func_177230_c().func_185467_w();
                this.field_145850_b.func_184133_a(null, front, blockSound.func_185841_e(), SoundCategory.BLOCKS, (blockSound.func_185843_a() + 1.0f) / 2.0f, blockSound.func_185847_b() * 0.8f);
            } else if (this.upgrades.hasUpgrade(3) && this.scheduler.canSchedule(this.compare, craft = this.filter.getStackInSlot(0))) {
                this.scheduler.schedule(this.network, this.compare, craft);
            }
        }
    }

    @Override
    public int getCompare() {
        return this.compare;
    }

    @Override
    public void setCompare(int compare) {
        this.compare = compare;
        this.func_70296_d();
    }

    @Override
    public void read(NBTTagCompound tag) {
        super.read(tag);
        if (tag.func_74764_b(NBT_COMPARE)) {
            this.compare = tag.func_74762_e(NBT_COMPARE);
        }
        TileConstructor.readItems((IItemHandler)this.filter, 0, tag);
        TileConstructor.readItems((IItemHandler)this.upgrades, 1, tag);
        this.scheduler.read(tag);
    }

    @Override
    public NBTTagCompound write(NBTTagCompound tag) {
        super.write(tag);
        tag.func_74768_a(NBT_COMPARE, this.compare);
        TileConstructor.writeItems((IItemHandler)this.filter, 0, tag);
        TileConstructor.writeItems((IItemHandler)this.upgrades, 1, tag);
        this.scheduler.writeToNBT(tag);
        return tag;
    }

    public IItemHandler getUpgrades() {
        return this.upgrades;
    }

    public IItemHandler getFilter() {
        return this.filter;
    }

    @Override
    public IItemHandler getDrops() {
        return this.upgrades;
    }

    @Override
    public <T> T getCapability(Capability<T> capability, EnumFacing facing) {
        if (capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            return (T)((Object)this.upgrades);
        }
        return super.getCapability(capability, facing);
    }

    @Override
    public boolean hasCapability(Capability<?> capability, EnumFacing facing) {
        return capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY || super.hasCapability(capability, facing);
    }
}

