/*
 * Decompiled with CFR 0.152.
 */
package refinedstorage.network;

import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;
import refinedstorage.api.network.INetworkMaster;
import refinedstorage.gui.grid.ClientStack;
import refinedstorage.gui.grid.GuiGrid;

public class MessageGridUpdate
implements IMessage,
IMessageHandler<MessageGridUpdate, IMessage> {
    private INetworkMaster network;
    private List<ClientStack> items = new ArrayList<ClientStack>();

    public MessageGridUpdate() {
    }

    public MessageGridUpdate(INetworkMaster network) {
        this.network = network;
    }

    public void fromBytes(ByteBuf buf) {
        int items = buf.readInt();
        for (int i = 0; i < items; ++i) {
            this.items.add(new ClientStack(buf));
        }
    }

    public void toBytes(ByteBuf buf) {
        buf.writeInt(this.network.getItemStorage().getStacks().size());
        for (ItemStack stack : this.network.getItemStorage().getStacks()) {
            ClientStack.write(buf, this.network, stack);
        }
    }

    public IMessage onMessage(MessageGridUpdate message, MessageContext ctx) {
        GuiGrid.ITEMS.clear();
        for (ClientStack item : message.items) {
            GuiGrid.ITEMS.put((Object)item.getStack().func_77973_b(), (Object)item);
        }
        GuiGrid.markForSorting();
        return null;
    }
}

