/*
 * Decompiled with CFR 0.152.
 */
package refinedstorage.network;

import io.netty.buffer.ByteBuf;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;
import refinedstorage.api.network.INetworkMaster;
import refinedstorage.gui.grid.ClientStack;
import refinedstorage.gui.grid.GuiGrid;

public class MessageGridDelta
implements IMessage,
IMessageHandler<MessageGridDelta, IMessage> {
    private INetworkMaster network;
    private ItemStack stack;
    private int delta;
    private ClientStack clientStack;

    public MessageGridDelta() {
    }

    public MessageGridDelta(INetworkMaster network, ItemStack stack, int delta) {
        this.network = network;
        this.stack = stack;
        this.delta = delta;
    }

    public void fromBytes(ByteBuf buf) {
        this.clientStack = new ClientStack(buf);
        this.delta = buf.readInt();
    }

    public void toBytes(ByteBuf buf) {
        ClientStack.write(buf, this.network, this.stack);
        buf.writeInt(this.delta);
    }

    public IMessage onMessage(MessageGridDelta message, MessageContext ctx) {
        Item item = message.clientStack.getStack().func_77973_b();
        for (ClientStack stack : GuiGrid.ITEMS.get((Object)item)) {
            if (!stack.equals(message.clientStack)) continue;
            if (stack.getStack().field_77994_a + message.delta == 0 && !message.clientStack.isCraftable()) {
                GuiGrid.ITEMS.remove((Object)item, (Object)stack);
            } else {
                stack.getStack().field_77994_a += message.delta;
            }
            GuiGrid.markForSorting();
            return null;
        }
        GuiGrid.ITEMS.put((Object)item, (Object)message.clientStack);
        GuiGrid.markForSorting();
        return null;
    }
}

