/*
 * Decompiled with CFR 0.152.
 */
package refinedstorage.network;

import io.netty.buffer.ByteBuf;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraftforge.fml.common.network.ByteBufUtils;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import refinedstorage.block.EnumGridType;
import refinedstorage.container.ContainerGrid;
import refinedstorage.network.MessageHandlerPlayerToServer;
import refinedstorage.tile.grid.IGrid;
import refinedstorage.tile.grid.TileGrid;

public class MessageGridCraftingTransfer
extends MessageHandlerPlayerToServer<MessageGridCraftingTransfer>
implements IMessage {
    private NBTTagCompound recipe;

    public MessageGridCraftingTransfer() {
    }

    public MessageGridCraftingTransfer(NBTTagCompound recipe) {
        this.recipe = recipe;
    }

    public void fromBytes(ByteBuf buf) {
        this.recipe = ByteBufUtils.readTag((ByteBuf)buf);
    }

    public void toBytes(ByteBuf buf) {
        ByteBufUtils.writeTag((ByteBuf)buf, (NBTTagCompound)this.recipe);
    }

    @Override
    public void handle(MessageGridCraftingTransfer message, EntityPlayerMP player) {
        IGrid grid;
        if (player.field_71070_bA instanceof ContainerGrid && ((grid = ((ContainerGrid)player.field_71070_bA).getGrid()).getType() == EnumGridType.CRAFTING || grid.getType() == EnumGridType.PATTERN)) {
            ItemStack[][] actualRecipe = new ItemStack[9][];
            for (int x = 0; x < actualRecipe.length; ++x) {
                NBTTagList list = message.recipe.func_150295_c("#" + x, 10);
                if (list.func_74745_c() <= 0) continue;
                actualRecipe[x] = new ItemStack[list.func_74745_c()];
                for (int y = 0; y < list.func_74745_c(); ++y) {
                    actualRecipe[x][y] = ItemStack.func_77949_a((NBTTagCompound)list.func_150305_b(y));
                }
            }
            ((TileGrid)grid).onRecipeTransfer(actualRecipe);
        }
    }
}

