/*
 * Decompiled with CFR 0.152.
 */
package refinedstorage.item;

import java.util.HashSet;
import java.util.List;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumHand;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import refinedstorage.RefinedStorageItems;
import refinedstorage.api.storage.CompareUtils;
import refinedstorage.item.ItemBase;

public class ItemPattern
extends ItemBase {
    public static final String NBT_INPUTS = "Inputs";
    public static final String NBT_OUTPUTS = "Outputs";
    public static final String NBT_BYPRODUCTS = "Byproducts";
    public static final String NBT_PROCESSING = "Processing";

    public ItemPattern() {
        super("pattern");
    }

    public void func_77624_a(ItemStack pattern, EntityPlayer player, List<String> tooltip, boolean advanced) {
        if (ItemPattern.isValid(pattern)) {
            if (GuiScreen.func_146272_n() || ItemPattern.isProcessing(pattern)) {
                tooltip.add(TextFormatting.YELLOW + I18n.func_135052_a((String)"misc.refinedstorage:pattern.inputs", (Object[])new Object[0]) + TextFormatting.RESET);
                ItemPattern.combineItems(tooltip, true, ItemPattern.getInputs(pattern));
                tooltip.add(TextFormatting.YELLOW + I18n.func_135052_a((String)"misc.refinedstorage:pattern.outputs", (Object[])new Object[0]) + TextFormatting.RESET);
            }
            ItemPattern.combineItems(tooltip, true, ItemPattern.getOutputs(pattern));
        }
    }

    public static void combineItems(List<String> tooltip, boolean displayAmount, ItemStack ... stacks) {
        HashSet<Integer> combinedIndices = new HashSet<Integer>();
        for (int i = 0; i < stacks.length; ++i) {
            if (stacks[i] == null || combinedIndices.contains(i)) continue;
            String data = stacks[i].func_82833_r();
            int amount = stacks[i].field_77994_a;
            for (int j = i + 1; j < stacks.length; ++j) {
                if (!CompareUtils.compareStack(stacks[i], stacks[j])) continue;
                amount += stacks[j].field_77994_a;
                combinedIndices.add(j);
            }
            data = (displayAmount ? TextFormatting.WHITE + String.valueOf(amount) + " " : "") + TextFormatting.GRAY + data;
            tooltip.add(data);
        }
    }

    public ActionResult<ItemStack> func_77659_a(ItemStack stack, World world, EntityPlayer player, EnumHand hand) {
        if (!world.field_72995_K && player.func_70093_af()) {
            return new ActionResult(EnumActionResult.SUCCESS, (Object)new ItemStack((Item)RefinedStorageItems.PATTERN));
        }
        return new ActionResult(EnumActionResult.PASS, (Object)stack);
    }

    public static void addInput(ItemStack pattern, ItemStack stack) {
        ItemPattern.add(pattern, stack, NBT_INPUTS);
    }

    public static void addOutput(ItemStack pattern, ItemStack stack) {
        ItemPattern.add(pattern, stack, NBT_OUTPUTS);
    }

    public static void addByproduct(ItemStack pattern, ItemStack stack) {
        ItemPattern.add(pattern, stack, NBT_BYPRODUCTS);
    }

    private static void add(ItemStack pattern, ItemStack stack, String type) {
        if (pattern.func_77978_p() == null) {
            pattern.func_77982_d(new NBTTagCompound());
        }
        if (!pattern.func_77978_p().func_74764_b(type)) {
            pattern.func_77978_p().func_74782_a(type, (NBTBase)new NBTTagList());
        }
        pattern.func_77978_p().func_150295_c(type, 10).func_74742_a((NBTBase)stack.serializeNBT());
    }

    public static ItemStack[] getInputs(ItemStack pattern) {
        return ItemPattern.get(pattern, NBT_INPUTS);
    }

    public static ItemStack[] getOutputs(ItemStack pattern) {
        return ItemPattern.get(pattern, NBT_OUTPUTS);
    }

    public static ItemStack[] getByproducts(ItemStack pattern) {
        return ItemPattern.get(pattern, NBT_BYPRODUCTS);
    }

    private static ItemStack[] get(ItemStack pattern, String type) {
        if (!pattern.func_77942_o() || !pattern.func_77978_p().func_74764_b(type)) {
            return null;
        }
        NBTTagList stacksList = pattern.func_77978_p().func_150295_c(type, 10);
        ItemStack[] stacks = new ItemStack[stacksList.func_74745_c()];
        for (int i = 0; i < stacksList.func_74745_c(); ++i) {
            stacks[i] = ItemStack.func_77949_a((NBTTagCompound)stacksList.func_150305_b(i));
        }
        return stacks;
    }

    public static boolean isValid(ItemStack pattern) {
        if (!(pattern.func_77978_p() != null && pattern.func_77978_p().func_74764_b(NBT_INPUTS) && pattern.func_77978_p().func_74764_b(NBT_OUTPUTS) && pattern.func_77978_p().func_74764_b(NBT_PROCESSING))) {
            return false;
        }
        for (ItemStack input : ItemPattern.getInputs(pattern)) {
            if (input != null) continue;
            return false;
        }
        for (ItemStack output : ItemPattern.getOutputs(pattern)) {
            if (output != null) continue;
            return false;
        }
        ItemStack[] byproducts = ItemPattern.getByproducts(pattern);
        if (byproducts != null) {
            for (ItemStack byproduct : byproducts) {
                if (byproduct != null) continue;
                return false;
            }
        }
        return true;
    }

    public static void setProcessing(ItemStack pattern, boolean processing) {
        if (pattern.func_77978_p() == null) {
            pattern.func_77982_d(new NBTTagCompound());
        }
        pattern.func_77978_p().func_74757_a(NBT_PROCESSING, processing);
    }

    public static boolean isProcessing(ItemStack pattern) {
        if (!pattern.func_77942_o() || !pattern.func_77978_p().func_74764_b(NBT_PROCESSING)) {
            return false;
        }
        return pattern.func_77978_p().func_74767_n(NBT_PROCESSING);
    }
}

